/*
opis protokolu
Serwer oczekuje komunikatu w swojej skrzynce pocztowej. Typ komunikatu to
klucz skrzynki, do ktorej beda dane posylane. Komunikat powinien miec 4 bajty,
a w tych 4 bajtach bedzie zapisana wielkosc komunikatu z danymi.
Serwer posyla dane do skrzynki docelowej (o typie 1) i nasluchuje swoja
skrzynke w oczekiwaniu na komunikat typu "klucz do skrzynki docelowej" (bedzie
wiadomo, na ktore polaczenie przyszla odpowiedz).
Dane, jakie serwer posyla: cztery pierwsze bajty to ilosc bajtow, ktore nie sa
smieciami. Dalsze bajty to dane przeslane.
Na zakonczenie posylania danych serwer posyla komunikat z iloscia danych
rowna 0.
*/

#include <sys/ipc.h>
#include <sys/msg.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
#include <stdlib.h>
///////////////////////////////////
#include <errno.h>
#include <string.h>
#include <stdio.h>
//-------------------------------//
#include "msg_server.h"


int serwer_data_send(int klucz, char *co_przeslac)
{
int numer_bledu;
// skrzynki komunikatow
int skrzynka;
int polaczenie, klucz_polaczenia;   // tego sie dowiemy pozniej
// bufory
char *bufor, potwierdzenie[8];
int rozmiar_bufora;
// pliki
int plik;
int rozmiar_pliku;

//-----------------------------------------------------------------//

if ( ( skrzynka = msgget(klucz, 0666 | IPC_CREAT) ) == -1)
  {
  printf("Blad tworzenia skrzynki na potwierdzenia:\n%s\n",
         strerror((numer_bledu = errno)) );
  return numer_bledu;
  }
if ( ( plik = open(co_przeslac, O_RDONLY) ) == -1)
  {
  printf("Blad otwierania pliku \"%s\" do odczytu:\n%s\n", co_przeslac,
         strerror((numer_bledu = errno)) );
  msgctl(skrzynka, IPC_RMID, NULL);
  return numer_bledu;
  }

//-----------------------------------------------------------------//

// dowiadujemy sie, komu poslac dane z pliku i ile slac bajtow naraz
msgrcv(skrzynka, potwierdzenie, 4, 0/*typ:ALL*/, 0/*flagi*/);

// od razu otwieramy polaczenie
klucz_polaczenia = ((long*)potwierdzenie)[0];
if ( ( polaczenie = msgget(klucz_polaczenia, 0) ) == -1 )
  {
  printf("Blad otwierania skrzynki na dane:\n%s\n",
         strerror((numer_bledu = errno)) );
  msgctl(skrzynka, IPC_RMID, NULL);
  close(plik);
  return numer_bledu;
  }
// zapamietujemy wielkosc skrzynki odbiorczej
rozmiar_bufora = ((long*)potwierdzenie)[1];

bufor = malloc(rozmiar_bufora + 4); // 4B na typ komunikatu
rozmiar_bufora -= 4;

// ustalamy dlugosc pliku
rozmiar_pliku = lseek(plik, 0, SEEK_END);
lseek(plik, 0, SEEK_SET);

/*******************************************************************/

((long*)bufor)[0] = 1;
while (rozmiar_pliku >= rozmiar_bufora)
  {
  // wypelniamy pola: ile danych nie jest smieciami oraz same dane
  ((long*)bufor)[1] = rozmiar_bufora;
  read(plik, bufor + 8, rozmiar_bufora);
  // przesylamy dane
  msgsnd(polaczenie, bufor, rozmiar_bufora + 4, 0);
  // czekamy na potwierdzenie odbioru od konkretnej skrzynki
  msgrcv(skrzynka, potwierdzenie, 4, klucz_polaczenia, 0);
 
  rozmiar_pliku -= rozmiar_bufora; // do przeslania zostalo juz mniej danych
  }

// do wyslania zostal juz niepelny blok danych
if (rozmiar_pliku > 0)
  {
  read(plik, bufor + 8, rozmiar_pliku);
  ((long*)bufor)[1] = rozmiar_pliku;
  msgsnd(polaczenie, bufor, rozmiar_bufora + 4, 0);
  msgrcv(skrzynka, potwierdzenie, 4, klucz_polaczenia, 0);
  }

// wysylamy znak zakonczenia transferu - dane z zerowa iloscia nie-smieci
((long*)bufor)[1] = 0;
msgsnd(polaczenie, bufor, rozmiar_bufora + 4, 0);

/*******************************************************************/

free(bufor);
close(plik);
msgctl(skrzynka, IPC_RMID, NULL);
return 0;
}

