/* Program ma zamieniac liczbe zapisana w jednym systemie na inny system */
#include <stdio.h>

/* Definicje funkcji "pomocniczych" napisalem dalej, zeby zwiekszyc czytelnosc
 * zastosowanego algorytmu */
void shift(char *, int); /* przesuwa liczbe o zadana ilosc miejsc,
                          * wstawiajac na poczatku zera */
void razy (char *, int, int sys); /* mnozy liczbe w systemie sys przez int */
void dodaj(char *, int, int sys); /* dodaje do liczby w systemie liczbe int */
int cyfra(char);         /* oblicza wartosc liczbowa zadanej cyfry */
int znak(int);           /* oblicza cyfre, jaka bedzie zapisana liczba */

int main (void)
{
char liczba_in[1001];
char liczba_out[1001] = "\0";
char *temp = liczba_in;
int insystem = 10, osystem = 16;

puts("Podaj system, w jakim podasz liczbe:");
scanf("%d", &insystem);

puts("Podaj system, na ktory mam przeliczyc:");
scanf("%d", &osystem);

printf("Podaj liczbe w systemie %d (max 1000 cyfr):\n", insystem);
scanf("%s", liczba_in);

while (*temp)
  {
  shift(liczba_out, 2);  /* robimy miejsce na ewentualne dodatkowe cyfry */

  /* mnozymy to, co mamy, przez podstawe we-systemu */
  razy(liczba_out, insystem, osystem);

/* robimy jeszcze miejsce (przy dodawaniu ilosc cyfr moze sie zwiekszyc o 1) */
  if (*liczba_out != '0') shift(liczba_out, 1); /* robimy jeszcze miejsce */
  
  dodaj(liczba_out, cyfra(*temp), osystem); /* dodajemy nowa cyfre */

  /* usuwamy zera z poczatku liczby */
  while (*liczba_out == '0') shift(liczba_out, -1);
  
  ++temp;
  }

printf("W systemie %d to jest liczba: %s\n", osystem, liczba_out);
return 0;
}
/*****************************************************************************/
void shift(char *string, int ile)
{
char *koniec, *poczatek = string;

if (ile > 0)
  {
  while (*++poczatek);
  koniec = poczatek + ile;
  
  while (poczatek >= string) *koniec-- = *poczatek--;
  while (koniec >= string)   *koniec-- = '0';
  }
else if (ile < 0)
  {
  koniec = string; poczatek -= ile;
  while (*koniec++ = *poczatek++);
  }
}

int cyfra(char znak)
{
if (znak <= '9' && znak >= '0') return znak - '0';
if (znak >= 'a' && znak <= 'z') return znak - 'a' + 10;
if (znak >= 'A' && znak <= 'Z') return znak - 'A' + 10;
return 0;
}

int znak(int cyfra)
{
if (cyfra < 10) return cyfra + '0';
return cyfra + 'A' - 10;
}

void razy (char *string, int liczba, int system)
{
char *str = string;
int pamiec = 0;
while (*++str); --str;

while (str >= string)
  {
  pamiec += cyfra(*str) * liczba;
  *str = znak(pamiec % system);
  pamiec /= system;
  --str;
  }
}

void dodaj(char *string, int liczba, int system)
{
char *str = string;
int pamiec = liczba;
while (*++str); --str;

while (str >= string)
  {
  pamiec += cyfra(*str);
  *str = znak(pamiec % system);
  pamiec /= system;
  --str;
  }
}

