#include <stdio.h>
#include <stdlib.h>
#include "stack.h"
#define YES 1
#define NO  0

int main (int argc, char **argv)
{
FILE *infile;            /* plik wejsciowy */
_stack stack;            /* stos (dzialania, liczby) */
unsigned filesize,       /* zmienna na rozmiar pliku */
         stacksize = 0,  /* rozmiar stosu (potrzebny do przydzialu pamieci) */
         exprlen = 0;    /* dlugosc wyrazenia, potrzebna przy wypisywaniu */
char treat_minus_unary = NO, /* minus moze byc w dwoch znaczeniach */
     bonusprior = 0;     /* jak gleboko jestesmy w nawiasach */
char *expression, *expr; /* wyrazenie i wskaznik je przebiegajacy */
long pamiec = 0;    /* liczby sa w postaci stringow, wiec trzeba je zamienic */

if (argc == 1) return 0; /* jesli nie ma argumentu, to zakoncz */

/* jesli sie nie udalo otworzyc pliku - zakoncz zglaszajac blad */
if ( !(infile = fopen(argv[1], "r") ) ) return 1;
fseek(infile, 0, SEEK_END);  /* przesuwamy sie na koniec pliku */
filesize = ftell(infile);    /* odczytujemy pozycje (czyli rozmiar pliku) */
fseek(infile, 0, SEEK_SET);  /* przesuwamy sie z powrotem na poczatek */

if ( !(expression = malloc(filesize) ) )
  {                          /* blad przydzielania miejsca na wyrazenie */
  fclose(infile);            /* zamykamy plik */
  return 1;                  /* konczymy zglaszajac blad */
  }                          /* tu przydzial miejsca przebiegl pomyslnie */
fread(expression, 1, filesize, infile); /* czytamy plik do pamieci */
fclose(infile);                         /* juz niepotrzebny, wiec zamykamy */

expr = expression;   /* przydaloby sie ustalic, ile miejsca potrzeba na stos */
while (*expr && *expr != '\n')
  {
  if (*expr == '^' || *expr == '*' || *expr == '/' || *expr == '+' ||
      *expr == '-') ++stacksize;
  ++expr;
  ++exprlen;         /* jednoczesnie liczymy dlugosc wyrazenia */
  }

if ( init(&stack, stacksize) )
  {                  /* przydzial pamieci przebiegl niepomyslnie */
  free(expression);  /* zwalniamy pamiec przydzielona na wczytany plik */
  return 1;          /* konczymy zglaszajac blad */
  }
/*****************************************************************************/
/* teraz mozemy zajac sie przetwarzaniem danych wczytanych z takim trudem    */
/* zakladamy, ze uzytkownik poprawnie wpisal dane do pliku (np.ilosci        */
/* nawiasow sie zgadzaja, nie wystepuja dwa znaki dzialan kolo siebie itd.)  */
/* inaczej nie odpowiadamy za bledne wyniki                                  */
/*****************************************************************************/
expr = expression;
while (*expr && *expr != '\n') /* przetwarzamy tylko pierwsza linijke */
  {
  if (*expr >= '0' && *expr <= '9')  /* dla cyfr */
    {
    pamiec *= 10;           /* dopiszemy cyfre do naszej pamieci */
    pamiec += *expr - '0';
    treat_minus_unary = NO; /* minus po tym znaku oznaczalby odejmowanie */
    }
  else if (*expr == '(') /* otwieramy nawias */
    {
    bonusprior += 5;     /* dzialania w nawiasach wykonaja sie szybciej */
    treat_minus_unary = YES;  /* minus po tym bedzie oznaczal zmiane znaku */
    }
  else if (*expr == ')') /* zamykamy nawias */
    {
    bonusprior -= 5;     /* dzialania spoza nawiasow wykonaja sie pozniej */
    treat_minus_unary = NO; /* minus po nawiasie oznacza odejmowanie */
    }
  else if (*expr == '^')
    {
    pushl(&stack, pamiec);              /* pchamy liczbe na stos liczb */
    pamiec = 0;                         /* czyscimy pamiec (nowa liczba) */
    pusho(&stack, '^', bonusprior + 3); /* pchamy znak na stos dzialan */
    treat_minus_unary = YES;            /* minus tutaj to zmiana znaku */
    }
  else if (*expr == '*' || *expr == '/')
    {
    pushl(&stack, pamiec);
    pamiec = 0;
    pusho(&stack, *expr, bonusprior + 2);
    treat_minus_unary = YES;
    }
  else if (*expr == '+' || (*expr == '-' && !treat_minus_unary) )
    { /* tutaj minus ma oznaczac odejmowanie, a nie branie przeciwnej liczby */
    pushl(&stack, pamiec);
    pamiec = 0;
    pusho(&stack, *expr, bonusprior + 1);
    treat_minus_unary = YES;
    }
  else if (*expr == '-' && treat_minus_unary)
    {
    pusho(&stack, '~', bonusprior + 4); /* tu nie pchamy na stos, bo unary - */
    }                                   /* operuje na NASTEPNEJ liczbie */
  ++expr;   /* bierzemy nastepny znak */
  }

/* ostatnia liczba nie poszla na stos, bo liczby umieszczalismy na stosie tylko
 * gdy napotkalismy znak dzialania */
pushl(&stack, pamiec);
/* teraz trzeba wykonac wszystkie dzialania ze stosu; funkcja execute zwraca
 * priorytet znaku z wierzcholka stosu albo 0 (stos pusty), co daje oczywisty
 * sposob oproznienia stosu */
while (execute(&stack));
/* wypiszemy teraz wynik */
printf("%.*s = %d\n", exprlen, expression, *stack.W_liczba);

/* sprzatamy po sobie */
deinit(&stack);
free(expression);
return 0;
}
