#include <stdio.h>
#include <string.h>
#define MAX_CHAR 31
#define MAX_WORD 300

typedef struct {
char ang[MAX_CHAR], pol[MAX_CHAR];
} slowo;

/* funkcja wypisuje menu (i nic wiecej) */
void jadlospis(void);

/* wyszukuje slowo polskie pasujace do 'slowo', szukajac powyzej
 * indeksu 'ostatnio_znalezione' */
int znajdz_pol(char *slowo, int ostatnio_znalezione);
/* analogicznie jak w znajdz_pol */
int znajdz_ang(char *slowo, int ostatnio_znalezione);
/* wpisuje slowo i tlumaczenie do slownika w pierwsze wolne miejsce */
void dodaj_slowo(char *ang, char *pol);
/* usuwa ze slownika wpis o zadanym indeksie */
void usun_slowo(int indeks);
/* zmienia w slowniku wpis o zadanym indeksie na zadane slowo i tlumaczenie
 * (gdy nie chcemy zmieniac polskiego czy angielskiego slowa, to w odpowiednie
 * miejsce wstawiamy NULL) */
void zmien_slowo(int indeks, char *ang, char *pol);
/* zapisuje slownik do pliku tekstowego o nazwie plik */
void zapisz_na_dysk(char *plik);
/* odczytuje slownik z pliku o nazwie plik i zwraca ilosc odczytanych wpisow
 * UWAGA: Dane z poczatku slownika beda ZAMAZANE, a ewentualne pozostalosci
 * po starym slowniku NIE BEDA policzone, choc beda dostepne */
int odczytaj_z_dysku(char *plik);

slowo slownik[MAX_WORD];

int main(void)
{
unsigned il_slow = 0;
int znalezione = -1;
char opcja = 0, szukane[MAX_CHAR], dod_pol[MAX_CHAR], dod_ang[MAX_CHAR];

/* wyczyscimy slownik; do takiej krotkiej czynnosci nie ma sensu deklarowac
 * nowej zmiennej, wiec uzyjemy jakiejs juz istniejacej */
while (++znalezione < MAX_WORD)
  {
  slownik[znalezione].pol[0] = 0;
  slownik[znalezione].ang[0] = 0;
  /* ostatnie musi byc 0, jesli user podalby slowo dluzsze niz MAX_CHAR znakow
   * (w funkcjach dodaj_slowo i zmien_slowo te nadmiarowe znaki sa obcinane) */
  slownik[znalezione].pol[MAX_CHAR-1] = 0;
  slownik[znalezione].ang[MAX_CHAR-1] = 0;
  }
znalezione = 0;

while (opcja != 'k' && opcja != 'K')
  {
  /* po kazdym 'case' wstawimy 0 do opcji; to zapobiegnie kilkukrotnemu
   * wypisywaniu menu, gdy potrzebne bylo tylko raz (po wybraniu opcji i jej
   * zatwierdzeniu w buforze klawiatury jeszcze sie cos znajduje, co powoduje
   * powtorne wstawienie litery i "wybranie przez uzytkownika" bezsensownej
   * opcji); tak na marginesie, to wszedzie tam, gdzie czekamy na sensowny
   * wybor, czekanie to jest wymuszone wlasnie tym efektem */
  if (!opcja)
    {
    printf("\nIlosc slow w slowniku: %u\n", il_slow);
    jadlospis();
    }
  scanf("%c", &opcja);

  switch (opcja)
    {
    case '1': /* szukaj pol */
      puts("Czego mam szukac?");
      scanf("%s", szukane);

      znalezione = znajdz_pol(szukane, -1);
      if (znalezione != -1)
        {
        printf("\npolskie: %s\nangielskie: %s", slownik[znalezione].pol,
                                              slownik[znalezione].ang);
        znalezione = znajdz_pol(szukane, znalezione); /* szukamy nastepnego */

        while (znalezione != -1)
          {
          printf(", %s", slownik[znalezione].ang);
          znalezione = znajdz_pol(szukane, znalezione);
          }
        putchar('\n');
        } else puts("\nNie znalazlem takiego slowa");

      opcja = 0;
      break;
    case '2': /* szukaj ang */
      puts("Czego mam szukac?");
      scanf("%s", szukane);

      znalezione = znajdz_ang(szukane, -1);

      if (znalezione != -1)
        {
        printf("\nangielskie: %s\npolskie: %s", slownik[znalezione].ang,
                                              slownik[znalezione].pol);
        znalezione = znajdz_ang(szukane, znalezione);

        while (znalezione != -1) /* ponawiamy szukanie, poki beda trafienia */
          {
          printf(", %s", slownik[znalezione].pol);
          znalezione = znajdz_ang(szukane, znalezione);/* szukamy nastepnego */
          }
        putchar('\n');
        }
      else puts("\nNie znalazlem takiego slowa");

      opcja = 0;
      break;
    case '3': /* dodaj */
      if (il_slow == MAX_WORD) /* wyczerpane cale wolne miejsce */
        {
        puts("Cale wolne miejsce na slowa wykorzystane!");
        break;
        }
      puts("Podaj polskie slowo:");
      scanf("%s", dod_pol);
      puts("Podaj angielskie slowo:");
      scanf("%s", dod_ang);

      dodaj_slowo(dod_ang, dod_pol);  /* dodajemy slowo do slownika */
      ++il_slow;                      /* zwiekszamy ilosc slow */
      opcja = 0;
      break;
    case '4': /* usun */
      puts("W jakim jezyku chcesz podac slowo? (1 - polski, 2 - angielski)");
      /* czytamy, az user poda poprawna litere */
      while (opcja > '2' || opcja < '1') scanf("%c", &opcja);

      puts("Jakie slowo usunac?");
      scanf("%s", szukane);

      if (opcja == '1')  /* usuwamy polskie slowo */
        {
        znalezione = znajdz_pol(szukane, 0);

        /* bedziemy ponawiac szukanie, az usuniemy wszystkie wystapienia */
        while (znalezione != -1)
          {
          /* przy wybranej opcji 'wszystkie' nie pytamy sie */
          if (opcja != 'W' && opcja != 'w')
            {
            printf("Usunac slowo \"%s / %s\" ?\n(Tak/Nie/Wszystkie/Zadne)",
                             slownik[znalezione].pol, slownik[znalezione].ang);

            /* czytamy, az user nie poda sensownej opcji */
            opcja = 0;
            while (opcja != 't' && opcja != 'n' && opcja != 'w' && opcja != 'z'
             && opcja != 'T' && opcja != 'N' && opcja != 'W' && opcja != 'Z')
              scanf("%c", &opcja);
            }
          /* usuwamy slowo */
          if (opcja == 'T' || opcja == 't' || opcja == 'W' || opcja == 'w')
            {
            usun_slowo(znalezione);
            --il_slow;
            }
          /* user juz nie chce usuwac, wiec po co przegladac reszte? */
          if (opcja == 'Z' || opcja == 'z') break;
          /* szukamy nastepnego slowa */
          znalezione = znajdz_pol(szukane, znalezione);
          }
        }
      else /* analogicznie, jak przy polskim slowie */
        {
        znalezione = znajdz_ang(szukane, -1);
        while (znalezione != -1)
          {
          if (opcja != 'W' && opcja != 'w')
            {
            printf("Usunac slowo \"%s / %s\" ?\n(Tak/Nie/Wszystkie/Zadne)",
                             slownik[znalezione].ang, slownik[znalezione].pol);
            opcja = 0;
            while (opcja != 't' && opcja != 'n' && opcja != 'w' && opcja != 'z'
             && opcja != 'T' && opcja != 'N' && opcja != 'W' && opcja != 'Z')
              scanf("%c", &opcja);
            }
          if (opcja == 'T' || opcja == 't' || opcja == 'W' || opcja == 'w')
            {
            usun_slowo(znalezione);
            --il_slow;
            }
          if (opcja == 'Z' || opcja == 'z') break;
          znalezione = znajdz_ang(szukane, znalezione);
          }
        }

      opcja = 0;
      break;
    case '5': /* zmien */
      puts("W jakim jezyku chcesz podac slowo? (1 - polski, 2 - angielski)");
      while (opcja > '2' || opcja < '1') scanf("%c", &opcja);

      puts("Jakie slowo zmienic?");
      scanf("%s", szukane);

      if (opcja == '1')  /* usuwamy polskie slowo */
        {
        znalezione = znajdz_pol(szukane, 0);

        /* bedziemy ponawiac szukanie, az usuniemy wszystkie wystapienia */
        while (znalezione != -1)
          {
          printf("Zmienic slowo \"%s / %s\" ? (Tak/Nie/Zadne)",
                           slownik[znalezione].pol, slownik[znalezione].ang);

          /* czytamy, az user nie poda sensownej opcji */
          opcja = 0;
          while (opcja != 't' && opcja != 'n' && opcja != 'z'
              && opcja != 'T' && opcja != 'N' && opcja != 'Z')
                scanf("%c", &opcja);

          /* zmieniamy slowo */
          if (opcja == 'T' || opcja == 't')
            {
            puts("Podaj nowe angielskie tlumaczenie:");
            scanf("%s", dod_ang);
            zmien_slowo(znalezione, dod_ang, NULL);
            }
          /* user juz nie chce zmieniac, wiec po co przegladac reszte? */
          if (opcja == 'Z' || opcja == 'z') break;
          /* szukamy nastepnego slowa */
          znalezione = znajdz_pol(szukane, znalezione);
          }
        }
      else /* analogicznie, jak przy polskim slowie */
        {
        znalezione = znajdz_ang(szukane, 0);

        /* bedziemy ponawiac szukanie, az usuniemy wszystkie wystapienia */
        while (znalezione != -1)
          {
          printf("Zmienic slowo \"%s / %s\" ? (Tak/Nie/Zadne)",
                           slownik[znalezione].ang, slownik[znalezione].pol);

          /* czytamy, az user nie poda sensownej opcji */
          opcja = 0;
          while (opcja != 't' && opcja != 'n' && opcja != 'z'
              && opcja != 'T' && opcja != 'N' && opcja != 'Z')
                scanf("%c", &opcja);

          /* zmieniamy slowo */
          if (opcja == 'T' || opcja == 't')
            {
            puts("Podaj nowe polskie tlumaczenie:");
            scanf("%s", dod_pol);
            zmien_slowo(znalezione, NULL, dod_pol);
            }
          /* user juz nie chce zmieniac, wiec po co przegladac reszte? */
          if (opcja == 'Z' || opcja == 'z') break;
          /* szukamy nastepnego slowa */
          znalezione = znajdz_ang(szukane, znalezione);
          }
        }


      opcja = 0;
      break;
    case 'z': case 'Z': /* zapisz baze */
      zapisz_na_dysk("dict.txt");
      opcja = 0;
      break;
    case 'w': case 'W': /* wczytaj baze */
      il_slow = odczytaj_z_dysku("dict.txt");
      opcja = 0;
      break;
    }
  }

return 0;
}

int znajdz_pol(char *slowo, int ostatnio_znalezione)
{
int i = ostatnio_znalezione;

while (++i < MAX_WORD)
  if ( !strcmp(slowo, slownik[i].pol) ) return i;

return -1; /* nie znaleziono pasujacego slowa */
}

/* funkcja analogiczna, jak dla polskich slow */
int znajdz_ang(char *slowo, int ostatnio_znalezione)
{
int i = ostatnio_znalezione;

while (++i < MAX_WORD)
  if ( !strcmp(slowo, slownik[i].ang) ) return i;

return -1;
}

void dodaj_slowo(char *ang, char *pol)
{
int i = -1;

while (++i < MAX_WORD)            /* szukamy pierwszego wolnego miejsca */
  if (slownik[i].pol[0] == 0) break; /* jesli nic nie ma, znaczy ze wolne */

/* MAX_CHAR-1, bo ostatnie MUSI byc 0 konczace */
strncpy(slownik[i].ang, ang, MAX_CHAR-1);
strncpy(slownik[i].pol, pol, MAX_CHAR-1);
}

void usun_slowo(int indeks)
{
slownik[indeks].pol[0] = 0;
slownik[indeks].ang[0] = 0;
}

void zmien_slowo(int indeks, char *ang, char *pol)
{ /* MAX_CHAR-1, bo ostatnie MUSI byc 0 konczace */
if (ang) strncpy(slownik[indeks].ang, ang, MAX_CHAR-1);
if (pol) strncpy(slownik[indeks].pol, pol, MAX_CHAR-1);
}

void zapisz_na_dysk(char *plik)
{
FILE *wy_plik = NULL;
int i = -1;

printf("Zapisujemy do pliku: %s\n", plik);
wy_plik = fopen(plik, "w");

if (!wy_plik)
  {
  puts("Blad zapisu do pliku!");
  return;
  }

while (++i < MAX_WORD)    /* najpierw slowo polskie, potem angielskie */
  if (slownik[i].pol[0]) fprintf(wy_plik, "%s %s\n", slownik[i].pol,
                                                     slownik[i].ang);

fclose(wy_plik);
}

int odczytaj_z_dysku(char *plik)
{
FILE *we_plik = NULL;
int i = 0;

printf("Odczytujemy z pliku: %s\n", plik);
we_plik = fopen(plik, "r");

if (!we_plik)
  {
  puts("Blad odczytu pliku!");
  return 0;
  }

/* konczymy, gdy skonczy sie plik albo miejsce na wpisy */
while (!feof(we_plik) && i < MAX_WORD)
  { /* odczyt z pliku */
  if (fscanf(we_plik, "%s%s", slownik[i].pol, slownik[i].ang) != 2)
    { /* jesli odczytano tylko jedno slowo (lub wcale) */
    slownik[i].pol[0] = 0; /* to uznajemy, ze nie odczytano wpisu wcale */
    slownik[i].ang[0] = 0;
    /* po pierwsze slowa beda w jednym ciagu, po drugie bedziemy znac
     * rzeczywista ilosc wpisow w slowniku */
    --i;
    }
  ++i;
  }

fclose(we_plik);
return i; /* zwracamy ilosc odczytanych wpisow */
}

void jadlospis(void)
{
puts("Menu:\n\
1 Wyszukaj polskie slowo\n\
2 Wyszukaj angielskie slowo\n\
3 Dodaj slowo do slownika\n\
4 Usun slowo ze slownika\n\
5 Zmien tlumaczenie slowa\n\
Z Zapisz baze na dysk\n\
W Wczytaj baze z dysku\n\
K Koniec programu");
}

