#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <pthread.h>

// makro randomizujace
#define RANDOM(max) (int)( ( (double)rand() / RAND_MAX ) * max )
// thread identifier - identyfikator watku
#define TID     unsigned long int

// semafor, ktory ma byc jeden dla wszystkich watkow
#define SEMAFOR         volatile static signed int
#define WAIT(semafor)   while (semafor < 1); --semafor;
#define SIGNAL(semafor) ++semafor;

// mutex, w zasadzie semafor typu on/off
#define MUTEX       volatile static int
#define LOCK(mutex) while (mutex); mutex = 1;
#define FREE(mutex) mutex = 0;

#define SHARED volatile static

// maksymalna ilosc filozofow - na razie w formie definicji
#define FILOZOFOWIE 30

struct params
{
volatile int *numer,   // ID watku, a jednoczesnie ilosc dzialajacych watkow
    ilosc_cykli,       // ilosc cykli zycia filozofow
    max_czas;
};

FILE *wykres;          // tu zapiszemy dane do wykresu

//----------------------------------------------------------------------------
/*
 * Gwarancja braku zakleszczen jest fakt, ze filozof bierze najpierw paleczke
 * o mniejszym numerze
 */

void* filozof(struct params *arg)
{
TID watek;                 // ID watku, wiekszy od zera
SEMAFOR Kuchnia = 20;      // do kuchni wejdzie max 20 filozofow
SEMAFOR Stol = 5;          // przy stole siedzi max 5 filozofow
SHARED TID Zajete[5] =     // kto zajmuje miejsca przy stole
        {0, 0, 0, 0, 0}; // na razie nikt
MUTEX Paleczka[5] =        // paleczki to zasoby niepodzielne :)
        {0, 0, 0, 0, 0};
unsigned int max_czas, cykle;

SHARED int zmiana = 0;     // kolejna zmiana stanu, przydatne do wykresu

// zmienne pomocnicze
int i;

// watki dostaja wlasne unikalne numery; te numery wcale nie musza odpowiadac
// kolejnosci pomnozonej przez 1000, wiec to jest zalezne od systemu, choc
// wydaje sie dzialac poprawnie na moim Linuksie
watek = pthread_self() / 1000;
cykle = arg->ilosc_cykli;
max_czas = arg->max_czas;

//-----------------------------------------------------------

printf("## Zglasza sie watek %ld\n", watek);
fflush(stdout);

while (cykle-- > 0) // filozof zyje 'cykle' cykli
  {
  printf("%2ld:Mysle\n", watek);
  fflush(stdout);
  fprintf(wykres, "%4d %2ld %c\n", ++zmiana, watek, 'M');
  fflush(wykres);
  usleep(RANDOM(max_czas));

  printf("%2ld:Ide do kuchni\n", watek);
  fflush(stdout);
  fprintf(wykres, "%4d %2ld %c\n", ++zmiana, watek, 'K');
  fflush(wykres);
  WAIT(Kuchnia);   // czekamy na wejscie do kuchni

   printf("%2ld:Jestem w kuchni, czekam na stol\n", watek);
   fflush(stdout);
   fprintf(wykres, "%4d %2ld %c\n", ++zmiana, watek, 'S');
   fflush(wykres);
   WAIT(Stol);      // czekamy na wolne miejsce przy stole
   i = 0;
   while (Zajete[i] != 0) i = (i + 2) % 5;
   Zajete[i] = watek;

     printf("%2ld:Siedze przy stole, czekam na paleczki\n", watek);
     fflush(stdout);
     fprintf(wykres, "%4d %2ld %c\n", ++zmiana, watek, 'P');
     fflush(wykres);
     if (i != 4){LOCK(Paleczka[i]); LOCK(Paleczka[i + 1]);}
     else {LOCK(Paleczka[0]); LOCK(Paleczka[4]);}

      printf("%2ld:Jem...\n", watek);
      fflush(stdout);
      fprintf(wykres, "%4d %2ld %c\n", ++zmiana, watek, 'J');
      fflush(wykres);
      usleep(RANDOM(max_czas));

     if (i != 4){FREE(Paleczka[i]); FREE(Paleczka[i + 1]);}
     else {FREE(Paleczka[0]); FREE(Paleczka[4]);}
     printf("%2ld:Odlozylem paleczki\n", watek);
     fflush(stdout);

   Zajete[i] = 0;
   SIGNAL(Stol);    // wstajemy od stolu
   printf("%2ld:Wstalem od stolu\n", watek);
   fflush(stdout);

  SIGNAL(Kuchnia); // wychodzimy z kuchni
  printf("%2ld:Wyszedlem z kuchni\n", watek);
  fflush(stdout);
  fprintf(wykres, "%4d %2ld %c\n", ++zmiana, watek, 'W');
  fflush(wykres);
  }
//-----------------------------------------------------------
// filozof umarl z przejedzenia wzglednie z zamyslenia, zatem zmniejszamy
// ilosc zywych darmozjadow
printf("%2ld:#### Umarlem z przejedzenia ####\n",
       watek);
fflush(stdout);
fprintf(wykres, "%4d %2ld %c\n", ++zmiana, watek, 'u');
fflush(wykres);

--(*(arg->numer)); // zmniejszamy ilosc dzialajacych filozofow
return NULL;
}

/****************************************************************************/

int main(int argc, char **argv)
{
volatile int dzialajace_watki = 0;
pthread_t *filoz;
int i;
int ilosc_filozofow = 30, dlugosc_zycia = 4, max_czas = 100, symul_czas = 60;
struct params parametry_watku;

//---------------------------------

if (argc > 1)  // pierwszy argument to ilosc filozofow
  ilosc_filozofow = atoi(argv[1]);

if (ilosc_filozofow > 100) // obcinamy ilosc filozofow
  ilosc_filozofow = 100;

if (argc > 2)  // drugi argument to dlugosc zycia filozofa w cyklach
  dlugosc_zycia = atoi(argv[2]);

if (argc > 3)  // trzeci argument to maksymalny czas jedzenia i myslenia (ms)
  max_czas = atoi(argv[3]);

//---------------------------------

filoz = calloc(ilosc_filozofow, sizeof(pthread_t));

parametry_watku.numer = &dzialajace_watki;
parametry_watku.ilosc_cykli = dlugosc_zycia;
parametry_watku.max_czas = max_czas;

if ( (wykres = fopen("wykres.txt", "w")) == NULL )
  {
  wykres = stderr;
  fprintf(stderr, "Nie udalo mi sie otworzyc pliku (sprawdz uprawnienia)\n");
  }

// dobrze byloby wypisac, co jak oznaczamy (nie kazdy musi miec przed oczami
// kod zrodlowy)

fprintf(wykres, "Oznaczenia uzyte w pliku:\n\
M - filozof mysli\n\
K - filozof czeka na wejscie do kuchni\n\
S - filozof czeka na wolne miejsce przy stole\n\
P - filozof czeka na wolne paleczki\n\
J - filozof wpiernicza ryz\n\
W - filozof wyszedl z kuchni\n\
u - filozof umarl\n\
-------------------------------------------------\n\n\
zmian F Co robi\n");
fflush(wykres);

for (i = 0; i < ilosc_filozofow; ++i)
  {
  ++dzialajace_watki;
  pthread_create(filoz + i, NULL, (void*)(void*)filozof, &parametry_watku);
  }

// wirujaca blokada, nie konczymy, dopoki zostaly jakies nie zakonczone watki
while (dzialajace_watki);

if (wykres != stderr) // zebysmy czasem nie probowali zamknac wyjscia bledow
  fclose(wykres);
free(filoz);

return 0;
}
