/*
opis protokolu
Serwer tworzy obszar pamieci dzielonej o zadanej wielkosci i dwa semafory:
semafor zezwalajacy na zapis (podnoszony przez klienta, poczatkowo jest
opuszczony) i semafor zezwalajacy na odczyt (podnoszony przez serwer,
poczatkowo podniesiony).
W pierwsze cztery (0..3) bajty pamieci wpisuje wielkosc przydzielonej pamieci,
w bajty 4..7 - klucz semafora pozwalajacego na zapis, w kolejne cztery zas
(bajty 8..11) - klucz semafora zezwalajacego na odczyt (dzieki temu klient
musi znac tylko klucz do pamieci dzielonej).
Serwer po zapisaniu tych danych czeka na zwolnienie semafora zapisu,
w pierwsze 4 bajty wpisuje ilosc nie-smieci, ktore zapisal, a opuszczajac
sekcje podnosi semafor odczytu (semafor zapisu zostaje opuszczony).
Klient czeka na semafor odczytu, odczytuje dane i opuszczajac sekcje podnosi
semafor zapisu (teraz z kolei semafor odczytu zostaje opuszczony).
Na zakonczenie transferu serwer wstawia zero bajtow nie-smieci, po czym czeka
na zwolnienie semafora zapisu, zeby miec pewnosc, ze klient odbierze znak
konca transferu.
*/

#include <sys/ipc.h>
#include <sys/shm.h>
#include <sys/types.h>
#include <sys/sem.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
///////////////////////////////////
#include <errno.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <time.h>
//-------------------------------//
#include "shm_server.h"


int serwer_data_send(char *co_przeslac, int rozm_bloku, int klucz)
{
int numer_bledu;
// pamiec dzielona
int deskryptor_pamieci;
char *bufor = NULL;
// semafory
int klucz_odczyt, klucz_zapis;
int odczyt, zapis;
struct sembuf opusc = {0, -1, 0}, podnies = {0, 1, 0};
// pliki
int plik;
int rozmiar_pliku;

//-----------------------------------------------------------------//
// kontrola bledow

plik = open(co_przeslac, O_RDONLY);
if (plik == -1)
  {
  numer_bledu = errno;
  printf("Blad otwierania pliku:\n%s\n", strerror(numer_bledu));
  return numer_bledu;
  }

srand(time(NULL));
do
  {
  klucz_odczyt = rand();
  odczyt = semget(klucz_odczyt, 1, 0666 | IPC_CREAT | IPC_EXCL);
  // jesli semafor istnieje, to nie wywalamy sie, po prostu probujemy inny
  // semafor
  if (odczyt == -1 && errno != EEXIST && errno != EACCES)
    {
    numer_bledu = errno;
    printf("Blad tworzenia semafora:\n%s\n", strerror(numer_bledu));
    close(plik);
    return numer_bledu;
    }
  }
while (odczyt == -1);
semop(odczyt, &podnies, 1); // tak, jak obiecalismy w protokole

do
  {
  klucz_zapis = rand();
  zapis = semget(klucz_zapis, 1, 0666 | IPC_CREAT | IPC_EXCL);
  // jesli semafor istnieje, to nie wywalamy sie, po prostu probujemy inny
  // semafor
  if (zapis == -1 && errno != EEXIST && errno != EACCES)
    {
    numer_bledu = errno;
    printf("Blad tworzenia semafora:\n%s\n", strerror(numer_bledu));
    close(plik);
    semctl(odczyt, 0, IPC_RMID, 0);
    return numer_bledu;
    }
  }
while (zapis == -1);

deskryptor_pamieci = shmget(klucz, rozm_bloku, 0666 | IPC_CREAT);
if (deskryptor_pamieci == -1)
  {
  numer_bledu = errno;
  printf("Blad przydzialu pamieci:\n%s\n", strerror(numer_bledu));
  close(plik);
  semctl(odczyt, 0, IPC_RMID, 0);
  semctl(zapis, 0, IPC_RMID, 0);
  return numer_bledu;
  }

bufor = shmat(deskryptor_pamieci, NULL, 0);
if ((int)bufor == -1)
  {
  numer_bledu = errno;
  printf("Blad wiazania pamieci:\n%s\n", strerror(numer_bledu));
  shmctl(deskryptor_pamieci, IPC_RMID, NULL);
  close(plik);
  semctl(odczyt, 0, IPC_RMID, 0);
  semctl(zapis, 0, IPC_RMID, 0);
  return numer_bledu;
  }

((long*)bufor)[0] = rozm_bloku;
((long*)bufor)[1] = klucz_zapis;
((long*)bufor)[2] = klucz_odczyt;

//-----------------------------------------------------------------//
// inicjalizacja polaczenia

// ustalamy dlugosc pliku
rozmiar_pliku = lseek(plik, 0, SEEK_END);
lseek(plik, 0, SEEK_SET);

/*******************************************************************/

rozm_bloku -= 4; // cztery bajty na ilosc nie-smieci
// petla dokonujaca odczytu z pliku
while (rozmiar_pliku >= rozm_bloku)
  {
  semop(zapis, &opusc, 1);           // czekamy na zezwolenie na zapis
  ((long*)bufor)[0] = rozm_bloku;    // tyle nie-smieci zapiszemy
  read(plik, bufor + 4, rozm_bloku);
  fflush(stdout);
  semop(odczyt, &podnies, 1);        // zezwalamy na odczyt danych
  rozmiar_pliku -= rozm_bloku;       // do przeslania zostalo juz mniej danych
  }

// do wyslania zostal juz niepelny blok danych
if (rozmiar_pliku > 0)
  {
  semop(zapis, &opusc, 1);              // czekamy na zezwolenie na zapis
  ((long*)bufor)[0] = rozmiar_pliku;    // tyle mamy zapisac
  read(plik, bufor + 4, rozmiar_pliku);
  semop(odczyt, &podnies, 1);           // zezwalamy na odczyt danych
  }

// wysylamy znak zakonczenia transferu - dane z zerowa iloscia nie-smieci
semop(zapis, &opusc, 1);    // czekamy na zezwolenie na zapis
((long*)bufor)[0] = 0;      // znak konca pliku
semop(odczyt, &podnies, 1); // zezwalamy na odczyt danych

/*******************************************************************/
// sprzatamy po sobie

semctl(odczyt, 0, IPC_RMID, 0);
semctl(zapis, 0, IPC_RMID, 0);
close(plik);
shmdt(bufor);
shmctl(deskryptor_pamieci, IPC_RMID, NULL);
return 0;
}

