#include <sys/ipc.h>
#include <sys/shm.h>
#include <sys/types.h>
#include <sys/sem.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
///////////////////////////////////
#include <errno.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <time.h>
//-------------------------------//
#include "shm_client.h"

int klient_data_recv(char *gdzie_zapisac, int klucz)
{
int numer_bledu;
// pamiec dzielona
int deskryptor_pamieci;
char *bufor = NULL;
int rozm_bloku;
// semafory
int klucz_odczyt, klucz_zapis;
int odczyt, zapis;
struct sembuf opusc = {0, -1, 0}, podnies = {0, 1, 0};
// pliki
int plik;
int odczytane;

//-----------------------------------------------------------------//
// kontrola bledow
//*
deskryptor_pamieci = shmget(klucz, 12, 0); // 4B na wielkosc, 2x4B na semafory
if (deskryptor_pamieci == -1)
  {
  numer_bledu = errno;
  printf("Blad odczytu pamieci:\n%s\n", strerror(numer_bledu));
  return numer_bledu;
  }

bufor = shmat(deskryptor_pamieci, NULL, 0);
if ((int)bufor == -1)
  {
  numer_bledu = errno;
  printf("Blad wiazania pamieci:\n%s\n", strerror(numer_bledu));
  return numer_bledu;
  }

rozm_bloku   = ((long*)bufor)[0];
klucz_zapis  = ((long*)bufor)[1];
klucz_odczyt = ((long*)bufor)[2];

// teraz mozemy dobrac sie do calej pamieci
shmdt(bufor);

deskryptor_pamieci = shmget(klucz, rozm_bloku, 0);
if (deskryptor_pamieci == -1)
  {
  numer_bledu = errno;
  printf("Blad powtornego odczytu pamieci:\n%s\n", strerror(numer_bledu));
  return numer_bledu;
  }

bufor = shmat(deskryptor_pamieci, NULL, 0);
if ((int)bufor == -1)
  {
  numer_bledu = errno;
  printf("Blad powtornego wiazania pamieci:\n%s\n", strerror(numer_bledu));
  return numer_bledu;
  }
klucz_zapis  = ((long*)bufor)[1];
klucz_odczyt = ((long*)bufor)[2];

odczyt = semget(klucz_odczyt, 1, 0);
if (odczyt == -1)
  {
  numer_bledu = errno;
  printf("Blad odczytu semafora:\n%s\n", strerror(numer_bledu));
  shmdt(bufor);
  return numer_bledu;
  }

zapis = semget(klucz_zapis, 1, 0);
if (zapis == -1)
  {
  numer_bledu = errno;
  printf("Blad odczytu semafora:\n%s\n", strerror(numer_bledu));
  shmdt(bufor);
  return numer_bledu;
  }

plik = open(gdzie_zapisac, O_WRONLY | O_CREAT, 0666);
if (plik == -1)
  {
  numer_bledu = errno;
  printf("Blad otwierania pliku:\n%s\n", strerror(numer_bledu));
  shmdt(bufor);
  shmctl(deskryptor_pamieci, IPC_RMID, NULL);
  return numer_bledu;
  }

//-----------------------------------------------------------------//
// inicjalizacja polaczenia

// teraz zezwalamy na zapis, odczytalismy juz wszystko, co trzeba
semop(zapis, &podnies, 1);
semop(odczyt, &opusc, 1);

/*******************************************************************/

do
  {
  semop(odczyt, &opusc, 1);          // czekamy na zezwolenie na odczyt
  odczytane = ((long*)bufor)[0];     // ile odczytac?
  write(plik, bufor + 4, odczytane); // zapisujemy do pliku
  semop(zapis, &podnies, 1);         // zezwalamy na zapis
  }
while (odczytane != 0);

/*******************************************************************/
// sprzatamy po sobie

close(plik);
shmdt(bufor);
return 0;
}

