#include <math.h>
#include <stdlib.h>

long oblicz(long l1, char znak, long l2)
{
if (znak == '^') l1 = (long)pow(l1, l2);
else if (znak == '*') l1 *= l2;
else if (znak == '/') l1 /= l2;
else if (znak == '+') l1 += l2;
else if (znak == '-') l1 -= l2;
else return 0;
return l1;
}

typedef struct
{
/* trzy stosy */
char *dzialanie;
char *prior;
long *liczba;
/* wierzcholki kazdego stosu */
char *W_dzialanie;
char *W_prior;
long *W_liczba;
} _stack;

void pusho(_stack *stos, char znak, char prior);
void pushl(_stack *stos, long wartosc);
int execute(_stack *stos);

/*****************************************************************************/
/* poloz na stos liczb liczbe */
void pushl(_stack *stos, long wartosc)
{
++(stos->W_liczba);
*(stos->W_liczba) = wartosc;
}
/*****************************************************************************/
/* poloz na stos dzialan dzialanie wraz z kolejnoscia, w jakiej sie wykona   */
/*****************************************************************************/
void pusho(_stack *stos, char znak, char prior)
{
if (znak != '~') while (*stos->W_prior >= prior) execute(stos);
else             while (*stos->W_prior > prior) execute(stos);
++(stos->W_dzialanie);
++(stos->W_prior);
*stos->W_dzialanie  = znak;
*stos->W_prior = prior;
}
/*****************************************************************************/
/* funkcja zwraca priorytet dzialania z wierzcholka stosu po wykonaniu       */
/* dzialania albo 0 (gdy nie wykonala dzialania)                             */
/*****************************************************************************/
int execute(_stack *stos)
{
/* na stosie nie ma zadnych znakow */
if (stos->W_dzialanie == stos->dzialanie)
  {
  puts("nie ma znakow");
  return 0;
  }
/* na stosie sa znaki, ale 2-arg., a na stosie liczb jest jedna liczba */
if (stos->W_liczba == stos->liczba + 1 && *stos->W_dzialanie != '~')
  {
  puts("na stosie jedna liczba");
  return 0;
  }
/* wykonujemy dzialanie ze stosu */
if (*stos->W_dzialanie != '~')
  {
  --(stos->W_liczba);
  *stos->W_liczba = oblicz(*stos->W_liczba, *stos->W_dzialanie,
                                              *(stos->W_liczba+1));
  }
else *stos->W_liczba = -(*stos->W_liczba);
/* przesuwamy wierzcholki stosow */
--(stos->W_dzialanie);
--(stos->W_prior);
/* zwracamy priorytet aktualnego dzialania ze stosu */
return *stos->W_prior;
}
/*****************************************************************************/
/* inicjalizujemy stos - alokujemy dla niego pamiec */
int init(_stack *stos, int size)
{
stos->liczba    = (long *)calloc(4, size + 2); /*0 bedzie nieuzywany*/
stos->dzialanie = (char *)calloc(1, size + 1); /*jw.*/
stos->prior     = (char *)calloc(1, size + 1); /*jw.*/
if (!(stos->liczba && stos->dzialanie && stos->prior))
  {
  free(stos->liczba);
  free(stos->dzialanie);
  free(stos->prior);
  return 1;
  }
/* dzialanie == W_dzialanie -> stos dzialan jest pusty */
stos->W_dzialanie = stos->dzialanie;
stos->W_liczba    = stos->liczba;
stos->W_prior     = stos->prior;
return 0;
}
/*****************************************************************************/
/* zwalniamy miejsce zaalokowane wczesniej */
void deinit(_stack *stos)
{
free(stos->liczba);
free(stos->dzialanie);
free(stos->prior);
}
/*****************************************************************************/
