#include <sys/ipc.h>
#include <sys/msg.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
#include <stdlib.h>
///////////////////////////////////
#include <errno.h>
#include <string.h>
#include <stdio.h>
//-------------------------------//
#include "msg_client.h"


int klient_data_recv(char *gdzie_zapisac, int bufsize, int klucz_potw,
                     int klucz_odbior)
{
int numer_bledu;
// skrzynki komunikatow
int serwer;
int odbior;
// bufory do skrzynek
char dla_serwera[8];
char *bufor = malloc(bufsize + 4);
// pliki
int plik;
int wielkosc;

//-----------------------------------------------------------------//

if ( ( serwer = msgget(klucz_potw, 0) ) == -1 )
  {
  printf("Blad tworzenia skrzynki na potwierdzenia:\n%s\n",
         strerror((numer_bledu = errno)) );
  return numer_bledu;
  }
if ( ( odbior = msgget(klucz_odbior, 0666 | IPC_CREAT) ) == -1 )
  {
  printf("Blad tworzenia skrzynki na dane:\n%s\n",
         strerror((numer_bledu = errno)) );
  msgctl(odbior, IPC_RMID, NULL);
  return numer_bledu;
  }
if ( ( plik = open(gdzie_zapisac, O_WRONLY | O_CREAT, 0666) ) == -1 )
  {
  printf("Blad otwierania pliku \"%s\" do zapisu:\n%s\n", gdzie_zapisac,
         strerror((numer_bledu = errno)) );
  msgctl(odbior, IPC_RMID, NULL);
  return numer_bledu;
  }

//-----------------------------------------------------------------//

// mowimy serwerowi, gdzie ma poslac dane
((long*)dla_serwera)[0] = klucz_odbior;
// mowimy serwerowi, ile moze na raz poslac danych
((long*)dla_serwera)[1] = bufsize;

// odbieramy dane az nie otrzymamy znaku konca (pierwsze cztery bajty zerowe)
do{
  // posylamy serwerowi informacje odnosnie naszej skrzynki (potwierdzenie
  // odbioru danych)
  msgsnd(serwer, dla_serwera, 4, 0);
  // odbieramy dane
  msgrcv(odbior, bufor, bufsize, 1/*typ*/, 0/*flagi*/);
  // odczytujemy, ile danych to nie smieci
  wielkosc = ((long*)bufor)[1];
  // zapisujemy te dane na dysk
  write(plik, bufor + 8, wielkosc);
  }
while (wielkosc > 0);

/*******************************************************************/

free(bufor);
close(plik);
msgctl(odbior, IPC_RMID, NULL);
return 0;
}
