
#include "uploader.h"



int main(int argc,char **argv)
{
static char optstring[] = ":p:va:d:h";
int optchar;	
struct sigaction sa;
int servaddrsize = sizeof(servaddr);
int i;

if(argc<2)
	usage();

/* processa as opcoes da linha de comando */
while((optchar = getopt(argc,argv,optstring))!=-1){
	switch(optchar){
		case 'p':
			servport = atoi(optarg);
		break;
		case 'v':
			verbose = 1;
		break;
		case 'a':
			strncpy(servipaddress,optarg,15);
		break;
		case 'h':
			usage();	
		break;
		case 'd':
			directory = optarg;
		break;
		case '?':
			printf("error: invalid option\n");
			exit(1);
		break;
		}
	}
	
	
	/* pega o endereco ip (ultimo na linha de comando)*/
	strncpy(servipaddress,argv[argc-1],15);
	
	
if(directory) /* muda para o diretorio especificado na opcao -d */
	if(chdir(directory) == -1){
		fprintf(stderr,"error: could not change to especified directory: %s\n",directory);
	  fflush(stdout);
		exit(1);
		}else 
			if(verbose){
				fprintf(stdout,"using %s to save uploaded files\n",directory);
			fflush(stdout);
				}

bzero(&sa,sizeof(sa));
sa.sa_handler = zombiekiller;
sa.sa_flags = SA_NOCLDSTOP | SA_RESTART;
sigaction(SIGCHLD,&sa,0);
	
/* cria o socket do servidor */
if((servsock = socket(AF_INET,SOCK_STREAM,0)) < 0){
		fprintf(stderr,"%s: could not create socket\n",argv[0]);
		fflush(stdout);
		exit(1);
		}
	
bzero(&servaddr,sizeof(struct sockaddr_in));
servaddr.sin_family = AF_INET;
if((servaddr.sin_addr.s_addr = inet_addr(servipaddress)) == INADDR_NONE){
	fprintf(stderr,"error: you must suply a valid ip address\n");
	fflush(stderr);
	exit(1);
	}
servaddr.sin_port = htons(servport);
if(bind(servsock,(struct sockaddr*) &servaddr,sizeof(struct sockaddr_in))){
		fprintf(stderr,"%s: could not bind socket\n",argv[0]);
		fflush(stderr);
		exit(1);
		}
	
if(listen(servsock,5)){
		fprintf(stderr,"%s: could not listen socket\n",argv[0]);
		fflush(stderr);
		exit(1);
		}
	
	/* ate aqui tudo OK. o servidor esta ouvindo em servport */
	fprintf(stdout,"%s listening to port %d %s\n",argv[0],servport,inet_ntoa(servaddr.sin_addr));
  fflush(stdout);
/* o loop principal */
for(;;){
int clientsock; /* socket do cliente */	
struct sockaddr_in clientaddr;
int addrsize = sizeof(clientaddr);
int tmpfd; /* descritor do arquivo temporario */
int tmpfilesize;

clientsock = accept(servsock,(struct sockaddr*) &clientaddr,&addrsize);
/*send_form_to_client(clientsock);*/
if(!fork()){
	close(servsock);
	if(verbose){
		fprintf(stdout,"got connection from %s\n",inet_ntoa(clientaddr.sin_addr));
		fflush(stdout);
		}
	if((tmpfd = createtmpfile()) == -1){
		fprintf(stderr,"%s: error creating temporary file\n",argv[0]);	
		fflush(stderr);
		close(clientsock);
		exit(1);
	}

	tmpfilesize = recvdata_and_save_to_tmpfile(clientsock,tmpfd);

	close(clientsock); /* ja podemos fechar a conexao com o cliente */
	if(verbose){
		fprintf(stdout,"received %d bytes from %s\n",tmpfilesize,inet_ntoa(clientaddr.sin_addr));
	  fflush(stdout);
		}
	
		filter_tmpfile(tmpfd,tmpfilesize);

	close(tmpfd);
	close(servsock);
	exit(0);
}
else{ /* processo pai */
	close(clientsock);
	}
}

}

void send_form_to_client(int sock)
{
char form[1024];
	snprintf(form,1024,"<html>"
	"<h1>Wellcome to the uploader servlet<br></h1><br>"
"<form method=\"post\" enctype=\"multipart/form-data\" action=\"http://%s:%d\" name=\"form1\">"
"<input type=\"file\" name=\"file_1\"><br>"
"<input type=\"file\" name=\"file_2\"><br>"
"<input type=\"submit\" name=\"uploadfile\" value=\"Enviar Arquivo\">"
"</form>"
"</html>\0x2d\0x2d\0x0d\0x0a",servipaddress,servport);
send(sock,form,strlen(form),0);
}

int createtmpfile()
{
int fd;	
char tmpfilename[256];

strcpy(tmpfilename,"/tmp/uploader.XXXXXXX"); /* nome do arquivo temporario */
if((fd = mkstemp(tmpfilename)) == -1)
		return -1;
unlink(tmpfilename); /* apaga o arquivo temporario */

return fd;
}

int recvdata_and_save_to_tmpfile(int sock,int tmpfile)
{
char recvbuffer[1024];
int bytesread,byteswrite;
int tmpfilesize = 0;
int i;
int methodtested = 0;
	
	for(;;){
		
		bzero(recvbuffer,1024);
		bytesread = recv(sock,recvbuffer,1024,0);
		if(!methodtested)
			if(get_method(recvbuffer)==METHOD_GET){
				send_form_to_client(sock);
				close(sock);
				exit(0);
			}
			
	  methodtested = 1;
		byteswrite = write(tmpfile,recvbuffer,bytesread); /* vai escrevendo os bytes recebidos no arq. temporario */
		tmpfilesize+=byteswrite;
		
		for(i=0;i<1021;++i)
  		if(recvbuffer[i]==0x2d && recvbuffer[i+1]==0x2d )
    		if(recvbuffer[i+2]==0x0d && recvbuffer[i+3]==0x0a)
					return tmpfilesize;
	}
}

void filter_tmpfile(int tmpfile,int size)
{
char *buffer;
struct fieldlist* fldlist;
struct field* fld;
int fd;

buffer = (char*) malloc(size);
lseek(tmpfile,0,SEEK_SET); /* bota o descritor no comeco do arquivo */ 
read(tmpfile,buffer,size);
fldlist = filter_buffer(buffer,size);
fld = fldlist->fl_head;
do{
if(F_ISFILE(fld)){
fd = open(F_FILENAME(fld),O_WRONLY | O_CREAT, S_IREAD | S_IWRITE);
write(fd,F_DATA(fld),F_SIZE(fld));
close(fd);}
}while(fld = fld->f_next);

destroy_fieldlist(fldlist);
free(buffer);

}

int get_method(const char* request)
{
int i;
	
for(i=0;request[i]!=0x0d && request[i+1]!=0x0a;++i){
	if(request[i]=='G')
		if(!strncmp(request + i,"GET",3))
			return METHOD_GET;
	if(request[i]=='P')
		if(!strncmp(request + i,"POST",4))
			return METHOD_POST;
	}
}

void zombiekiller(int signum)
{
	while(waitpid(-1,0,WNOHANG)>0);	
}

void usage()
{
	fprintf(stdout,"Usage: uploader [options] ... <server ip address>\n"
	        "A simple servlet to upload files from a client brownser to a server\n\n"
					"-p <portnumber>     The port where the server will listen for client requests"
	        "                        The default port number is 8080.\n"
	        "-v                  Turn on the verbose mode.\n"
	        "-d <directory>      An optional directory where the program can save the uploa\n"
	        "                      ded files. The default directory is the current directory.\n"
					"-h                  Shows this message\n\n"
	        "Please report bugs to Doctor #include (darthfeio@lycos.com)\n");
	fflush(stdout);
	exit(0);
}