/************************************************************************************************
postfilter 2.0
************************************************************************************************/

#include <string.h>

#define BOUNDARY_SIZE_MAX 256

char boundary[BOUNDARY_SIZE_MAX];
int boundarysize = -1;
int boundarycount = 0;
int fieldscount = 0;

int find_boundary(const char* buff,int buffsize);
int count_boundaries(const char* buff,int buffsize);
int get_boundary_position(const char* buff,int buffsize,int boundarynumber);


#define F_BUFFSIZE 256

#define FTYPE_UNKNOW 0x00
#define FTYPE_FILE 0x01

struct field {
  int f_number;
  int f_type;
  char f_name[F_BUFFSIZE];
  char f_filename[F_BUFFSIZE];
  char *f_data;
  int f_size;
  struct field* f_next;
  };
  
  struct fieldlist
  {
  int fl_size;
  struct field* fl_head;
  struct field* fl_tail;
  };

int init_field(struct field* newfield,int fieldnum,const char* buff,int buffsize);  
 
 
void init_fieldlist(struct fieldlist* fl);
void destroy_fieldlist(struct fieldlist* fl); 
void fieldlist_insert_field(struct fieldlist* fl,struct field* prev,struct field* newfil);
void fieldlist_remove_field(struct fieldlist* fl,struct field* prevfield);
struct fieldlist* filter_buffer(const char* buff,int buffsize);

/* encontra a chave (campo boundary=XXXX...) */

int find_boundary(const char* buff,int buffsize)
{
  int buffindex = 0,boundindex = 0;
  
  while(buffindex<buffsize){
    if(buff[buffindex]==0x20)
      if(!strncmp(buff+buffindex+1,"boundary",8)){
	buffindex+=10;
	while(buff[buffindex]!=0x0d && buff[buffindex + 1]!=0x0a)
	  boundary[boundindex++]=buff[buffindex++];
	  
	boundary[boundindex]=0;
	break;
	  
	}
	++buffindex;
    }
    
    return boundarysize=boundindex;
}

/* conta as chaves */
int count_boundaries(const char* buff,int buffsize)
{
  int buffindex = 0,_boundarycount=0;

  while(buffindex < buffsize - boundarysize){
    if((buff[buffindex]==boundary[0])){
      
      if(!strncmp(boundary,buff + buffindex,boundarysize)){
	++_boundarycount;
	buffindex+=boundarysize;
	}
      }
      
    ++buffindex;
    }  

    return boundarycount = _boundarycount;
}


/* pega a posicao de uma chave */
int get_boundary_position(const char* buff,int buffsize,int boundarynumber)
{
  int buffindex = 0,_boundarycount=0;
  if(boundarynumber>boundarycount)
  return -1;

  while(buffindex < buffsize - boundarysize){
    if((buff[buffindex]==boundary[0])){
      if(!strncmp(boundary,buff + buffindex,boundarysize)){
	++_boundarycount;
	if(_boundarycount==boundarynumber) break;
	buffindex+=boundarysize;
	}
      }
      
    ++buffindex;
    }  

    return buffindex;

}





int init_field(struct field* newfield,int fieldnum,const char* buff,int buffsize)
{
  int buffindex = 0;
  int startboundpos,endboundpos;
  int start;
  int i=0;
  
  newfield->f_number = fieldnum;
  newfield->f_type = FTYPE_UNKNOW;
  
  if(( fieldnum > boundarycount - 2 ) || ( fieldnum <=0 )){
    newfield->f_size = -1;
    newfield->f_name[0] = 0;
    newfield->f_filename[0] = 0;
    newfield->f_data = 0;
    return -1;
    }
  
  
    
  startboundpos = get_boundary_position(buff,buffsize,fieldnum + 1);
  endboundpos = get_boundary_position(buff,buffsize,fieldnum + 2);
  
  buffindex = startboundpos + boundarysize; /* pega o nome do campo */
  while(buffindex < endboundpos){
    if(buff[buffindex] == 'n')
      if(!strncmp(buff + buffindex,"name=\"",6)){
	buffindex += 6;
	i = 0;
	while(buff[buffindex] != '"')
	  newfield->f_name[i++] = buff[buffindex++];
	newfield->f_name[i] = 0;
	break;
	}
    ++buffindex;
    }  /* fim da parte de pegar nome dp campo */  
    
  buffindex = startboundpos + boundarysize; /* pega o nome do arquivo (se o campo for arquivo )*/
  while(buffindex<endboundpos){
    if(buff[buffindex]=='f')
      if(!strncmp(buff+buffindex,"filename=\"",10)){
	buffindex+=10;
	i=0;
	while(buff[buffindex]!='"')
	  newfield->f_filename[i++]=buff[buffindex++];
	newfield->f_filename[i]=0;
	newfield->f_type = FTYPE_FILE;
	break;
	}
    ++buffindex;
    } /* fim da parte de pegar o nome do arquivo */
    
  buffindex = startboundpos + boundarysize;
  while(buffindex<endboundpos){
    if((buff[buffindex]==0x0d) && (buff[buffindex+1]==0x0a))
      if((buff[buffindex+2]==0x0d) && (buff[buffindex+3]==0x0a)){
	newfield->f_data = (char*) (buff + buffindex + 4);
      	start = buffindex + 4;
        break;
      }
    
    ++buffindex;
    }
  
  
    newfield->f_size =  endboundpos - 4 - start; /* tamanho em bytes do campo */
   
    return 0;
}



void reset_filter(struct field* fields)
{
bzero(boundary,BOUNDARY_SIZE_MAX);
boundarysize = -1;
boundarycount = 0;
fieldscount = 0;
if(fields)
  free(fields);
}


void init_fieldlist(struct fieldlist* fl)
{
fl->fl_size = 0;
fl->fl_head = 0;
fl->fl_tail = 0;
}

void destroy_fieldlist(struct fieldlist* fl)
{
while(fl->fl_size)
	fieldlist_remove_field(fl,0);
bzero(fl,sizeof(struct fieldlist));
}

void fieldlist_insert_field(struct fieldlist* fl,struct field* prevfield,struct field* newfield)
{
 
	if(!prevfield){ /* insere um campo no comeco da lista (head)*/
		newfield->f_next = fl->fl_head;
		fl->fl_head = newfield;
		if(!fl->fl_size)
			fl->fl_tail = newfield;
		}else{ /* insere um campo antes de prevfield*/
			if(!prevfield->f_next)
				fl->fl_tail = newfield;
			newfield->f_next = prevfield->f_next;
			prevfield->f_next = newfield;
			}
 
	(fl->fl_size)++; /* ajusta o tamanho da lista */
  
}

void fieldlist_remove_field(struct fieldlist* fl,struct field* prevfield)
{
	struct field* oldfield; /* o elemento a ser removido */
	
	if(!fl->fl_size) /* nao deixa remover de uma lista vazia */
		return;

	if(!prevfield){ /* remover um elemento do inicio da lista */
		
		oldfield = fl->fl_head;
		fl->fl_head = fl->fl_head->f_next;
		if(fl->fl_size==1)
			fl->fl_tail = 0;
		}else{ /* remover um elemento depois de prev*/
			if(prevfield->f_next==0)
				return;
			oldfield = prevfield->f_next;
			prevfield->f_next = prevfield->f_next->f_next; 
			if(!prevfield->f_next)
				fl->fl_tail = 0;
			}

	bzero(oldfield,sizeof( struct field));
	free(oldfield);
	
	fl->fl_size--;
	return;
}

struct fieldlist* filter_buffer(const char* buff,int buffsize)
{
	struct field* fields; /* um ponteiro para os campos */
	struct fieldlist* fl; /* a lista de campos */
	int i;  
  
	if(fieldscount) /* retorna NULL se ja tiver campos (usar reset_filter()) */
  	return 0;

	find_boundary(buff,buffsize); /* encontra a chave */
	count_boundaries(buff,buffsize); /* conta as chaves */
	fieldscount = boundarycount-2; /* atualiza o numero de campos (= numero de chaves -2, sempre)*/
  
	
	fl = (struct fieldlist*) malloc(sizeof(struct fieldlist));
	init_fieldlist(fl); /* inicia (zera) a lista */
	
	for(i=fieldscount;i>=1;--i){ /* inicia os campos e adiciona na lista */
  	fields = (struct field*) malloc(sizeof(struct field));
		init_field(fields,i,buff,buffsize);
		fieldlist_insert_field(fl,0,fields);
		}
return fl;
}