/**************************************************************************
TuXBuZZ - DoC#include
server.c 
**************************************************************************/

#include "server.h"


int main(int argc,char **argv)
{
  int sockfd;
  struct sockaddr_in addr;
  int port = PORT; /* a porta onde o servidor vai escutar */
  struct TuxbuzzPackage ackpack;
  
  struct sigaction sa;
  bzero(&sa,sizeof(struct sigaction));
  sa.sa_handler = zombiekiller;
  sa.sa_flags = SA_NOCLDSTOP | SA_RESTART;
  sigaction(SIGCHLD,&sa,0);
  
  
  bzero(&ackpack,sizeof(struct TuxbuzzPackage));
  ackpack.message = getuid();
  strncpy(ackpack.data,TUXBUZZKEY_SERVER,24);
  
  
  
  
   
	
  bzero(&addr,sizeof(addr));
  addr.sin_family = AF_INET;
  addr.sin_port = htons(port);
  addr.sin_addr.s_addr = INADDR_ANY;

 
  if((sockfd=socket(AF_INET,SOCK_STREAM,0))==-1){
    /*perror("socket");*/
    return(errno);
}

  if(bind(sockfd,(struct sockaddr*) &addr,sizeof(addr))==-1){
    /*perror("bind");*/
    return(errno);
  }
  
  

  if(listen(sockfd,5)==-1){
    /*perror("listen");*/
    return(errno);
}


 #ifdef TUXBUZZ_DEBUG
    fprintf(stdout,"TuXBuZZ Server "VERSION" bY DoC#incluDe listening on port %d\n",port);
    fprintf(stdout,"(this version was compiled for debuging)\n");
    fflush(stdout); /* parece um bug de buffers : ( */
  #endif


 

  
  for(;;){ /* o loop principal do servidor */
    int client;
    int rq_result = 0;
    struct TuxbuzzPackage pack;
    struct sockaddr_in clientaddr;
    int size = sizeof(addr);
    int bytes;
	  char *clientip = NULL;
    
    
    client = accept(sockfd,(struct sockaddr*) &clientaddr,&size);
    
    if(!fork()){close(sockfd);
    clientip = inet_ntoa(clientaddr.sin_addr);
    bzero(&pack,sizeof(struct TuxbuzzPackage));
    recv(client,&pack,sizeof(struct TuxbuzzPackage),0);
    
    if(!strncmp(pack.data,TUXBUZZKEY_CLIENT,24)){
    send(client,&ackpack,sizeof(struct TuxbuzzPackage),0);
    do{
      bzero(&pack,sizeof(struct TuxbuzzPackage));
      bytes = recv(client,&pack,sizeof(struct TuxbuzzPackage),0);
      rq_result = parse_requests(pack,client);
      #ifdef TUXBUZZ_DEBUG
      switch(rq_result){
      case MSG_GET:
        fprintf(stdout,"received client request MSG_GET from %s\n",clientip);
      break;
      case MSG_RINFO_REMOTE:
      fprintf(stdout,"received client request MSG_RINFO_REMOTE from %s\n",clientip);
      break;
      case MSG_RINFO_USER:
      fprintf(stdout,"received client request MSG_RINFO_USER from %s\n",clientip);
      break;
      case MSG_DISCONNECT:
      fprintf(stdout,"received client request MSG_DISCONECT from %s\n",clientip);
      break;
      }
      fflush(stdout);
      #endif
      }while(rq_result!=MSG_DISCONNECT);
     }else
        close(client);
 
  /*close(sockfd);*/
/*return 0;*/  
exit(0);
}
  /* teoricamente, nunca deve chegar aqui !!!! */
  close(client);
 /* return(0);*/
}

}
/* fim de client.c */
