/**************************************************************************
TuXBuZZ - bY DoC#include
commands.h
**************************************************************************/

#ifndef COMMANDS_H
#define COMMANDS_H

#include <stdio.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
#include <sys/socket.h>
#ifdef LINUX
  #include <resolv.h> /* exclusivo do linux */
#endif
#include <netinet/in.h>
#include <arpa/inet.h>
#include <sys/utsname.h> /* para struct utsname em info remote */
#include <pwd.h>
#include <stdlib.h>


#define PORT 8081     /* porta padrao usada pelo servidor */
#define VERSION "v0.0.2b"



int sockfd = -1;      /* nosso socket */
int port = PORT;      /* a porta - valor inicial igual ao padrao */
struct sockaddr_in addr;

int connected = 0;    /* flag indicando estar connectado (=1) ou desconectado (=0) */

int bytesreceived = 0; /* total de bytes recebidos numa conexao */
int bytessended = 0;   /* total de bytes enviados numa conexao */




/* mostrada por process_cmd_help() */
char *usage = "commands:\n"
             "connect <ip_address> [port_number]\n"
             "close\n"
             "get <remote_file_name> <local_file_name>\n"
       			 "rinfo <remote> or <user>\n"      
						 "quit\n"
             "cd <new_directory>\n"
             "ls\n"
             "pwd\n"
             "exec <command line>\n";

/* faz o parse de comando digitado e chama a funcao relativa passando os argumentos, se existirem */

int parse_cmd(char* cmd); 


/* executam os comandos */

int process_cmd_connect(char *cmdargs); /* conecta no servidor */
int process_cmd_get(char *cmdargs); /* puxa um arquivo do servidor */
int process_cmd_close(); /* encerra uma conexao */
int process_cmd_rinfo(char *cmdargs); /* pega informacoes */
int process_cmd_help(); /* exibe a ajuda sobre os comandos */
void process_cmd_quit();
int process_cmd_scan(char *cmdargs);
int process_cmd_ls(char *cmdargs);
int process_cmd_cd(char *cmdargs);
int process_cmd_pwd();
int process_cmd_exec(char *cmdargs);
int process_local_shell_cmd(char *cmdargs);

#endif

/* fim de commands.h */
