/**************************************************************************
TuXBuZZ - client bY DoC#include
commands.h
**************************************************************************/

#ifndef COMMANDS_H
#define COMMANDS_H

#include <stdio.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
#include <sys/socket.h>

#ifdef LINUX  
  #include <resolv.h> /* exclusivo do linux */
#endif

#include <netinet/in.h>
#include <arpa/inet.h>
#include <sys/utsname.h> /* para struct utsname em info remote */
#include <pwd.h>


#define BUFF_LEN 1024    /* tamanho do buffer generico */


/* ---------------------------------------------------------------------------
macros dos valores retornados por parse_cmd() apos chamar a funcao especifica para executar cada comando. 
----------------------------------------------------------------------------*/

#define CMD_GET 1     /* process_cmd_get() */        
#define CMD_QUIT 2    /* process_cmd_quit() */
#define CMD_CONNECT 3 /* process_cmd_connect() */
#define CMD_CLOSE 4   /* process_cmd_close() */
#define CMD_RINFO 5    /* process_cmd_rinfo() */
#define CMD_HELP 6    /* process_cmd_help() */

#define PORT 8081     /* porta padrao usada pelo servidor */
#define VERSION "v0.0.1b"

#define RQ_INFO_REMOTE "01"
#define RQ_INFO_USER   "02"

int sockfd = -1;      /* nosso socket */
int port = PORT;      /* a porta - valor inicial igual ao padrao */
struct sockaddr_in addr;
struct utsname machine; /* para receber informacoes basicas da maquina servidor */
int connected = 0;    /* flag indicando estar connectado (=1) ou desconectado (=0) */

int bytesreceived = 0; /* total de bytes recebidos numa conexao */
int bytessended = 0;   /* total de bytes enviados numa conexao */

char buff[BUFF_LEN];   /* buffer generico */


/* mostrada por process_cmd_help() */
char *usage = "commands:\n"
             "connect <ip_address> [port_number]\n"
             "close\n"
             "get <remote_file_name> <local_file_name>\n"
       			 "info <remote>\n"      
						 "quit\n";

/* faz o parse de comando digitado e chama a funcao relativa passando os argumentos, se existirem */

int parse_cmd(char* cmd); 


/* executam os comandos */

int process_cmd_connect(char *cmdargs); /* conecta no servidor */
int process_cmd_get(char *cmdargs); /* puxa um arquivo do servidor */
int process_cmd_close(); /* encerra uma conexao */
int process_cmd_rinfo(char *cmdargs); /* pega informacoes */
int process_cmd_help(); /* exibe a ajuda sobre os comandos */
void process_cmd_quit();

struct package {
int size;
char data[1024];
};

struct package pack;

#define TUXBUZZKEY "AaYuiYttRe45%)9)-_==+ttY"          

struct tuxbuzzack{
uid_t serveruid;
char tuxbuzzkey[25];
};

#endif

/* fim de commands.h */
