/*
queue.hxx
Pedro Flynn - pflynn@microsoftsucks.org & grupo
*/

#ifndef QUEUE_HXX
#define QUEUE_HXX

extern "C++" {

#include "list.hxx"
	
typedef  ListElmt QueueElmt;

class Queue : private List {
public: 
	Queue() : List() {};
	Queue(void (*destroyfcn)(void*)) : List(destroyfcn){};
	#ifdef DEBUGLIST
		Queue(void (*printfcn)(const void*)) : List(printfcn){};	
		Queue(void (*destroyfcn)(void*) ,void (*printfcn)(const void*)) : List(destroyfcn,printfcn){};
	#endif
  int getSize(){return size;}
	QueueElmt* getFirst(){return head;}
	QueueElmt* getLast(){return tail;}
	int enqueue(const void* data){return List::insertNext(tail,data);}
	void* dequeue(){return List::removeNext(NULL);}
	void empty(){List::destroy();}
	#ifdef DEBUGLIST
		void printQueue(){List::printElmts();}
	#endif
};

}
#endif