/*
mazegraph.cxx
Pedro Flynn - pflynn@microsoftsucks.org & grupo
*/

#include "mazegraph.hxx"
#include "stack.hxx" // so para findRouteAny()
#include "queue.hxx" // so para findRouteByQueue()
#include <float.h> // para DBL_MAX


// MazeVertex 
MazeVertex::MazeVertex()
{
this->i = -1;this->j = -1; color = white;root = NULL; d = DBL_MAX;
adjacents = new List();
}

ostream& operator<<(ostream& os,MazeVertex& vertex)
{
os << '(' << vertex.i << ',' << vertex.j << ')';
return os;	
}

ostream& operator<<(ostream& os,MazeVertex* vertex)
{
os << '(' << vertex->i << ',' << vertex->j << ')';
return os;	
}


// MazeGraph

MazeGraph::MazeGraph(int* maze,int maxi,int maxj)
{
vertexes = new List(); // inicializa a lista de vertices;

this->maxi = maxi; 
this->maxj = maxj;

// Uma matriz maxi X maxj para conter um vertice para cada ponto de maze

MazeVertex* mvertexes = new MazeVertex[maxi*maxj];

// iniciando os vertices apartir de maze

for(int i=0;i<maxi;++i)
	for(int j=0;j<maxj;++j){
	
		
		MazeVertex* curvertex = (mvertexes + i*maxj + j);
		curvertex->i = i; // seta a coordenada i
		curvertex->j = j; // seta a cordenada j
		
		if(!(*(maze + i*maxj + j)))
			curvertex->type = room;
		else
			curvertex->type = wall;
	
   
// aqui olhamos para os pontos adjacentes na matriz maze. Se o ponto maze[i][j] for
// uma passagem, ie, maze[i][j] == 0, entao um ponto adjacente a ele que tambem for
// uma passagem estara conectado a ele devendo entao ser seu vertice adicionado na
// lista de adjacencias do vertice correspondente a maze[i][j]
		
		// olha para cima:
		
		if(i>0)
			if(!(*(maze + i*maxj + j)) && !(*(maze + (i-1)*maxj + j)))
				curvertex->addAdjacent(mvertexes + (i-1)*maxj + j);
		
		// olha para baixo
		if(i<(maxi-1))
			if(!(*(maze + i*maxj + j)) && !(*(maze + (i+1)*maxj + j)))  
				curvertex->addAdjacent(mvertexes + (i+1)*maxj + j);
		
		// olha para a direita
		if(j<(maxj-1))
			if(!(*(maze + i*maxj + j)) && !(*(maze + i*maxj + j + 1))) 
				curvertex->addAdjacent(mvertexes + i*maxj + j + 1);
		
			
		// olha para a esquerda
		if(j>0)
			if(!(*(maze + i*maxj + j)) && !(*(maze + i*maxj + j - 1))) 
				curvertex->addAdjacent(mvertexes + i*maxj + j - 1);
		

		// agora podemos inserir o vertice no grafo
	vertexes->insertNext(NULL,curvertex);
	}
	
// essa matriz e um atalho para os vertices do grafo, de forma que possamos acessar um 
// vertice do grafo diretamente pelas coordenadas i e j, sem ter que varrer a lista

	
	vertexarray = mvertexes;		

}

MazeVertex* MazeGraph::getVertex(int i,int j){
return  (i<0 || j<0 || i>=maxi || j>=maxj)?NULL:(vertexarray + i*maxj + j);
}

// faz o relaxamento entre dois vertices u,v conectados
void MazeGraph::relax(MazeVertex* u,MazeVertex* v){
	if(v->d > u->d + 1.0){
		v->d = u->d + 1.0;
		v->root = u;
	}
	
}
	
// encontra o menor caminho, no grafo, para um vertice em relacao aos demais vertices
// conectados a ele, usando o Algoritimo de Dijkstra
void MazeGraph::findRoute(int fromi,int fromj){
double min;
ListElmt* element;
MazeVertex *vertex = NULL,*adjvertex;

// seta a estimativa de distancia d do vertice para 0
getVertex(fromi,fromj)->d = 0;


// o laco e repetido uma vez para cada vertice no grafo
int i = 0;
while(i < vertexes->getSize()){

	// seleciona o vertice branco com o menor valor de d
	min = DBL_MAX;
	for(element = vertexes->getHead();element;element = element->getNext()){
		MazeVertex* tmp = (MazeVertex*) element->getData();
		if( (tmp->color == white) && (tmp->d < min) ){
			vertex = (MazeVertex*) element->getData();;
			min = vertex->d;
			}
}

vertex->color = black; // colorimos o vertice selecionado de preto


// anda pela lista de vertices adjacentes a vertex
	List* adjacentslist = vertex->getAdjacents();
	for(element = adjacentslist->getHead();element;element = element->getNext()){
		adjvertex = (MazeVertex*) element->getData();
		relax(vertex,adjvertex); // faz o relaxamento entre os vertices
		}
i++ ; // pronto para ir para o proximo vertice
}	

}


// acha o caminho para qualquer vertice em relacao a um vertice origem, de coordenadas
// fromi,fromj, utilizando pilhas. Nao acha necessariamente o menor caminho. Para encontrar
// o menor caminho, veja o Mazegraph::findRoute()
void MazeGraph::findRouteAny(int fromi,int fromj)
{
	Stack* stack = new Stack();
	MazeVertex *vertex,*nextvertex;
	
	vertex = (vertexarray + fromi*maxj + fromj); // pega o vertice inicial
	stack->push(vertex); // adiciona o vertice na pilha 
	
	while(stack->getSize()){
	
		vertex = (MazeVertex*) stack->pop(); // tira um vertice da pilha
		vertex->color = black; // pinta de preto, para nao ser adicionado novamente na pilha
		// varre a lista de vertices adjacentes ao vertice retirado da pilha
		for(ListElmt* element = vertex->adjacents->getHead();element;element=element->getNext()){
			nextvertex = (MazeVertex*) element->getData();
			// se o vetice adjacente estiver branco, marca seu root como vertex e o coloca na pilha
			if(nextvertex->color == white){
				nextvertex->root = vertex;
				stack->push(nextvertex);
		}
		}
	
		}
	stack->empty(); /* fim - podemos destruir a pilha */
}


// encontra o menor caminho entre duas salas, usando fila
// produz o mesmo resultado de MazeGraph::findRoute (que usa Dijkstra)
void MazeGraph::findRouteByQueue(int fromi,int fromj,int toi,int toj)
{
Queue* queue = new Queue();
MazeVertex *vertex,*nextvertex;

vertex = (vertexarray + fromi*maxj + fromj); // pega o vertice inicial
vertex->d = 0;

queue->enqueue(vertex); // adiciona o vertice na fila	


while(queue->getSize()){


vertex = (MazeVertex*) queue->dequeue();  // tira um vertice da fila

vertex->color = black; // pinta de preto, para nao ser adicionado novamente na fila
// varre a lista de vertices adjacentes ao vertice retirado da pilha
		for(ListElmt* element = vertex->adjacents->getHead();element;element=element->getNext()){
			nextvertex = (MazeVertex*) element->getData();
			// se o vetice adjacente estiver branco o coloca na fila
			if(nextvertex->color == white ){
			  nextvertex->d = vertex->d + 1;
				queue->enqueue(nextvertex);
			}
		}
	

		}
		
		
		vertex = (vertexarray + toi*maxj + toj);
		MazeVertex* origvertex = (vertexarray + fromi*maxj + fromj);
		if(vertex->d != DBL_MAX)
		while(vertex != origvertex){
		for(ListElmt* element = vertex->adjacents->getHead();element;element=element->getNext()){
			nextvertex = (MazeVertex*) element->getData();
			if(nextvertex->d == vertex->d -1){
				vertex->root = nextvertex;
			  vertex = nextvertex;
				}
				}
			}
		queue->empty();
}

// reinicia os vertices (cor, root e d) para poder aplicar findRouteXXX novamente
void MazeGraph::resetVertexes()
{
MazeVertex* vertex;
ListElmt* element;
	
for(element = vertexes->getHead();element;element=element->getNext()){
	vertex = (MazeVertex*) element->getData();
	vertex->color = white;
	vertex->d = DBL_MAX;
	vertex->root = NULL;
}
}