/*
maze.cxx
Pedro Flynn - pflynn@microsoftsucks.org & grupo
*/

#include "mazegraph.hxx"
#include "stack.hxx"
#include <fstream.h>
#include <string.h>
#include <stdlib.h>

void usage();
void message(int msg);
int* loadarray(int& lines,int& cols,const char* file); // carrega a matriz a partir de um arquivo
int vertexequal(const void* v1,const void* v2); // para comparar dois vertices


int main(int argc,char** argv)
{
int lines=0,cols=0; // numero de linhas e colunas do labirinto
int bydijkstra = 0,byqueue = 0;	
char* file = NULL;	

if(argc<2) 
	usage();
if(argc>2)
	for(int i=1;i<argc;++i){
		if(!strncmp(argv[i],"-D",2) || !strncmp(argv[i],"--usar-dijkstra",15))
			bydijkstra = 1;
 		else if(!strncmp(argv[i],"-Q",2) || !strncmp(argv[i],"--usar-fila",12))
					byqueue = 1;
	
if(!strncmp(argv[i],"-f",2))
	file = argv[i+1];
	                       }
if(!file)
	usage();

int *maze = loadarray(lines,cols,file); // a matriz do labirinto que vai virar o grafo
if(!maze){ 
	cout << "Erro lendo arquivo " << argv[1] << endl;
	exit(1);
	}

cout << "Labirinto " << lines << " X " << cols << endl;
cout << "Construindo grafo...";
MazeGraph mg(maze,lines,cols); // constroi o grafo, a partir da matriz do labirinto
cout << "OK" << endl;


if(!bydijkstra && !byqueue){ // o padrao: usar o algoritimo de PILHA
	message(0);
	mg.findRouteAny(0,0);
	}
else if(!bydijkstra && byqueue){ // usa o algoritimo de FILA
	message(1);
	mg.findRouteByQueue(0,0,lines-1,cols-1);
}else{ // usa Dijkstra
	message(2);
	mg.findRoute(0,0);
	}

// pega o vertice que e a saida
MazeVertex* vertex = mg.getVertex(lines-1,cols-1);

// empilha todos os vertices pertencentes a uma rota
Stack stack(vertexequal);
for(;vertex;vertex=vertex->getRoot())
	stack.push(vertex);


#ifdef ANSI_COLORS // a maioria das maquinas Windoze nao vem com adaptador ansi ativado : (
for(int i=0;i<lines;i++)
	for(int j=0;j<cols;++j){
		vertex = mg.getVertex(i,j);
		cout << "\033[37m";
		if(vertex->getType() == wall)
			cout << "\033[47m" << vertex << "\033[40m" << "\033[37m";
		else if(stack.elementIsMember(vertex))
			cout << "\033[44m" << "\033[1m" << vertex 
		  << "\033[0m" << "\033[40m" << "\033[37m";
		else
			cout << "\033[44m" << vertex << "\033[40m" << "\033[37m";
		cout << (j==(cols-1)?"\n":"");
		}
 cout << "\033[37m";
#else // sem cores - para Windoze ( nao e hora de instalar um Linux ou um *BSD na maquina ?) 
cout << endl << "[X] = parede\n[ ] = sala nao percorrida\n[#] = sala percorrida\n\n";
for(int i=0;i<lines;i++)
for(int j=0;j<cols;++j){
vertex = mg.getVertex(i,j);
if(vertex->getType()==wall)
cout << "[X]";
else if(stack.elementIsMember(vertex))
cout << "[#]";
else cout << "[ ]";

cout << (j==(cols-1)?"\n":""); 
}
#endif
return 0;	
}

int* loadarray(int& lines,int& cols,const char* file){
char buff[1024];
lines=0,cols=0;
ifstream sfile;

sfile.open(file,ios::in | ios::nocreate);

if(!sfile) return NULL;
int len;

while(sfile.getline(buff,1024))
	if(len = strlen(buff)){ ++lines;cols = len;};


sfile.close();

sfile.open(file,ios::in | ios::nocreate);	

int* array = new int[lines*cols];

char ch;int pos=0;
while(!sfile.eof()){
	sfile.get(ch);
	if(ch == '0' || ch == '1')
		array[pos++]=(int) (ch - 48);
	}
	
	sfile.close();
return array;
}

int vertexequal(const void* v1,const void* v2)
{
MazeVertex *mv1 = (MazeVertex*) v1,*mv2 = (MazeVertex*) v2;
return (mv1->getI() == mv2->getI() && mv1->getJ() == mv2->getJ());
}

void usage(){
cout << 
"uso: maze [opcoes] -f <arquivo.ascii>" 
"\n\n\tMaze le um arquivo texto contendo zeros (0) e uns (1)"
" e o interpreta como um labirinto, onde os zeros repre"
"sentam passagems e os uns representam paredes. O progra"
"ma constroi entao um grafo a partir desse labirinto e en"
"contra um possivel caminho ligando a entrada (canto "
"superior esquerdo) ate a saida (canto inferior direito).\n"
"\tO caminho pode ser encontrado de tres formas diferentes:\n\n"
"1 - Usando um algoritimo baseado em uma PILHA (padrao)\n"
"2 - Usando um algoritimo baseado em uma FILA.\n"
"3 - Usando o algoritimo de Dijkstra.\n\n"
"O algoritimo de PILHA tem comportamento \"imprevisivel\", e"
" nao necessariamente vai encontrar o \"menor caminho\". Os al"
"goritimos de FILA e de Dijkstra vao encontrar o menor caminho.\n\n"
"Opcoes:\n"
"-D ou --usar-dijkstra: acha o menor caminho utilizando"
"o algoritimo de Dijkstra.\n"
"-Q ou --usar-fila:     acha o menor caminho utilizando"
"o algoritimo baseado em FILA.\n\n";

cout << "Pedro Flynn - pflynn@microsoftsucks.org & grupo\n";
exit(1);	
}

void message(int msg){
switch (msg){
	case 0:
	cout << "Usando algoritimo de PILHA (veja as opcoes -D/--usar-dijkstra e"
	" -Q/--usar-fila para os outros algoritimos.\n";
	break;
	case 1:
	cout << "Usando algoritimo de FILA.\n";
	break;
	case 2:
	cout << "Usando algoritimo de Dijkstra.\n";
	break;
	}
}