/*
stack.hxx
Pedro Flynn - pflynn@microsoftsucks.org
*/

#ifndef STACK_HXX
#define STACK_HXX

extern "C++" {

#include "list.hxx"
	
typedef  ListElmt StackElmt;

class Stack : private List {
public: 
	Stack() : List() {};
	Stack(int (*match)(const void*,const void*)) : List(match){}
	Stack(void (*destroyfcn)(void*)) : List(destroyfcn){};
	#ifdef DEBUGLIST
		Stack(void (*printfcn)(const void*)) : List(printfcn){};	
		Stack(void (*destroyfcn)(void*) ,void (*printfcn)(const void*)) : List(destroyfcn,printfcn){};
	#endif
	int getSize(){return size;}
	StackElmt* getTop(){return head;}
	StackElmt* getBotton(){return tail;}
	int push(const void* data){return List::insertNext(NULL,data);}
	void* pop(){return List::removeNext(NULL);}
	void empty(){List::destroy();}
	int elementIsMember(const void* data){return List::elementIsMember(data);}
	#ifdef DEBUGLIST
		void printStack(){List::printElmts();}
	#endif
	};

}
#endif