/*
mazegraph.hxx
Pedro Flynn - pflynn@microsoftsucks.org
*/

#ifndef MAZEGRAPH_H
#define MAZEGRAPH_H

#include "list.hxx"
#include <iostream.h>

enum VertexColor {white,black};
enum VertexType  {room,wall};

class MazeVertex{
	private:
	int i,j;
	MazeVertex* root;
	VertexColor color;
	VertexType type;
	double d;
  List* adjacents;
public:
	MazeVertex();
	int getI(){return i;}
	void setI(int i){this->i = i;}
	int getJ(){return j;}
	void setJ(int j){this->j = j;}
	MazeVertex* getRoot(){return root;}
	void setRoot(MazeVertex* root){this->root = root;}
	double getD(){return d;}
	void setD(double d){this->d = d;}
	VertexColor getColor(){return color;}
	void setColor(VertexColor color){this->color =color;}
  VertexType getType(){return type;}
	void setType(VertexType type){this->type = type;}
	int addAdjacent(MazeVertex* vertex){return adjacents->insertNext(NULL,vertex);}
  List* getAdjacents(){return adjacents;}
	
	friend ostream& operator<<(ostream&,MazeVertex&);
	friend ostream& operator<<(ostream&,MazeVertex*);
	friend class MazeGraph;
	};

class MazeGraph
{
private:
	List* vertexes;
	int maxi,maxj;
  MazeVertex* vertexarray;
	void relax(MazeVertex* u,MazeVertex* v);
public:
	MazeGraph(int* maze,int maxi,int maxj);
	int addVertex(MazeVertex* vertex){return vertexes->insertNext(NULL,vertex);}
  MazeVertex* getVertex(int i,int j);
	List* getVertexList(){return vertexes;}
	void findRoute(int fromi,int fromj);
	void resetVertexes();
	};
	
#endif