/*
maze.cxx
Pedro Flynn - pflynn@microsoftsucks.org
*/

#include "mazegraph.hxx"
#include "stack.hxx"
#include <fstream.h>
#include <string.h>

int* loadarray(int& lines,int& cols,const char* file); // carrega a matriz a partir de um arquivo
int vertexequal(const void* v1,const void* v2); // para comparar dois vertices
void usage();

int main(int argc,char** argv)
{
int lines=0,cols=0;
	
	

if(argc<2) usage();

int *maze = loadarray(lines,cols,argv[1]);



cout << "Labirinto " << lines << " X " << cols << endl;
cout << "Construindo grafo...";
MazeGraph mg(maze,lines,cols);
cout << "OK" << endl;

cout << "Aplicando Dijkstra...";
mg.findRoute(0,0);
cout << "OK" << endl;

MazeVertex* vertex = mg.getVertex(lines-1,cols-1);

Stack stack(vertexequal);
for(;vertex;vertex=vertex->getRoot())
	stack.push(vertex);


for(int i=0;i<lines;i++)
	for(int j=0;j<cols;++j){
		vertex = mg.getVertex(i,j);
		cout << "\033[37m";
		if(vertex->getType() == wall)
			cout << "\033[47m" << vertex << "\033[40m" << "\033[37m";
		else if(stack.elementIsMember(vertex))
			cout << "\033[44m" << "\033[1m" << vertex 
		  << "\033[0m" << "\033[40m" << "\033[37m";
		else
			cout << "\033[44m" << vertex << "\033[40m" << "\033[37m";
		cout << (j==(cols-1)?"\n":"");
		}
cout << "\033[37m";

return 0;	
}

int* loadarray(int& lines,int& cols,const char* file){
char buff[1024];
lines=0,cols=0;
ifstream sfile;

sfile.open(file);
int len;

while(sfile.getline(buff,1024))
	if(len = strlen(buff)){ ++lines;cols = len;};

sfile.close();
sfile.open(file);	

int* array = new int[lines*cols];

char ch;int pos=0;
while(!sfile.eof()){
	sfile.get(ch);
	if(ch == '0' || ch == '1')
		array[pos++]=(int) (ch - 48);
	}
	
	sfile.close();
return array;
}

int vertexequal(const void* v1,const void* v2)
{
MazeVertex *mv1 = (MazeVertex*) v1,*mv2 = (MazeVertex*) v2;
return (mv1->getI() == mv2->getI() && mv1->getJ() == mv2->getJ());
}

void usage()
{
cout << "uso: maze <arquivo.ascii>" << endl << endl;
cout << "Maze le um arquivo texto contendo zeros (0) e uns (1)\n"
	      "e o interpreta como um labirinto, onde os zeros repre\n"
	      "sentam passagems e os uns representam paredes. O progra\n"
	      "ma constroi entao um grafo a partir desse labirinto e en\n"
        "contra o menor caminho possivel ligando a entrada (canto\n"
	      "superior esquerdo) ate a saida (canto inferior direito).Pa\n"
	      "ra fazer isso, maze aplica o algoritimo de Dijkestra ao grafo.\n";
exit(1);
}