/*
list.hxx
Pedro Flynn - pflynn@microsoftsucks.org
*/

#ifndef LIST_HXX
#define LIST_HXX


extern "C++" {
	
#ifndef NULL
#ifdef __GNUG__
#define NULL (__null)
#else
#define NULL (0)
#endif
#endif
	
// ListElmt - Linked list element class
	
class ListElmt {
private:	
	void* data;
	ListElmt *next;

public:
	ListElmt(const void* data){this->data = (void*) data;}
	void* getData(){return data;}
	ListElmt* getNext(){return next;}

	friend class List; 	
};	

// List -  Linked list class

class List {
protected:
	int size;
	ListElmt *head,*tail;
 	void (*destroyfcn)(void*);
	#ifdef DEBUGLIST
		void (*printfcn)(const void*);	
	#endif
	int (*match)(const void*,const void*);
public:
	List();
	List(int (*match)(const void*,const void*));
	List(void (*destroyfcn)(void*));
	~List();
	#ifdef DEBUGLIST
		List(void (*printfcn)(const void*));	
		List(void (*destroyfcn)(void*) ,void (*printfcn)(const void*));
	#endif
	int getSize(){return size;}
	ListElmt* getHead(){return head;}
	ListElmt* getTail(){return tail;}
	int insertNext(ListElmt* element,const void* data);
	void* removeNext(ListElmt* element);
	void destroy();
	#ifdef DEBUGLIST
		void printElmts();
	#endif
	int elementIsMember(const void *data);
	};

}
#endif 

// end of list.hxx