/*
list.cxx
Pedro Flynn - pflynn@microsoftsucks.org
*/

extern "C++" {
	
#include "list.hxx"


List::List()
{
size = 0; 
head = tail = NULL; 
destroyfcn = NULL;
#ifdef DEBUGLIST
	printfcn = NULL;
#endif
}

List::List(int (*match)(const void*,const void*))
{
size = 0; 
head = tail = NULL; 
destroyfcn = NULL;
#ifdef DEBUGLIST
	printfcn = NULL;
#endif
this->match = match;	
}

List::List(void (*destroyfcn)(void*))
{
size = 0; 
head = tail = NULL; 
this->destroyfcn = destroyfcn;
#ifdef DEBUGLIST
	printfcn = NULL;
#endif
}

#ifdef DEBUGLIST
	List::List(void (*printfcn)(const void*))
	{
	size = 0; 
	head = tail = NULL; 
	destroyfcn = NULL;
	this->printfcn = printfcn;
	}

	List::List(void (*destroyfcn)(void*) ,void (*printfcn)(const void*))
	{
	size = 0; 
	head = tail = NULL; 
	this->destroyfcn = destroyfcn;
	this->printfcn = printfcn;
	}

	void List::printElmts()
	{
	for(ListElmt* element = head;element;element = element->next)
		printfcn(element->data);
	}
#endif

List::~List(){ if(size) destroy();}


int List::insertNext(ListElmt* element,const void* data)
{
ListElmt* newelement;

if(!(newelement = new ListElmt(data)))
	return -1; 

if(!element){
	
	if(!size)
		tail = newelement;
	
	newelement->next = head;
	head = newelement;
	
}else{
	
	if(!element->next)
		tail = newelement;
	
	newelement->next = element->next;
	element->next = newelement;
	
}

size++;
return 0;
}

void* List::removeNext(ListElmt* element)
{
void* data;
ListElmt* oldelement;
	
if(!size)
	return NULL;

if(!element){
	
	data = head->data;
	oldelement = head;
	head = head->next;
	
	if(size == 1)
		tail = NULL;
	
}else{
	
	if(!element->next)
		return NULL;
	
	data = element->next->data;
	oldelement = element->next;
	element->next = element->next->next;
	
	if(!element->next)
		tail = element;
	
}

delete oldelement;
size--;
return data;
}

int List::elementIsMember(const void* data)
{
if(!match) return -1;
for(ListElmt* element=head;element;element=element->next)
	if(match(data,element->data))
		return 1;
	
return 0;
}

void List::destroy()
{
void* data = NULL;

while(size)
	if((data = removeNext(NULL)) && destroyfcn)
		destroyfcn(data);

return;
}

}