; Author:         Johannes Egger
;                 Student, Technical University of Vienna
;                 e-mail: spradmin@spr.darkrealms.org
;                         Johannes.Egger@spr.darkrealms.org
; File:           spr-list.mrc
; Version:        1.1
; Creation Date:  2001, May 13th
; Last Change:    2001, May 29th, 24:45
;                 we need to sort this crap alphabetically
;
; Special note:   This (and a lot of other things) would not have been possible
;                 without Peter Warasin <Peter.Warasin@spr.darkrealms.org>
;                 and his efforts in coding listbot.dll
;                 listbot.dll used with explicit permission of the author.
;
; Thanks to:      Peter Warasin (mentioned above).
;                 Kavey, for pointing something out to me.
;                 my girlfriend (who doesn't know/give much about IRC), for just being herself.
;
; description:    solves the 32,767 limit... hopefully forever.


on *:START:spr.list



ALIAS -l spr.logo if ($colour(background) == 1) return 15[11S13p15R15] | else return 1[10S13p14R1]
ALIAS -l spr.e {
  if ($colour(background) == 1) var %spr.e.c = 15 | else var %spr.e.c = 1
  if ($1 == $null) return
  if ((($left($1,1) == @) && ($window($1))) || ($1 == -a) || ($1 == -s)) echo %smc.n $1 $spr.logo  $+ %spr.e.c $+ $2-
  elseif ($left($1,1) == @) echo -a $spr.logo $2- | else echo %smc.n -a $spr.logo  $+ %spr.e.c $+ $1-
}
ALIAS -l spr.el var %spr.e.x = 0 | :spr.l | inc %spr.e.x | if ((($left($1,1) == @) && ($window($1))) || ($1 == -a) || ($1 == -s)) echo $1  | else echo -a  | if (%spr.e.x < $2) goto spr.l

ALIAS -l spr.l.e spr.e %spr.l.stats $1-
ALIAS -l spr.l.el spr.el %spr.l.stats $1-

ALIAS -l spr.h.e spr.e %spr.h.stats $1-
ALIAS -l spr.h.el spr.el %spr.h.stats $1-

ALIAS -l sprdir { if ($1 == $null) return $mircdirspr\ | else return $mircdirspr\ $+ $1 }
ALIAS -l sprvers return 8.7-rc4


; C`Dera gave this to me a long time ago :-)
ALIAS spr.size {
  var %spr.size
  if (($1 < 0) ||($1 !ISNUM)) return n/a
  if ($round($calc($1 / 1000000000000),1) >= 1) %spr.size = $round($calc($1 / 1099511627776),1) TB  
  elseif ($round($calc($1 / 1000000000),1) >= 1) %spr.size = $round($calc($1 / 1073741824),1) GB
  elseif ($round($calc($1 / 1000000),1) >= 1) %spr.size = $round($calc($1 / 1048576),1) MB
  elseif ($round($calc($1 / 1000),1) >= 1) %spr.size = $round($calc($1 / 1024),1) KB
  elseif ($1 == 0) %spr.size = 0.0 KB
  if ($chr(46) !ISIN %spr.size) %spr.size = $gettok(%spr.size,1,32) $+ .0 $gettok(%spr.size,2,32)
  %spr.size = $gettok(%spr.size,1,32) $+ $gettok(%spr.size,2,32)
  return %spr.size
}


ALIAS spr.list {
  unset %spr.l.dirs* %spr.l.ext*

  ; what type of list are we gonna make?
  if ($exists($sprdir(sprcounter.ini)) == $false) set %spr.l.dirlist $true 
  else {
    set %spr.l.t $readini($sprdir(sprcounter.ini),listmake,gear)
    if (%spr.l.t == topdownload) { update.chart $readini($sprdir(sprcounter.ini),listmake,hitkind) | return }
    if (%spr.l.t == 2) set %spr.l.dirlist $false | else set %spr.l.dirlist $true
  }
  ; stats-window
  set %spr.l.stats @spr.list.stats
  if ($window(%spr.l.stats) != $null) window -c %spr.l.stats
  window -hdfko %spr.l.stats 500 100 450 200
  spr.l.e Gathering information... | spr.l.el
  ; drives
  set %spr.l.i 0 | set %spr.l.dirs. [ $+ [ %spr.l.i ] ] $readini($sprdir(sprcounter.ini),drive,%spr.l.i)
  while ([ %spr.l.dirs. [ $+ [ %spr.l.i ] ] ] != $null) {
    %spr.l.dirs = %spr.l.dirs $+ %spr.l.dirs. [ $+ [ %spr.l.i ] ] $+ $chr(255)
    inc %spr.l.i | set %spr.l.dirs. [ $+ [ %spr.l.i ] ] $readini($sprdir(sprcounter.ini),drive,%spr.l.i)
  }
  if (%spr.l.dirs == $null) { spr.l.e No directories specified! Listmake aborted! | return }
  ; %spr.l.dirs = $left(%spr.l.dirs,$calc($len(%spr.l.dirs) - 1))
  ; extensions
  set %spr.l.i 0 | set %spr.l.ext. [ $+ [ %spr.l.i ] ] $readini($sprdir(sprcounter.ini),Extension,%spr.l.i)
  while ([ %spr.l.ext. [ $+ [ %spr.l.i ] ] ] != $null) {
    %spr.l.ext = %spr.l.ext $+ %spr.l.ext. [ $+ [ %spr.l.i ] ] $+ $chr(255)
    inc %spr.l.i | set %spr.l.ext. [ $+ [ %spr.l.i ] ] $readini($sprdir(sprcounter.ini),Extension,%spr.l.i)
  }
  if (%spr.l.ext == $null) { spr.l.e No extensions specified! Listmake aborted! | return }
  ; %spr.l.ext = $left(%spr.l.ext,$calc($len(%spr.l.ext) - 1))
  ; misc stuff
  if ($exists($sprdir(sprcounter.ini)) == $false) set %spr.l.nick $nick
  else {
    set %spr.l.nick $readini($sprdir(sprcounter.ini),listmake,nick)
    set %spr.l.filename $readini($sprdir(sprcounter.ini),listmake,name) | %spr.l.filename = %spr.l.filename $+ -MM.txt
  }
  spr.listmake
  .timeroff 1 5 .exit
}



ALIAS -l spr.listmake {
  ; count files and size
  set %spr.l.count.f 0 | set %spr.l.count.s 0

  ; file-window; list-window column
  set %spr.l.window.l.col 70

  ; limit of lines-per-window
  set %spr.l.window.limit 32000

  ; tell user each X-files how many have been processed
  set %spr.l.pf.dot 100 | set %spr.l.pf.line 1000

  ; start!
  set %spr.l.time.begin $ctime

  ; get info which listmake features are needed
  if ($exists($sprdir(sprcounter.ini)) == $false) set %spr.l.features b
  else set %spr.l.features $readini($sprdir(sprcounter.ini),listmake,method)

  ; hash table stuff
  set %spr.l.hash.slots 1000 | set %spr.l.hash sprlist
  if ($hget(%spr.l.hash) != $null) hfree %spr.l.hash
  hmake %spr.l.hash %spr.l.hash.slots

  ; create stats window if it doesn't exist, give it some output
  if ($window(%spr.l.stats) != $null) window -c %spr.l.stats
  window -hdfko %spr.l.stats 450 100 500 200

  if ($exists($sprdir(listbot.dll)) == $false) { spr.l.e listbot.dll not found! listmake aborted! | return }
  spr.l.e Preparing for list-update.. | spr.l.e Started: $fulldate | spr.l.el 

  ; load DLL
  set %spr.dll attempting load | spr.l.e Loading DLL to achieve ID3-information... | %spr.l.dll = $dll($sprdir(listbot.dll), SPR_SetDirectory, $sprdir)
  if ($gettok(%spr.l.dll,1,32) == 200) spr.l.e DLL loaded successfully! | else { spr.l.e Couldn't load listbot.dll- listmake aborted! | return }
  spr.l.el | set %spr.dll loaded

  ; list-window will store actual list
  set %spr.l.window.l @spr.list.1 | set %spr.l.window.f @spr.list1 | set %spr.l.window.l.c 1
  set %spr.l.window.f.c 1 | window -hl %spr.l.window.l | window -hsl %spr.l.window.f
  aline %spr.l.window.l $chr(9) | aline %spr.l.window.l $str($chr(9),2) -{{ List of %spr.l.nick $+ 's multimedia music-files }}-
  aline %spr.l.window.l $chr(9) | aline %spr.l.window.l $chr(9) Last update on: $fulldate by SPR Jukebox $sprvers
  aline %spr.l.window.l $str($chr(9),3) http://spr.darkrealms.org | aline %spr.l.window.l $chr(9)
  aline %spr.l.window.l $str(-=,50) $+ - | aline %spr.l.window.l $chr(9)
  aline %spr.l.window.l To grab a file, from me, type: !mynick exact filename (in a channel window)
  aline %spr.l.window.l or copy and paste a corresponding line to a channel I'm in. | aline %spr.l.window.l $chr(9)
  aline %spr.l.window.l e.g, ! $+ %spr.l.nick Celine Dion - I hate Celine Dion.mp3 | aline %spr.l.window.l $str($chr(9),2)

  ; preface!
  var %spr.l.i = 1, %spr.l.p = $readini($sprdir(sprcounter.ini),preface,%spr.l.i)
  if (%spr.l.p != $null) {
    while (%spr.l.p != $null) {
      if (%spr.l.i == 1) {
        aline %spr.l.window.l $str(-=,2) $+ - $chr(91) Preface $chr(93) $str(-=,41) $+ -
        aline %spr.l.window.l $chr(9)
      }
      if (%spr.l.p == Eptl) %spr.l.p = $chr(9) | aline %spr.l.window.l $chr(9) %spr.l.p | inc %spr.l.i
      set %spr.l.p $readini($sprdir(sprcounter.ini),preface,%spr.l.i)
    }
    aline %spr.l.window.l $chr(9) | aline %spr.l.window.l $str(-=,50) $+ - | aline %spr.l.window.l $chr(9)
  }
  writeini $sprdir(sprcounter.ini) listmake start off

  set %spr.l.i 1
  ; process all dirs
  spr.l.e Generating your file-list...
  while ($gettok(%spr.l.dirs,%spr.l.i,255) != $null) {
    ; get *.* once and clean out what we don't need later
    spr.l.e Processing: $+ $chr(160)
    %spr.l.findresult = $findfile($gettok(%spr.l.dirs,%spr.l.i,255),*.*,0,spr.add $1-)
    inc %spr.l.i 
  }
  %spr.l.pf = $deltok($line(%spr.l.stats,$line(%spr.l.stats,0)),1,32)
  dline %spr.l.stats $line(%spr.l.stats,0) | spr.l.e %spr.l.pf $+ . ( $+ %spr.l.count.f $+ )

  ; merge-sort all windows
  var %spr.l.f, %spr.l.r, %spr.l.l, %spr.l.j = 1 | window -hsl @spr.sort | spr.l.el | spr.l.e Sorting your file-list...
  spr.l.e Processing: $+ $chr(160)
  while ($spr.sort.done == $false) {
    %spr.l.i = 1 | clear @spr.sort
    while (%spr.l.i <= %spr.l.window.f.c) {
      if ($line([ @spr.list $+ [ %spr.l.i ] ],0) != 0) aline @spr.sort $instok($line([ @spr.list $+ [ %spr.l.i ] ],1),%spr.l.i,2,32)
      inc %spr.l.i
    }

    if ($line(%spr.l.window.l,0) >= %spr.l.window.limit) {
      inc %spr.l.window.l.c | set %spr.l.window.l @spr.list. $+ %spr.l.window.l.c | window -hl %spr.l.window.l
    }

    %spr.l.l = $line(@spr.sort,1) | %spr.l.f = $replace($gettok(%spr.l.l,1,32),$chr(255),$chr(32))
    %spr.l.d = $nofile(%spr.l.f) | %spr.l.f = $nopath(%spr.l.f) | %spr.l.r = $deltok(%spr.l.l,1-2,32)
    ; if we are in DIR-mode, get / save current dir and process it
    if (((%spr.l.d.curr == $null) || (%spr.l.d.curr != %spr.l.d)) && (%spr.l.dirlist)) {
      %spr.l.d.curr = %spr.l.d | aline %spr.l.window.l $chr(9)
      aline %spr.l.window.l -----[ %spr.l.d ]----- | aline %spr.l.window.l $chr(9)
    }

    ; do the processbar stuff
    if (%spr.l.pf.dot // %spr.l.j) {
      if ($window(%spr.l.stats) == $null) window -hdfko %spr.l.stats 500 100 450 200
      if (%spr.l.pf.line // %spr.l.j) {
        %spr.l.pf = $deltok($line(%spr.l.stats,$line(%spr.l.stats,0)),1,32)
        dline %spr.l.stats $line(%spr.l.stats,0) | spr.l.e %spr.l.pf $+ . ( $+ %spr.l.j $+ )
        spr.l.e Processing: $+ $chr(160)
      }
      else {
        %spr.l.pf = $deltok($line(%spr.l.stats,$line(%spr.l.stats,0)),1,32)
        rline %spr.l.stats $line(%spr.l.stats,0) $spr.logo  %spr.l.pf $+ .
      }
    }

    aline %spr.l.window.l ! $+ %spr.l.nick %spr.l.f %spr.l.r
    dline [ @spr.list $+ [ $gettok(%spr.l.l,2,32) ] ] 1
    inc %spr.l.j
  }
  %spr.l.pf = $deltok($line(%spr.l.stats,$line(%spr.l.stats,0)),1,32)
  dline %spr.l.stats $line(%spr.l.stats,0) | spr.l.e %spr.l.pf $+ . ( $+ $calc(%spr.l.j - 1) $+ )

  ; close windows
  window -c @spr.sort | %spr.l.i = 1
  while (%spr.l.i <= %spr.l.window.f.c) {
    if ($window([ @spr.list $+ [ %spr.l.i ] ])) window -c @spr.list $+ [ %spr.l.i ]
    inc %spr.l.i
  }

  ; done...
  spr.l.el 2 | spr.l.e Done generating your file-list. | spr.l.el | spr.l.e Unloading DLL... | dll -u listbot.dll
  set %spr.dll unloaded | spr.l.e DLL unloaded successfully! | spr.l.el | spr.l.e Ended: $fulldate

  set %spr.l.time.end $ctime
  set %spr.l.time.dur $duration($calc(%spr.l.time.end - %spr.l.time.begin))

  aline %spr.l.window.l $chr(9) | aline %spr.l.window.l $str(-=,50) $+ - | aline %spr.l.window.l $chr(9)
  aline %spr.l.window.l End of List - Total: %spr.l.count.f files - $spr.size(%spr.l.count.s)
  aline %spr.l.window.l List-generation took %spr.l.time.dur | aline %spr.l.window.l $chr(9)
  aline %spr.l.window.l Generated by SPR Jukebox $sprvers - http://spr.darkrealms.org
  spr.l.e Total: %spr.l.count.f files - $spr.size(%spr.l.count.s) | spr.l.e List-generation took %spr.l.time.dur | spr.l.el
  spr.l.e Generated by SPR Jukebox $sprvers - http://spr.darkrealms.org

  ; remove current file
  if (%spr.l.filename == $null) {
    set %spr.l.filename $sprdir $+ $replace($replace(%spr.l.nick,\,I),|,I) $+ $chr(91) 
    %spr.l.filename = %spr.l.filename $+ $mid($date,4,2) $+ - $+ $left($date,2) $+ - $+ $right($date,2) $+ $chr(93) $+ -MM.txt
  }
  if ($exists($sprdir(%spr.l.filename))) .remove $sprdir(%spr.l.filename)

  set %spr.l.filename $sprdir $+ $replace($replace(%spr.l.nick,\,I),|,I) $+ $chr(91) 
  %spr.l.filename = %spr.l.filename $+ $mid($date,4,2) $+ - $+ $left($date,2) $+ - $+ $right($date,2) $+ $chr(93) $+ -MM.txt
  set %spr.l.i 1

  ; save list
  while (%spr.l.i <= %spr.l.window.l.c) {
    %spr.l.window.l = @spr.list. $+ %spr.l.i
    filter -wf %spr.l.window.l %spr.l.filename
    ; @spr.list.x processed, close it
    window -c %spr.l.window.l
    inc %spr.l.i
  }

  ; save hashtable
  hsave -ob %spr.l.hash $sprdir([ [ %spr.l.hash ] $+ .hsh ])

  ; update ini-file
  writeini $sprdir(sprcounter.ini) listmake number %spr.l.count.f
  writeini $sprdir(sprcounter.ini) listmake bytes $round($calc(%spr.l.count.s / 1048576),1)
  writeini $sprdir(sprcounter.ini) listmake name $left($nopath(%spr.l.filename),$calc($len($nopath(%spr.l.filename)) - 7))
  writeini $sprdir(sprcounter.ini) listmake done done

  spr.l.el | spr.l.e Listmake complete.
}



ALIAS -l spr.add {
  var %spr.l.ffn = $1-, %spr.l.need = $false

  ; check each extension
  set %spr.l.k 1
  while (($gettok(%spr.l.ext,%spr.l.k,255) != $null) && (%spr.l.need == $false)) {
    if (($gettok(%spr.l.ext,%spr.l.k,255) ISWM %spr.l.ffn) && ($str($chr(32),2) !ISIN %spr.l.ffn)) {
      ; this is a file we need to get!

      ; do NOT go over limit of files-per-window ;-)
      if ($line([ @spr.list $+ [ %spr.l.window.f.c ] ],0) == %spr.l.window.limit) {
        inc %spr.l.window.f.c
        set %spr.l.window.f @spr.list $+ %spr.l.window.f.c
        window -hls %spr.l.window.f
      }
      set %spr.l.need $true | %spr.l.dir = $nofile(%spr.l.ffn)
      if (%spr.l.dirlist) %spr.l.file = %spr.l.ffn
      else %spr.l.file = $nopath(%spr.l.ffn)

      ; process current file
      inc %spr.l.count.f | %spr.l.file.size = $lof(%spr.l.ffn)
      if (%spr.l.file.size != $null) {
        inc %spr.l.count.s %spr.l.file.size | %spr.l.file.size = $spr.size(%spr.l.file.size)

        ; gather mp2/3 / id3 info
        unset %spr.l.id3 | unset %spr.l.fi | unset %spr.l.finfo
        if ((%spr.l.features != s) && ((*.mp2 ISWM %spr.l.ffn) || (*.mp3 ISWM %spr.l.ffn))) {
          %spr.l.finfo = $smp3.getfinfo(%spr.l.ffn)
          %spr.l.fi = $gettok(%spr.l.finfo,1,255) | %spr.l.id3 = $gettok(%spr.l.finfo,2,255)
          if (%spr.l.id3 != $null) %spr.l.id3 = ::ID3:: %spr.l.id3
          if ($chr(255) !ISIN %spr.l.finfo) unset %spr.l.fi %spr.l.id3
        }

        set %spr.l.spaces $calc(%spr.l.window.l.col  - 2 - $len($nopath(%spr.l.file)) - $len(%spr.l.nick))
        aline %spr.l.window.f $replace(%spr.l.file,$chr(32),$chr(255)) $str($chr(160),%spr.l.spaces) ::INFO:: %spr.l.file.size %spr.l.fi %spr.l.id3
        hadd %spr.l.hash $replace($nopath(%spr.l.file),$chr(32),$chr(255)) $replace(%spr.l.dir,$chr(32),$chr(255)) ::INFO:: %spr.l.file.size %spr.l.fi %spr.l.id3

        if (%spr.l.pf.dot // %spr.l.count.f) {
          if ($window(%spr.l.stats) == $null) window -hdfko %spr.l.stats 500 100 450 200
          if (%spr.l.pf.line // %spr.l.count.f) {
            %spr.l.pf = $deltok($line(%spr.l.stats,$line(%spr.l.stats,0)),1,32)
            dline %spr.l.stats $line(%spr.l.stats,0) | spr.l.e %spr.l.pf $+ . ( $+ %spr.l.count.f $+ )
            spr.l.e Processing: $+ $chr(160)
          }
          else {
            %spr.l.pf = $deltok($line(%spr.l.stats,$line(%spr.l.stats,0)),1,32)
            rline %spr.l.stats $line(%spr.l.stats,0) $spr.logo  %spr.l.pf $+ .
          }
        }
      }

    }
    inc %spr.l.k
  }
}



ALIAS spr.sort.done {
  var %spr.l.s.i = 1
  while (%spr.l.s.i <= %spr.l.window.f.c) {
    if ($line([ @spr.list $+ [ %spr.l.s.i ] ],0) != 0) return $false
    inc %spr.l.s.i
  }
  return $true
}


; when one call is sufficient, only one call should be made.
ALIAS -l smp3.getfinfo {
  set %spr.dll attempting load
  var %spr.l.f = $1-, %spr.l.f.info = $dll($sprdir(listbot.dll),SPR_GetMPEGInfo,%spr.l.f), %spr.l.f.r1, %spr.l.f.r2 | %spr.dll = loaded
  if ($gettok(%spr.l.f.info,1,32) != 201) {
    return Error: file currently open, wrong format, double spaces in filename or file not found.
    } else {
    %spr.l.f.info = $deltok(%spr.l.f.info,1-2,32) | %spr.l.f.info = $deltok(%spr.l.f.info,$numtok(%spr.l.f.info,32),32)

    if (b ISIN %spr.l.features) %spr.l.f.r1 = %spr.l.f.r1 $+ $gettok(%spr.l.f.info,1,255) $+ $chr(160)
    if (q ISIN %spr.l.features) %spr.l.f.r1 = %spr.l.f.r1 $+ $gettok(%spr.l.f.info,2,255) $+ $chr(160)
    if (t ISIN %spr.l.features) %spr.l.f.r1 = %spr.l.f.r1 $+ $gettok(%spr.l.f.info,3,255) $+ $chr(160)
    if ($gettok(%spr.l.f.info,4,255) != $null) {
      if (a ISIN %spr.l.features) %spr.l.f.r2 = %spr.l.f.r2 $+ $gettok(%spr.l.f.info,5,255) $+ $chr(160)
      if (i ISIN %spr.l.features) %spr.l.f.r2 = %spr.l.f.r2 $+ $gettok(%spr.l.f.info,6,255) $+ $chr(160)
      if (m ISIN %spr.l.features) %spr.l.f.r2 = %spr.l.f.r2 $+ $gettok(%spr.l.f.info,7,255) $+ $chr(160)
      if (g ISIN %spr.l.features) %spr.l.f.r2 = %spr.l.f.r2 $+ $gettok(%spr.l.f.info,8,255) $+ $chr(160)
      if (c ISIN %spr.l.features) %spr.l.f.r2 = %spr.l.f.r2 $+ $gettok(%spr.l.f.info,9,255) $+ $chr(160)
    }
  }
  if (%spr.l.f.r1 != $null) %spr.l.f.r1 = $left(%spr.l.f.r1,$calc($len(%spr.l.f.r1) - 1))
  if (%spr.l.f.r2 != $null) %spr.l.f.r2 = $left(%spr.l.f.r2,$calc($len(%spr.l.f.r2) - 1))
  var %spr.l.f.r = %spr.l.f.r1 $+ $chr(255) $+ %spr.l.f.r2 | return %spr.l.f.r
}


; only for reference- to be used in spr-inf.mrc
ALIAS -l smp3.finfo {
  var %spr.l.fi = $smp3.getfinfo($1-)
  if ($chr(255) !ISIN %spr.l.fi) return %spr.l.fi | else return $gettok(%spr.l.fi,1,255)
}

; see above
ALIAS -l smp3.id3 {
  var %spr.l.id3 = $smp3.getfinfo($1-)
  if ($chr(255) !ISIN %spr.l.id3) return %spr.l.id3 | else return $gettok(%spr.l.id3,2,255)
}


; we all LOVE the top-download chart :-P don't we? :-)
ALIAS -l update.chart {
  if ($version > 5.51) tokenize 32 $1-
  unset %spr.h.*

  ; stats-window
  set %spr.h.stats @spr.h.stats
  if ($window(%spr.h.stats) != $null) window -c %spr.h.stats
  window -hdfko %spr.h.stats 500 100 450 200
  spr.h.e Gathering information... 

  ; sort-window
  var %spr.h.window @spr.h.sort

  ; tell user each X-lines how many have been processed
  set %spr.h.pf.dot 100 | set %spr.h.pf.line 1000

  ; top-X download chart- get value for 'X'
  var %spr.h.tdlch = $readini($sprdir(sprcounter.ini),listmake,hitnum) | if (%spr.h.tdlch == $null) %spr.h.tdlch = 30

  spr.h.e Checking your hit-chart data...
  if ($exists($sprdir(sprchart.hdt))) .remove $sprdir(sprchart.hdt)
  if ($findfile($sprdir,sprhitdata.hdt,1) == $null) {
    spr.h.e Error: There hasn't been any downloader since the last update! Sorry.
    writeini $sprdir(sprcounter.ini) listmake hitresult Error: There hasn't been any downloader since the last update! Sorry.
    exit
  }
  spr.h.el | spr.h.e Processing: $+ $chr(160)
  var %spr.h.i = 1, %spr.h.l = $read($sprdir(sprhitdata.hdt),%spr.h.i), %spr.h.max, %spr.h.num
  while (%spr.h.l != $null) {
    %spr.h.num = $gettok(%spr.h.l,2,32)
    if (%spr.h.num == $null) {
      if (%spr.h.i == 1) {
        spr.h.e Error: There hasn't been any downloader since the last update! Sorry.
        writeini $sprdir(sprcounter.ini) listmake hitresult Error: There hasn't been any downloader since the last update! Sorry.
        exit
      }
    }
    else {
      if (%spr.h.max == $null) %spr.h.max = %spr.h.num
      if (%spr.h.num > %spr.h.max) %spr.h.max = %spr.h.num | inc %spr.h.i
      %spr.h.l = $read($sprdir(sprhitdata.hdt),%spr.h.i)
    }

    ; do the processbar stuff
    if (%spr.l.pf.dot // %spr.h.i) {
      if ($window(%spr.h.stats) == $null) window -hdfko %spr.h.stats 500 100 450 200
      if (%spr.h.pf.line // %spr.h.i) {
        %spr.h.pf = $deltok($line(%spr.h.stats,$line(%spr.h.stats,0)),1,32)
        dline %spr.h.stats $line(%spr.h.stats,0) | spr.h.e %spr.h.pf $+ . ( $+ %spr.h.i $+ )
        spr.l.e Processing: $+ $chr(160)
      }
      else {
        %spr.h.pf = $deltok($line(%spr.h.stats,$line(%spr.h.stats,0)),1,32)
        rline %spr.h.stats $line(%spr.h.stats,0) $spr.logo  %spr.h.pf $+ .
      }
    }

  }
  %spr.h.pf = $deltok($line(%spr.h.stats,$line(%spr.h.stats,0)),1,32)
  dline %spr.h.stats $line(%spr.h.stats,0) | spr.h.e %spr.h.pf $+ . ( $+ $calc(%spr.h.i - 1) $+ )

  spr.h.el | spr.h.e Processing: $+ $chr(160)
  if ($window(%spr.h.window) != $null) window -c %spr.h.window | window -hsl %spr.h.window
  var %spr.h.len = $len(%spr.h.max), %spr.h.lw | set %spr.h.i 1 | set %spr.h.l $read($sprdir(sprhitdata.hdt),%spr.h.i)
  while (%spr.h.l != $null) {
    %spr.h.num = $gettok(%spr.h.l,2,32)
    %spr.h.lw = $str(0,$calc(%spr.h.len - $len(%spr.h.num))) $+ %spr.h.num $gettok(%spr.h.l,1,32)
    inc %spr.h.i | %spr.h.l = $read($sprdir(sprhitdata.hdt),%spr.h.i)    

    ; do the processbar stuff
    if (%spr.l.pf.dot // %spr.h.i) {
      if ($window(%spr.h.stats) == $null) window -hdfko %spr.h.stats 500 100 450 200
      if (%spr.h.pf.line // %spr.h.i) {
        %spr.h.pf = $deltok($line(%spr.h.stats,$line(%spr.h.stats,0)),1,32)
        dline %spr.h.stats $line(%spr.h.stats,0) | spr.h.e %spr.h.pf $+ . ( $+ %spr.h.i $+ )
        spr.l.e Processing: $+ $chr(160)
      }
      else {
        %spr.h.pf = $deltok($line(%spr.h.stats,$line(%spr.h.stats,0)),1,32)
        rline %spr.h.stats $line(%spr.h.stats,0) $spr.logo  %spr.h.pf $+ .
      }
    }

    aline %spr.h.window %spr.h.lw
  }
  %spr.h.pf = $deltok($line(%spr.h.stats,$line(%spr.h.stats,0)),1,32)
  dline %spr.h.stats $line(%spr.h.stats,0) | spr.h.e %spr.h.pf $+ . ( $+ $calc(%spr.h.i - 1) $+ )

  spr.h.el | spr.h.e Creating your top %spr.h.tdlch download chart...
  set %spr.h.i $line(%spr.h.window,0) | var %spr.h.window.num = %spr.h.i, %spr.h.f
  while ($calc(%spr.h.window.num - %spr.h.tdlch) < %spr.h.i) {
    %spr.h.l = $line(%spr.h.window,%spr.h.i) | %spr.h.f = $replace($gettok(%spr.h.l,2,32),$chr(58),$chr(32))
    write $sprdir(sprchart.hdt) 0,1 $calc(%spr.h.window.num - %spr.h.i + 1) $chr(9) 0,14 $gettok(%spr.h.l,1,32) $chr(9) 0,15 %spr.h.f 15,15 $str($chr(160),50)
    dec %spr.h.i
  }
  var %spr.h.date = $mid($date,4,2) $+ - $+ $left($date,2) $+ - $+ $right($date,2)
  writeini $sprdir(sprcounter.ini) chart date %spr.h.date
  if (($exists($sprdir(sprhitdata.hdt))) && ($1 == -d)) .remove $sprdir(sprhitdata.hdt)
  writeini $sprdir(sprcounter.ini) listmake hitresult Download hitchart has been updated. Please go to Channel/Nick popup -> JukeBox -> Server Ctrl -> Top Download!
  spr.h.el | spr.h.e Done!
  unset %spr.h.* | .timerexit 1 5 exit
}
