// FILENAME:	StarsiegeAssault.cs
// 12:54 AM 12/20/99
// AUTHORS:  	Orogogus
//------------------------------------------------------------------------------

$missionName = "Starsiege Assault";
$nameOfTheGame = "Assault";

exec("multiplayerStdLib.cs");

function setDefaultMissionOptions()
{
	$server::TeamPlay = true;
	$server::AllowDeathmatch = false;
	$server::AllowTeamPlay = true;	

   // what can the client choose for a team
	$server::AllowTeamRed = true;
	$server::AllowTeamBlue = true;
	$server::AllowTeamYellow = false;
	$server::AllowTeamPurple = false;

   // what can the server admin choose for available teams
   $server::disableTeamRed = false;
   $server::disableTeamBlue = false;
   $server::disableTeamYellow = true;
   $server::disableTeamPurple = true;
}


Pilot Mole
{
   id = 28;
   
   skill = 1.0;
   accuracy = 1.0;
   aggressiveness = 0.5;
   activateDist = 3000.0;
   deactivateBuff = 3000.0;
   targetFreq = 4.0;
   trackFreq = 0.1;
   fireFreq = 0.1;
   LOSFreq = 0.4;
   name = "Foebot";
};

$boxes = 2;
$maxListing = 10;

for (%i=0; %i<=%boxes; %i++)
{
	$boxOwner[%i] = 0;
}

//============

for ( %i=0; %i<$maxListing; %i++ )
{
	$bestKills[%i] = 0;
	$bestKillsVehicle[%i] = "";
	$bestPlayer[%i] = "";
}

$maxPersonalBest = 0;
$personalBest[0] = 0;
$personalBestName[0] = "Captain Placeholder";



//============


function onMissionStart()
{
	$startTime = getCurrentTime();
	marsSounds();
	exec("multiplayer\\SSAssaultScores.cs");
	adjustImports();
	exec("ScanComponents.cs");
}


function onMissionLoad(){
   cdAudioCycle("Purge", "Terror", "Watching"); 
}


function setDefaultMissionItems() 
{
	exec("defaultVehicles");
	allowComponent("all", true);
	allowWeapon("all", true);
}


//=============


function BeamHimUp::trigger::onEnter(%this, %vehicleId)
{

	%player = playerManager::vehicleIdToPlayerNum(%vehicleId);

	%check = 0;

	for ( %i=0; %i<$boxes; %i++ )
	{
		if($boxOwner[%i] == 0)
		{
			%check = 1;
		}
	}

	if(%check == 1)
	{
		%Scotty = randomInt(0, ($boxes-1));

		while($boxOwner[%Scotty] != 0)
		{
			%Scotty = randomInt(0, ($boxes-1));
		}


		if(%Scotty == 0)
		{
			%x = 205;
			%y = 695;
			%z = 105;
			$boxOwner[0] = %player;
		}

		else if(%Scotty == 1)
		{
			%x = 454;
			%y = -192;
			%z = 105;
			$boxOwner[1] = %player;
		}

		setPosition( getObjectId(%vehicleId), %x, %y, %z );

		$maxTargets[%Scotty] = 1;
		$waveNumber[%Scotty] = 1;

		%player.home = %Scotty;
		%player.kills = 0;
		setMoles(%player, %Scotty);
	}
	else
	{
		%txt1 = "Sorry, all boxes full.  Please try again later.";
		say(%player, 0, %txt1);
	}
}



function setMoles(%player, %box)
{

	%playerVeh = playerManager::playerNumToVehicleId(%player);

	say(%player, 1, "Targets in wave " @$waveNumber[%box] @":");


	for ( %i=0; %i<($maxTargets[%box]); %i++ )
	{
	   %spawnNum = RandomInt(1,31);
     if(%spawnNum == 1) %targType = 1;
     if(%spawnNum == 2)
     {
        %switcher = RandomInt(0, 1);
        if(%switcher == 0) %targType = 2;
        if(%switcher == 1) %targType = 101;
     }
     if(%spawnNum == 3) %targType = 3;
     if(%spawnNum == 4) %targType = 4;
     if(%spawnNum == 5) %targType = 5;
     if(%spawnNum == 6) %targType = 6;
     if(%spawnNum == 7) %targType = 7;
     if(%spawnNum == 8) %targType = 10;
     if(%spawnNum == 9) %targType = 11;
     if(%spawnNum == 10) %targType = 12;
     if(%spawnNum == 11) %targType = 13;
     if(%spawnNum == 12) %targType = 14;
     if(%spawnNum == 13) %targType = 15;
     if(%spawnNum == 14) %targType = 16;
     if(%spawnNum == 15) %targType = 20;
     if(%spawnNum == 16)
     {
        %switcher = RandomInt(0, 1);
        if(%switcher == 0) %targType = 21;
        if(%switcher == 1) %targType = 102;
     }
     if(%spawnNum == 17) %targType = 22;
     if(%spawnNum == 18) %targType = 23;
     if(%spawnNum == 19) %targType = 24;
     if(%spawnNum == 20) %targType = 25;
     if(%spawnNum == 21)
     {
        %switcher = RandomInt(0, 1);
        if(%switcher == 0) %targType = 26;
        if(%switcher == 1) %targType = 100;
     }
     if(%spawnNum == 22) %targType = 27;
     if(%spawnNum == 23) %targType = 28;
     if(%spawnNum == 24)
     {
        %switcher = RandomInt(0, 1);
        if(%switcher == 0) %targType = 30;
        if(%switcher == 1) %targType = 103;
     }
     if(%spawnNum == 25) %targType = 31;
     if(%spawnNum == 26) %targType = 32;
     if(%spawnNum == 27) %targType = 33;
     if(%spawnNum == 28) %targType = 35;
     if(%spawnNum == 29) %targType = 36;
     if(%spawnNum == 30) %targType = 37;
     if(%spawnNum == 31) %targType = 41;

		// get appropriate type Tank or Herc
		%type = Herc;
		if ( %targType>5  && %targType<= 8 )   %type = Tank;
		if ( %targType>14 && %targType<= 17 )  %type = Tank;
		if ( %targType>24 && %targType<= 26 )  %type = Tank;
		if ( %targType>30 && %targType<= 32 )  %type = Tank;
		if ( %targType == 41 )  %type = Tank;

    if(%targType < 100) %herc = NewObject("Foebot", %type, %targType); 
    else if(%targType == 100) %herc = cloneVehicle("MissionGroup/Embryos/Embryo1");
    else if(%targType == 101) %herc = cloneVehicle("MissionGroup/Embryos/Embryo2");
    else if(%targType == 102) %herc = cloneVehicle("MissionGroup/Embryos/Embryo3");
    else if(%targType == 103) %herc = cloneVehicle("MissionGroup/Embryos/Embryo4");


		setTeam( %herc, *IDSTR_TEAM_PURPLE );
		say(%player, 1, getVehicleName(%herc));
		setPilotId(%herc,28);
		putTarget( %herc, %box);
    order(%herc, Shutdown, false);
		$CountBox[%box]++;
		schedule("order( " @ %herc @ ", attack, " @ %playerVeh @" );", 5);
		%herc.home = %box;
		%player.AI[%i] = %herc;
	}
}




function putTarget(%herc, %box)
{
	if (%box == 0)
	{
		randomTransport(%herc, -125, 335, 530, 1055);
	}


	else if (%box == 1)
	{
		randomTransport(%herc, 125, -535, 775, 165);
	}

}


//================



function vehicle::onAdd(%vehicle)
{
	%player = playerManager::vehicleIdToPlayerNum(%vehicle);
    if(%player == 0) return;
	%player.home = 100;
	%player.name = getHUDName(%vehicle);
	%player.vehicle = getVehicleName(%vehicle);
	setVehicleRadarVisible( %vehicle, False );
}


function vehicle::onDestroyed( %victimVeh, %destroyerVeh )
{

	if( getTeam( %victimVeh ) == *IDSTR_TEAM_PURPLE )
	{
		%box = %victimVeh.home;
		%player = $boxOwner[%box];
    schedule("deleteobject(" @ %victimVeh @ ");", 5);

		%player.kills++;

		if(%player.kills == 1) say(%player, 0, %player.kills@" target destroyed!");
		else say(%player, 0, %player.kills@" targets destroyed!");

		$CountBox[%box]--;

		if($CountBox[%box]==0)
		{
			say(%player, 0, "Wave "@ $waveNumber[%box]@" completed!");
			$waveNumber[%box]++;
			$maxTargets[%box]++;
			setMoles(%player, %box);
		}
	}


	else
	{
		%player = playerManager::vehicleIdToPlayerNum(%victimVeh);

		%box = %player.home;

		if (%box != 100)
		{
      if(%player.kills == 1) say(%player, 0, "Final tally: " @ %player.kills@" target destroyed!");
      else say(%player, 0, "Final tally: " @ %player.kills@" targets destroyed!");


			for( %i=0; %i<($maxPersonalBest + 1); %i++ )
			{
				if($personalBestName[%i] == %player.name)
				{
					$check = 1;

					if(%player.kills > $personalBest[%i])
					{
						say(%player, 0, "A new personal best!!");
						$personalBest[%i] = %player.kills;
					}
				}
			}

			if($check == 0)
			{
				$maxPersonalBest++;
				say(%player, 0, "\(First completion for " @ %player.name@ "\)");
				$personalBestName[$maxPersonalBest] = %player.name;
				$personalBest[$maxPersonalBest] = %player.kills;
			}

			//=====

			%winner = 0;
			%highNumber = 10;

			for ( %i=($maxListing-1); %i>-1; %i-- )
			{
				if( %player.kills > $bestKills[%i] )
				{
					%winner = 1;
					%highNumber = %i;
				}
			}


			if(%winner == 1)
			{

				for ( %j=($maxListing-1); %j>(%highNumber-1); %j-- )
				{
					$bestKills[(%j+1)] = $bestKills[%j];
					$bestKillsVehicle[(%j+1)] = $bestKillsVehicle[%j];
					$bestPlayer[(%j+1)] = $bestPlayer[(%j)];
				}

				$bestKills[%highNumber] = %player.kills;
				$bestKillsVehicle[%highNumber] = %player.vehicle;
				$bestPlayer[%highNumber] = %player.name;

				%ordinal = getOrdinal(%highNumber);

				say("everybody", 1, %player.name @" has scored "@%ordinal @" place!  \(" @%player.kills@" kills\)");
				saveScores();
			}


			//=====


			for ( %i=0; %i<$maxTargets[%box]; %i++ )
			{
				if ( %player.AI[%i] )
				deleteObject( %player.AI[%i] );
			}

			$Countbox[%box] = 0;
			$boxOwner[%box] = 0;
			%player.home = 100;
		}
	}
}






function player::onRemove( %player )
{

	%box = %player.home;

	for ( %i=0; %i<$maxTargets[%box]; %i++ )
	{
		if ( %player.AI[%i] )
		deleteObject( %player.AI[%i] );
	}

	$Countbox[%box] = 0;
	$boxOwner[%box] = 0;
}
	


//==========================


function Scoreboard1::trigger::onEnter(%this, %vehicleId)
{
	%player = playerManager::vehicleIdToPlayerNum(%vehicleId);
	%player.name = getHUDName(%vehicleId);

	%check = 0;

	for( %i=0; %i<($maxPersonalBest + 1); %i++ )
	{
		if($personalBestName[%i] == %player.name)
		{
			%check = 1;
			say(%player, 0, "Welcome back, " @%player.name @"!");
			if($personalBest[%i] == 1) say(%player, 0, "Your personal best is " @$personalBest[%i] @" kill.");
      else say(%player, 0, "Your personal best is " @$personalBest[%i] @" kills.");
		}
	}

	if(%check == 0)
	{
		say(%player, 0, "Hello, " @%player.name @"!");
		say(%player, 0, "You have not registered any attempts in this game yet.");
	}

	%now = getCurrentTime();
	%timeUp = timeDifference( %now, $startTime);
	say(%player, 0, "The server has been up for " @%timeUp );

}


function Scoreboard2::trigger::onEnter(%this, %vehicleId)
{
	%player = playerManager::vehicleIdToPlayerNum(%vehicleId);
	%player.name = getHUDName(%vehicleId);

	if($bestKills[0] == 0)
	{
		say(%player, 0, "No best scores yet.");
	}
	
	else
	{
		say(%player, 0, "Best scores:");

		for (%i=($maxListing-1); %i>-1; %i--)
		{
			if($bestKills[%i] != 0)
			{
				%ordinal = getOrdinal(%i);
        if($bestKills[%i] == 1) say(%player, 0, "- "@%ordinal @" place by " @$bestPlayer[%i] @ " \("@ $bestKillsVehicle[%i] @ "\: " @$bestKills[%i] @ " kill\)");
        else say(%player, 0, "- "@%ordinal @" place by " @$bestPlayer[%i] @ " \("@ $bestKillsVehicle[%i] @ "\: " @$bestKills[%i] @ " kills\)");
			}
		}
	}

}


function saveScores()
{
	export("$best*", "multiplayer\\SSAssaultScores.cs", False);
}

//===================

function getOrdinal(%highPlace)
{
	if(%highplace==0)
	{
		return("1st");
	}
	else if(%highplace==1)
	{
		return("2nd");
	}
	else if(%highplace==2)
	{
		return("3rd");
	}
	else if(%highplace==3)
	{
		return("4th");
	}
	else if(%highplace==4)
	{
		return("5th");
	}
	else if(%highplace==5)
	{
		return("6th");
	}
	else if(%highplace==6)
	{
		return("7th");
	}
	else if(%highplace==7)
	{
		return("8th");
	}
	else if(%highplace==8)
	{
		return("9th");
	}
	else if(%highplace==9)
	{
		return("10th");
	}
	else
	{
		return(%highplace + 1);
	}
}


//=======================


function AdjustImports()
{
	$bestKills[0] = $bestKills0;
	$bestKills[1] = $bestKills1;
	$bestKills[2] = $bestKills2;
	$bestKills[3] = $bestKills3;
	$bestKills[4] = $bestKills4;
	$bestKills[5] = $bestKills5;
	$bestKills[6] = $bestKills6;
	$bestKills[7] = $bestKills7;
	$bestKills[8] = $bestKills8;
	$bestKills[9] = $bestKills9;
	$bestKills[10] = $bestKills10;
	$bestKillsVehicle[0] = $bestKillsVehicle0;
	$bestKillsVehicle[1] = $bestKillsVehicle1;
	$bestKillsVehicle[2] = $bestKillsVehicle2;
	$bestKillsVehicle[3] = $bestKillsVehicle3;
	$bestKillsVehicle[4] = $bestKillsVehicle4;
	$bestKillsVehicle[5] = $bestKillsVehicle5;
	$bestKillsVehicle[6] = $bestKillsVehicle6;
	$bestKillsVehicle[7] = $bestKillsVehicle7;
	$bestKillsVehicle[8] = $bestKillsVehicle8;
	$bestKillsVehicle[9] = $bestKillsVehicle9;
	$bestKillsVehicle[10] = $bestKillsVehicle10;
	$bestPlayer[0] = $bestPlayer0;
	$bestPlayer[1] = $bestPlayer1;
	$bestPlayer[2] = $bestPlayer2;
	$bestPlayer[3] = $bestPlayer3;
	$bestPlayer[4] = $bestPlayer4;
	$bestPlayer[5] = $bestPlayer5;
	$bestPlayer[6] = $bestPlayer6;
	$bestPlayer[7] = $bestPlayer7;
	$bestPlayer[8] = $bestPlayer8;
	$bestPlayer[9] = $bestPlayer9;
	$bestPlayer[10] = $bestPlayer10;
}



//=========================


function Cleaners()
{
	for(%i=8000;%i<9000;%i++)
	{
		if(getObjectName(%i) == "Foebot")
		{
			deleteobject(%i);
		}
	}
}


//==========================

function player::OnAdd(%player)
{
  %player.name = getName(%player);
  %player.location = 0;
  %player.startTime = getCurrentTime();

  %nowDate = getDate();
  %nowTime = getTime();
  %outputString =  %nowDate @ ", " @ %nowTime @ " -- " @ %player.name @ " joined the game";

  fileWrite("multiplayer\\serverlog.txt", append, %outputString);

  %player.IP = getConnection(%player);
}


function player::OnRemove(%player)
{
  %player.name = getName(%player);
  %nowDate = getDate();
  %nowTime = getTime();
  %timeEnd = getCurrentTime();
  %timeIn = timeDifference( %timeEnd, %player.startTime);
  %outputString =  %nowDate @ ", " @ %nowTime @ " -- " @ %player.name @ " left the game (" @ %timeIn @ ") ";

  fileWrite("multiplayer\\serverlog.txt", append, %outputString);
}

//=======================