// FILENAME:	Point_of_Contention.cs
//
// AUTHOR:  	Buckaroo Banzai 
//             (Based on C&H by Orogogus, Kore, and Buckaroo Banzai)
// 
//------------------------------------------------------------------------------

$missionName = "Point_of_Contention";
$nameOfTheGame = "Team Deathmatch";

exec("multiplayerStdLib.cs");

$purpleBonus = 0;
$yellowBonus = 0;
$OmegaOwner = 0; 

$killPoints 	= 3;
$deathPoints 	= 2;
$basePoints 	= 5;
$ZenWaitTime 	= 40;
$ZenHealRate    = 400; 
$ZenAmmoRate    = 8;   

function setRules()
{
      %rules = "<F2>GAME TYPE: \n<F0>Team Deathmatch\n\n"   @        
               "<tIDMULT_TDM_MAPNAME>"    @ 
               $missionName               @
               "\n\n<F2>RULES/OBJECTIVES:\n" @
               "<F0>1) Locate and destroy enemy vehicles.\n\n" @
               "2) Capture and defend the base.\n\n" @
               "<tIDMULT_TDM_SCORING_1>"  @
               "<tIDMULT_TDM_SCORING_2>"  @
               $killPoints                @
               "<tIDMULT_TDM_SCORING_3>"  @
               "<tIDMULT_TDM_SCORING_4>"  @
               $deathPoints               @
               "<tIDMULT_TDM_SCORING_5>"  @
               "<F0>Capturing a base is worth <F3>5<F0> points to the player who seizes it.\n\n" @
               "<F0>Holding a base is worth <F3>10<F0> points to your team every 120 seconds.\n\n" @
               "<F0>Your team will also gain <F3>1<F0> point for kills made by any of your base's turrets.\n\n" @
               "<tIDMULT_TDM_SCORING_6>"  @
               "<tIDMULT_STD_ITEMS>"      @
               "<tIDMULT_STD_ZEN_1>"      @
               $ZenWaitTime               @
               "<F0> seconds. You have to power down on the pad for 5 seconds to capture the base.\n\n" @
               "<F5>NOTE: While healing or reloading, your vehicle is vulnerable to "@
               "enemy fire. It is necessary to pad kill in this scenario. \n " ;

   setGameInfo(%rules);      
}


// setup the rules
// this has to be called after the definition of setRules
setRules();
                
function player::onAdd(%this)
{
   player::onAddLog(%this);
	
	if($server::TeamPlay == true)
	{
      say(%this,0, "<F1>Welcome to TDM! Check the Game Info tab for rules and scoring information.");	      
   }
	else
	{
      say(%this,0, *IDMULT_DM_WELCOME);
   }
}   

function vehicle::onAdd(%vehicleId)
{
	%player = playerManager::vehicleIdToPlayerNum(%vehicleId);

	%color = getTeam(%vehicleId);
	if(%color == *IDSTR_TEAM_PURPLE) %player.color = "PURPLE";
	if(%color == *IDSTR_TEAM_YELLOW) %player.color = "YELLOW";

	%player.name = getHUDName(%vehicleId);
	%player.seizures = 0;
}

//--------------------------------------
// Death Messages

function vehicle::OnDestroyed( %victim, %destroyer )
{
	%victimNum = playerManager::vehicleIdToPlayerNum( %victim );

	%destroyerNum = playerManager::vehicleIdToPlayerNum( %destroyer );

	%message = getFancyDeathMessage(getHUDName(%victim), getHUDName(%destroyer));
	if(%message != "") say( 0, 0, %message);

	if(getHUDName(%destroyer) == "Yellow Turret") $yellowBonus = $yellowBonus + 1;
	if(getHUDName(%destroyer) == "Purple Turret") $purpleBonus = $purpleBonus + 1;

  if($server::TeamPlay == true)
  {
			if
			(
				(getTeam(%destroyed) == getTeam(%destroyer)) &&
         (%destroyed != %destroyer)
      )
      {
         antiTeamKill(%destroyer);
      }
   }   
}


//------------------------------------------------------------------------------
// scoreboard 

function getPlayerScore(%a)
{
   return((getKills(%a) * $killPoints) - (getDeaths(%a) * $deathPoints) + (%a.seizures * $basePoints));
}

function getSeizures(%a)
{
	return(%a.seizures);
}

function getTeamScore(%team)
{
	%team = getTeamNameFromTeamId(%team);
	if(%team == *IDSTR_TEAM_PURPLE) 
	{
		%points = $purpleBonus + (getTeamKills(%team) * $killPoints) - (getTeamDeaths(%team) * $deathPoints);
		return(%points);
	}
	if(%team == *IDSTR_TEAM_YELLOW) 
	{
		%points = $yellowBonus + (getTeamKills(%team) * $killPoints) - (getTeamDeaths(%team) * $deathPoints);
		return(%points);
	}

	return 0;
} 



function getBases(%team)
{
	if(%team == *IDSTR_TEAM_PURPLE) 
	{
		return(%points);
	}
	if(%team == *IDSTR_TEAM_YELLOW) 
	{
		return(%points);
	}

	return 0;
} 

function initScoreBoard()
{
   deleteVariables("$ScoreBoard::PlayerColumn*");
   deleteVariables("$ScoreBoard::TeamColumn*");

	   // Player ScoreBoard column headings
	   $ScoreBoard::PlayerColumnHeader1 = *IDMULT_SCORE_TEAM;
	   $ScoreBoard::PlayerColumnHeader2 = *IDMULT_SCORE_SQUAD;
	   $ScoreBoard::PlayerColumnHeader3 = *IDMULT_SCORE_SCORE;
	   $ScoreBoard::PlayerColumnHeader4 = *IDMULT_SCORE_KILLS;
	   $ScoreBoard::PlayerColumnHeader5 = *IDMULT_SCORE_DEATHS;
	   $ScoreBoard::PlayerColumnHeader6 = "Base captures";

	   // Player ScoreBoard column functions
	   $ScoreBoard::PlayerColumnFunction1 = "getTeam";
	   $ScoreBoard::PlayerColumnFunction2 = "getSquad";
	   $ScoreBoard::PlayerColumnFunction3 = "getPlayerScore";
	   $ScoreBoard::PlayerColumnFunction4 = "getKills";
	   $ScoreBoard::PlayerColumnFunction5 = "getDeaths";
	   $ScoreBoard::PlayerColumnFunction6 = "getSeizures";

   // Team ScoreBoard column headings
   $ScoreBoard::TeamColumnHeader1 = *IDMULT_SCORE_SCORE;
   $ScoreBoard::TeamColumnHeader2 = *IDMULT_SCORE_PLAYERS;
   $ScoreBoard::TeamColumnHeader3 = *IDMULT_SCORE_KILLS;
   $ScoreBoard::TeamColumnHeader4 = *IDMULT_SCORE_DEATHS;

   // Team ScoreBoard column functions
   $ScoreBoard::TeamColumnFunction1 = "getTeamScore";
   $ScoreBoard::TeamColumnFunction2 = "getNumberOfPlayersOnTeam";
   $ScoreBoard::TeamColumnFunction3 = "getTeamKills";
   $ScoreBoard::TeamColumnFunction4 = "getTeamDeaths";

   // tell server to process all the scoreboard definitions defined above
   serverInitScoreBoard();
}

function setDefaultMissionOptions()
{
	$server::TeamPlay = true;
	$server::AllowDeathmatch = false;
	$server::AllowTeamPlay = true;	

	$server::AllowTeamRed = false;
	$server::AllowTeamBlue = false;
	$server::AllowTeamYELLOW = true;
	$server::AllowTeamPurple = true;

	// what can the server admin choose for available teams
	$server::disableTeamRed = true;
	$server::disableTeamBlue = true;
	$server::disableTeamYellow = false;
	$server::disableTeamPurple = false;
}

function onMissionStart()
{
	initGlobalVars();
  
	$lastVehicleOnZenOmega	= "";
	$secondsToGainOmega 	= 0;
	
	venusSounds();
}

// move the map
$server::HudMapViewOffsetX = -1151;
$server::HudMapViewOffsetY = 381;

function onMissionLoad(){
   cdAudioCycle("Purge", "Cyberntx", "Yougot"); 

}


// ZenOmega Pad Functionality
//------------------------------------------------------------------------------
function ZenOmega::trigger::onEnter(%this, %object)
{
   	Zen::onEnter(%this, %object, *IDMULT_CHAT_ALLPAD, true, true);  
}
function ZenOmega::trigger::onContact(%this, %object)
{
   	Zen::work(%this, %object, $ZenHealRate, $ZenAmmoRate, $zenWaitTime, true);
	if(isShutDown(%object)){
		if(%object != $lastVehicleOnZenOmega){
			$lastVehicleOnZenOmega = %object;
			$secondsToGainOmega = 1;
		}
		else{
			$secondsToGainOmega = $secondsToGainOmega + 1;
		}
		if($secondsToGainOmega >= 39)
		{
			giveOmegaTurretsToThisGuy(%object);
		}
	}
}

// Turret Code
// -----------------------------------------------------------------------------------

function giveOmegaTurretsToThisGuy(%vehicleId)
{
	%player = playerManager::vehicleIdToPlayerNum(%vehicleId);

	%team = getTeam(%vehicleId);
	setTeam("MissionGroup\\Bases\\T1", %team);
	setTeam("MissionGroup\\Bases\\T2", %team);
	setTeam("MissionGroup\\Bases\\T3", %team);
	setTeam("MissionGroup\\Bases\\T4", %team);
	setTeam("MissionGroup\\Bases\\NavZenOmega", %team);
	order("MissionGroup\\Bases", Shutdown, false);	

	%color = %player.color; 
	if(%color == $OmegaOwner) return; 
	$OmegaOwner = %color; 
	schedule("OmegaScore("@%color@");", 120);

	say("everybody", 0, %player.name @ " seizes Omega Base for " @ %team @ "!");
	%player.seizures++;
}

function OmegaScore(%origColor)
{
	if(%origColor != $OmegaOwner) return;
	if(%origColor == "PURPLE")
	{
		$purpleBonus = $purpleBonus + 10; 
		say("everybody", 0, "Purple Team receives 10 points for holding Omega Base!");
	}
	if(%origColor == "YELLOW")
	{
		$yellowBonus = $yellowBonus + 10; 
		say("everybody", 0, "Yellow Team receives 10 points for holding Omega Base!");
	}
	else return;

	schedule("OmegaScore("@%origColor@");", 120);
}
