// FILENAME:	DM_Heavens_Peak.cs
//
// AUTHORS:  	Chupie Doll & Youth in Asia
//------------------------------------------------------------------------------

$missionName = "DM_Down_Under";

exec("multiplayerStdLib.cs");
exec("DMstdLib.cs");
// move the map
$server::HudMapViewOffsetX =  150;
$server::HudMapViewOffsetY =  450;

function setDefaultMissionOptions()
{
	$server::TeamPlay        =  false;
	$server::AllowDeathmatch =  true;
	$server::AllowTeamPlay   =  false;	
	
	$server::AllowTeamRed    =  true;
	$server::AllowTeamBlue   = false;
	$server::AllowTeamYellow =  true;
	$server::AllowTeamPurple =  true;
        
        $server::disableTeamRed    = false;
        $server::disableTeamBlue   =  true;
        $server::disableTeamYellow = false;
        $server::disableTeamPurple =  true;
}

function onMissionLoad(){
   cdAudioCycle("Purge", "Newtech", "SS4", "SS3"); 
   // custom rules for this mission ( teleporter )
    %rules = "<tIDMULT_TDM_GAMETYPE>"   @        
            "<tIDMULT_TDM_MAPNAME>"    @ 
            $missionName               @
            "<tIDMULT_TDM_OBJECTIVES>" @
            "<tIDMULT_TDM_SCORING_1>"  @
            "<tIDMULT_TDM_SCORING_2>"  @
            $killPoints                @
            "<tIDMULT_TDM_SCORING_3>"  @
            "<tIDMULT_TDM_SCORING_4>"  @
            $deathPoints               @
            "<tIDMULT_TDM_SCORING_5>"  @
            "<tIDMULT_TDM_SCORING_6>"  @
            "<tIDMULT_STD_ITEMS>"      @
            "<tIDMULT_STD_TELEPORTER>" @
           

   setGameInfo(%rules);
}


// Healing Pad Functionality
function onMissionStart()
{
	$healRate = 1000;   
	$ammoRate = 100 ;
   	$padWaitTime = 10;
  	$zenWaitTime = 10;
	
	temperateSounds();
}

// Healing Pad Functionality
//------------------------------------------------------------------------------
function ZenHeal::trigger::onEnter(%this, %object)
{
   	Zen::onEnter(%this, %object, *IDMULT_CHAT_HEALPAD, true, true);  
}
function ZenHeal::trigger::onContact(%this, %object)
{
   	Zen::work(%this, %object, $healRate, 0, $padWaitTime, true); 
}

// Ammo Pad Functionality
//------------------------------------------------------------------------------
function ZenAmmo::trigger::onEnter(%this, %object)
{
   	Zen::onEnter(%this, %object, *IDMULT_CHAT_AMMOPAD, true, true);  
}

function ZenAmmo::trigger::onContact(%this, %object)
{
   	Zen::work(%this, %object, 0, $ammoRate, $padWaitTime, true); 
}

// ZenAll Pad Functionality
//------------------------------------------------------------------------------
function ZenAll::trigger::onEnter(%this, %object)
{
   	Zen::onEnter(%this, %object, *IDMULT_CHAT_ALLPAD, true, true);  
}
function ZenAll::trigger::onContact(%this, %object)
{
   	Zen::work(%this, %object, $healRate, $ammoRate, $padWaitTime, true); 
}

// Transporter Functionality
// --------------------------------------------------------------------------
function deathmatchTransport(%this, %vehicleId){
	%teamName = getTeam(%vehicleId);
   
	%huh = randomInt(1, 5);
	if(%huh == 1){
		transportToYellowBase(%vehicleId);
	}
	else if(%huh == 2){
		transportToBlueBase(%vehicleId);
	}
	else if(%huh == 3){
		transportToRedBase(%vehicleId);
	}
	else if(%huh == 4){
		transportToPurpleBase(%vehicleId);
	}
	else{
		transportToMountain(%vehicleId);
	}
}
function YellowTransporter::trigger::onEnter(%this, %vehicleId){
	if($server::TeamPlay == false){
		deathmatchTransport(%this, %vehicleId);
		return;
	}

	%teamName = getTeam(%vehicleId);
   
   	if(%teamName == *IDSTR_TEAM_YELLOW){
		%huh = randomInt(1, 4);
		if(%huh == 1){
			transportToBlueBase(%vehicleId);
		}
		else if(%huh == 2){
			transportToRedBase(%vehicleId);
		}
		else if(%huh == 3){
			transportToPurpleBase(%vehicleId);
		}
		else{
			transportToMountain(%vehicleId);
		}
	}
	else{
		transportToHomeBase(%vehicleId);
	}
}
function BlueTransporter::trigger::onEnter(%this, %vehicleId){
	if($server::TeamPlay == false){
		deathmatchTransport(%this, %vehicleId);
		return;
	}

	%teamName = getTeam(%vehicleId);
   
   	if(%teamName == *IDSTR_TEAM_BLUE){
		%huh = randomInt(1, 4);
		if(%huh == 1){
			transportToYellowBase(%vehicleId);
		}
		else if(%huh == 2){
			transportToRedBase(%vehicleId);
		}
		else if(%huh == 3){
			transportToPurpleBase(%vehicleId);
		}
		else{
			transportToMountain(%vehicleId);
		}
	}
	else{
		transportToHomeBase(%vehicleId);
	}
}
function RedTransporter::trigger::onEnter(%this, %vehicleId){
	if($server::TeamPlay == false){
		deathmatchTransport(%this, %vehicleId);
		return;
	}
	%teamName = getTeam(%vehicleId);
   
   	if(%teamName == *IDSTR_TEAM_RED){
		%huh = randomInt(1, 4);
		if(%huh == 1){
			transportToBlueBase(%vehicleId);
		}
		else if(%huh == 2){
			transportToYellowBase(%vehicleId);
		}
		else if(%huh == 3){
			transportToPurpleBase(%vehicleId);
		}
		else{
			transportToMountain(%vehicleId);
		}
	}
	else{
		transportToHomeBase(%vehicleId);
	}
}
function PurpleTransporter::trigger::onEnter(%this, %vehicleId){
	if($server::TeamPlay == false){
		deathmatchTransport(%this, %vehicleId);
		return;
	}
	%teamName = getTeam(%vehicleId);

   	if(%teamName == *IDSTR_TEAM_PURPLE){
		%huh = randomInt(1, 4);
		if(%huh == 1){
			transportToBlueBase(%vehicleId);
		}
		else if(%huh == 2){
			transportToRedBase(%vehicleId);
		}
		else if(%huh == 3){
			transportToYellowBase(%vehicleId);
		}
		else{
			transportToMountain(%vehicleId);
		}
	}
	else{
		transportToHomeBase(%vehicleId);
	}
}

function transportToBlueBase(%vehicleId)
{
	echo("Transporting to Blue Base");
	randomTransport(%vehicleId, 582);
}
function transportToYellowBase(%vehicleId)
{
	echo("Transporting to Yellow Base");
	randomTransport(%vehicleId, 582);
}
function transportToRedBase(%vehicleId)
{
	echo("Transporting to Red Base");
	randomTransport(%vehicleId, -243);
}
function transportToPurpleBase(%vehicleId)
{
	echo("Transporting to Purple Base");
    randomTransport(%vehicleId, 582);
}
function transportToMountain(%vehicleId)
{
      randomTransport(%vehicleId, -243);
}

function transportToHomeBase(%vehicleId)
{
	// What colour is this person?
   %teamName = getTeam(%vehicleId);
   
	// Call the appropriate transport function (above) and get them home
   if(%teamName == *IDSTR_TEAM_YELLOW)
   {
      transportToYellowBase(%vehicleId);
   }
   else if(%teamName == *IDSTR_TEAM_RED)
   {
      transportToRedBase(%vehicleId);
   }
   else if(%teamName == *IDSTR_TEAM_BLUE)
   {
      transportToBlueBase(%vehicleId);
   }
   else
   {
      transportToPurpleBase(%vehicleId);
   }   
}