// FILENAME:	DM_Heavens_Peak.cs
//
// AUTHORS:  	Chupie Doll & Youth in Asia
//------------------------------------------------------------------------------

$missionName = "DM_Crater";

exec("multiplayerStdLib.cs");
exec("DMstdLib.cs");
// move the map
$server::HudMapViewOffsetX =  150;
$server::HudMapViewOffsetY =  450;

function setDefaultMissionOptions()
{
	$server::TeamPlay        =  false;
	$server::AllowDeathmatch = true;
	$server::AllowTeamPlay   =  true;	
	
	$server::AllowTeamRed    =  true;
	$server::AllowTeamBlue   = false;
	$server::AllowTeamYellow =  true;
	$server::AllowTeamPurple = false;
        
        $server::disableTeamRed    = false;
        $server::disableTeamBlue   =  true;
        $server::disableTeamYellow = false;
        $server::disableTeamPurple =  true;
}

function onMissionLoad(){
   cdAudioCycle("Purge", "Newtech", "SS4", "SS3"); 
   // custom rules for this mission ( teleporter )
    %rules = "<tIDMULT_TDM_GAMETYPE>"   @        
            "<tIDMULT_TDM_MAPNAME>"    @ 
            $missionName               @
            "<tIDMULT_TDM_OBJECTIVES>" @
            "<tIDMULT_TDM_SCORING_1>"  @
            "<tIDMULT_TDM_SCORING_2>"  @
            $killPoints                @
            "<tIDMULT_TDM_SCORING_3>"  @
            "<tIDMULT_TDM_SCORING_4>"  @
            $deathPoints               @
            "<tIDMULT_TDM_SCORING_5>"  @
            "<tIDMULT_TDM_SCORING_6>"  @
            "<tIDMULT_STD_ITEMS>"      @
            "<tIDMULT_STD_TELEPORTER>" @
           

   setGameInfo(%rules);
}


// Healing Pad Functionality
function onMissionStart()
{
	$healRate = 1000;   
	$ammoRate = 100 ;
   	$padWaitTime = 10;
  	$zenWaitTime = 10;
	
	temperateSounds();
}

// Healing Pad Functionality
//------------------------------------------------------------------------------
function ZenHeal::trigger::onEnter(%this, %object)
{
   	Zen::onEnter(%this, %object, *IDMULT_CHAT_HEALPAD, true, true);  
}
function ZenHeal::trigger::onContact(%this, %object)
{
   	Zen::work(%this, %object, $healRate, 0, $padWaitTime, true); 
}

// Ammo Pad Functionality
//------------------------------------------------------------------------------
function ZenAmmo::trigger::onEnter(%this, %object)
{
   	Zen::onEnter(%this, %object, *IDMULT_CHAT_AMMOPAD, true, true);  
}

function ZenAmmo::trigger::onContact(%this, %object)
{
   	Zen::work(%this, %object, 0, $ammoRate, $padWaitTime, true); 
}

// ZenAll Pad Functionality
//------------------------------------------------------------------------------
function ZenAll::trigger::onEnter(%this, %object)
{
   	Zen::onEnter(%this, %object, *IDMULT_CHAT_ALLPAD, true, true);  
}
function ZenAll::trigger::onContact(%this, %object)
{
   	Zen::work(%this, %object, $healRate, $ammoRate, $padWaitTime, true); 
}

