// FILENAME:	DM_Close_Quarters.cs
//
// AUTHORS:  	Chupie Doll & Youth in Asia
//------------------------------------------------------------------------------

$missionName = "DM_Close_Quarters";

exec("multiplayerStdLib.cs");
exec("DMstdLib.cs");
// move the map
$server::HudMapViewOffsetX = -1500;
$server::HudMapViewOffsetY = -3500;
function setDefaultMissionOptions()
{
	$server::TeamPlay = false;
	$server::AllowDeathmatch = true;
	$server::AllowTeamPlay = true;	

   // what can the client choose for a team
	$server::AllowTeamRed = true;
	$server::AllowTeamBlue = true;
	$server::AllowTeamYellow = true;
	$server::AllowTeamPurple = true;

   // what can the server admin choose for available teams
   $server::disableTeamRed = false;
   $server::disableTeamBlue = false;
   $server::disableTeamYellow = false;
   $server::disableTeamPurple = false;
}

function onMissionLoad(){
   cdAudioCycle("Purge", "Newtech", "SS4", "SS3"); 
   // custom rules for this mission ( teleporter )
   %rules = "<tIDMULT_TDM_GAMETYPE>"   @        
            "<tIDMULT_TDM_MAPNAME>"    @ 
            $missionName               @
            "<tIDMULT_TDM_OBJECTIVES>" @
            "<tIDMULT_TDM_SCORING_1>"  @
            "<tIDMULT_TDM_SCORING_2>"  @
            $killPoints                @
            "<tIDMULT_TDM_SCORING_3>"  @
            "<tIDMULT_TDM_SCORING_4>"  @
            $deathPoints               @
            "<tIDMULT_TDM_SCORING_5>"  @
            "<tIDMULT_TDM_SCORING_6>"  @
            "<tIDMULT_STD_ITEMS>"      @
            "<tIDMULT_STD_TELEPORTER>" @
            "<tIDMULT_STD_HEAL>"       @
            "<tIDMULT_STD_RELOAD>";

   setGameInfo(%rules);

}

function setDefaultMissionItems() 
{
   allowVehicle("all", true);
   allowComponent("all", true);
   allowWeapon("all", true);
}

// Transporter Functionality
// --------------------------------------------------------------------------
function deathmatchTransport(%this, %vehicleId){
	%teamName = getTeam(%vehicleId);
   
	%huh = randomInt(1, 5);
	if(%huh == 1){
		transportToYellowBase(%vehicleId);
	}
	else if(%huh == 2){
		transportToBlueBase(%vehicleId);
	}
	else if(%huh == 3){
		transportToRedBase(%vehicleId);
	}
	else if(%huh == 4){
		transportToPurpleBase(%vehicleId);
	}
	else{
		transportToMountain(%vehicleId);
	}
}
function YellowTransporter::trigger::onEnter(%this, %vehicleId){
	if($server::TeamPlay == false){
		deathmatchTransport(%this, %vehicleId);
		return;
	}

	%teamName = getTeam(%vehicleId);
   
   	if(%teamName == *IDSTR_TEAM_YELLOW){
		%huh = randomInt(1, 4);
		if(%huh == 1){
			transportToBlueBase(%vehicleId);
		}
		else if(%huh == 2){
			transportToRedBase(%vehicleId);
		}
		else if(%huh == 3){
			transportToPurpleBase(%vehicleId);
		}
		else{
			transportToMountain(%vehicleId);
		}
	}
	else{
		transportToHomeBase(%vehicleId);
	}
}
function BlueTransporter::trigger::onEnter(%this, %vehicleId){
	if($server::TeamPlay == false){
		deathmatchTransport(%this, %vehicleId);
		return;
	}

	%teamName = getTeam(%vehicleId);
   
   	if(%teamName == *IDSTR_TEAM_BLUE){
		%huh = randomInt(1, 4);
		if(%huh == 1){
			transportToBlueBase(%vehicleId);
		}
		else if(%huh == 2){
			transportToBlueBase(%vehicleId);
		}
		else if(%huh == 3){
			transportToBlueBase(%vehicleId);
		}
		else{
			transportToBlueBase(%vehicleId);
		}
	}
	else{
		transportToHomeBase(%vehicleId);
	}
}
function RedTransporter::trigger::onEnter(%this, %vehicleId){
	if($server::TeamPlay == false){
		deathmatchTransport(%this, %vehicleId);
		return;
	}
	%teamName = getTeam(%vehicleId);
   
   	if(%teamName == *IDSTR_TEAM_RED){
		%huh = randomInt(1, 4);
		if(%huh == 1){
			transportToRedBase(%vehicleId);
		}
		else if(%huh == 2){
			transportToRedBase(%vehicleId);
		}
		else if(%huh == 3){
			transportToRedBase(%vehicleId);
		}
		else{
			transportToRedBase(%vehicleId);
		}
	}
	else{
		transportToHomeBase(%vehicleId);
	}
}
function PurpleTransporter::trigger::onEnter(%this, %vehicleId){
	if($server::TeamPlay == false){
		deathmatchTransport(%this, %vehicleId);
		return;
	}
	%teamName = getTeam(%vehicleId);

   	if(%teamName == *IDSTR_TEAM_PURPLE){
		%huh = randomInt(1, 4);
		if(%huh == 1){
			transportToBlueBase(%vehicleId);
		}
		else if(%huh == 2){
			transportToRedBase(%vehicleId);
		}
		else if(%huh == 3){
			transportToYellowBase(%vehicleId);
		}
		else{
			transportToMountain(%vehicleId);
		}
	}
	else{
		transportToHomeBase(%vehicleId);
	}
}

function transportToBlueBase(%vehicleId)
{
	echo("Transporting to Blue Base");
	randomTransport(%vehicleId, -1529, -3590, -3580, -3560);
}
function transportToYellowBase(%vehicleId)
{
	echo("Transporting to Yellow Base");
	randomTransport(%vehicleId, 582, -2016, 715, -1968);
}
function transportToRedBase(%vehicleId)
{
	echo("Transporting to Red Base");
	randomTransport(%vehicleId, -813, -800, -810, -820);
}
function transportToPurpleBase(%vehicleId)
{
	echo("Transporting to Purple Base");
    randomTransport(%vehicleId, -2948, 66, -3041, -117);
}
function transportToMountain(%vehicleId)
{
      randomTransport(%vehicleId, 56, 667, 60, 675);
}

function transportToHomeBase(%vehicleId)
{
	// What colour is this person?
   %teamName = getTeam(%vehicleId);
   
	// Call the appropriate transport function (above) and get them home
   if(%teamName == *IDSTR_TEAM_YELLOW)
   {
      transportToYellowBase(%vehicleId);
   }
   else if(%teamName == *IDSTR_TEAM_RED)
   {
      transportToRedBase(%vehicleId);
   }
   else if(%teamName == *IDSTR_TEAM_BLUE)
   {
      transportToBlueBase(%vehicleId);
   }
   else
   {
      transportToPurpleBase(%vehicleId);
   }   
}
