VERSION 5.00
Begin VB.Form frmDecoder 
   Caption         =   "Decoder"
   ClientHeight    =   3495
   ClientLeft      =   60
   ClientTop       =   345
   ClientWidth     =   3855
   LinkTopic       =   "Form1"
   ScaleHeight     =   3495
   ScaleWidth      =   3855
   StartUpPosition =   3  'Windows Default
   Begin VB.Timer tmrMoveMotor 
      Interval        =   100
      Left            =   0
      Top             =   0
   End
   Begin VB.Frame fraMotor 
      Caption         =   "Motors"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   1815
      Left            =   120
      TabIndex        =   1
      Top             =   1560
      Width           =   3615
      Begin VB.HScrollBar hscSpeed 
         Height          =   255
         Left            =   2520
         TabIndex        =   32
         Top             =   1440
         Width           =   975
      End
      Begin VB.OptionButton optDirection 
         Caption         =   "CClockwise"
         Height          =   255
         Index           =   1
         Left            =   1320
         TabIndex        =   31
         Top             =   1440
         Width           =   1215
      End
      Begin VB.OptionButton optDirection 
         Caption         =   "Clockwise"
         Height          =   255
         Index           =   0
         Left            =   120
         TabIndex        =   30
         Top             =   1440
         Width           =   1215
      End
      Begin VB.CommandButton cmdStop 
         Caption         =   "Stop"
         Height          =   1095
         Left            =   2520
         TabIndex        =   10
         Top             =   240
         Width           =   975
      End
      Begin VB.CommandButton cmdMotor 
         Caption         =   "8"
         Height          =   495
         Index           =   7
         Left            =   1920
         TabIndex        =   9
         Top             =   840
         Width           =   495
      End
      Begin VB.CommandButton cmdMotor 
         Caption         =   "7"
         Height          =   495
         Index           =   6
         Left            =   1320
         TabIndex        =   8
         Top             =   840
         Width           =   495
      End
      Begin VB.CommandButton cmdMotor 
         Caption         =   "6"
         Height          =   495
         Index           =   5
         Left            =   720
         TabIndex        =   7
         Top             =   840
         Width           =   495
      End
      Begin VB.CommandButton cmdMotor 
         Caption         =   "5"
         Height          =   495
         Index           =   4
         Left            =   120
         TabIndex        =   6
         Top             =   840
         Width           =   495
      End
      Begin VB.CommandButton cmdMotor 
         Caption         =   "4"
         Height          =   495
         Index           =   3
         Left            =   1920
         TabIndex        =   5
         Top             =   240
         Width           =   495
      End
      Begin VB.CommandButton cmdMotor 
         Caption         =   "3"
         Height          =   495
         Index           =   2
         Left            =   1320
         TabIndex        =   4
         Top             =   240
         Width           =   495
      End
      Begin VB.CommandButton cmdMotor 
         Caption         =   "2"
         Height          =   495
         Index           =   1
         Left            =   720
         TabIndex        =   3
         Top             =   240
         Width           =   495
      End
      Begin VB.CommandButton cmdMotor 
         Caption         =   "1"
         Height          =   495
         Index           =   0
         Left            =   120
         TabIndex        =   2
         Top             =   240
         Width           =   495
      End
   End
   Begin VB.Frame fraStatus 
      Caption         =   "Status (378H)"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   1335
      Left            =   120
      TabIndex        =   0
      Top             =   120
      Width           =   3615
      Begin VB.PictureBox pctPin 
         Height          =   255
         Index           =   7
         Left            =   600
         ScaleHeight     =   195
         ScaleWidth      =   195
         TabIndex        =   20
         Top             =   600
         Width           =   255
      End
      Begin VB.PictureBox pctPin 
         Height          =   255
         Index           =   6
         Left            =   960
         ScaleHeight     =   195
         ScaleWidth      =   195
         TabIndex        =   19
         Top             =   600
         Width           =   255
      End
      Begin VB.PictureBox pctPin 
         Height          =   255
         Index           =   5
         Left            =   1320
         ScaleHeight     =   195
         ScaleWidth      =   195
         TabIndex        =   18
         Top             =   600
         Width           =   255
      End
      Begin VB.PictureBox pctPin 
         Height          =   255
         Index           =   4
         Left            =   1680
         ScaleHeight     =   195
         ScaleWidth      =   195
         TabIndex        =   17
         Top             =   600
         Width           =   255
      End
      Begin VB.PictureBox pctPin 
         Height          =   255
         Index           =   3
         Left            =   2040
         ScaleHeight     =   195
         ScaleWidth      =   195
         TabIndex        =   16
         Top             =   600
         Width           =   255
      End
      Begin VB.PictureBox pctPin 
         Height          =   255
         Index           =   2
         Left            =   2400
         ScaleHeight     =   195
         ScaleWidth      =   195
         TabIndex        =   15
         Top             =   600
         Width           =   255
      End
      Begin VB.PictureBox pctPin 
         Height          =   255
         Index           =   1
         Left            =   2760
         ScaleHeight     =   195
         ScaleWidth      =   195
         TabIndex        =   14
         Top             =   600
         Width           =   255
      End
      Begin VB.PictureBox pctPin 
         Height          =   255
         Index           =   0
         Left            =   3120
         ScaleHeight     =   195
         ScaleWidth      =   195
         TabIndex        =   13
         Top             =   600
         Width           =   255
      End
      Begin VB.Label lblTitle 
         Caption         =   "Pins:"
         Height          =   255
         Index           =   9
         Left            =   120
         TabIndex        =   29
         Top             =   960
         Width           =   495
      End
      Begin VB.Label lblTitle 
         Alignment       =   2  'Center
         Caption         =   "2"
         Height          =   255
         Index           =   8
         Left            =   3120
         TabIndex        =   28
         Top             =   960
         Width           =   255
      End
      Begin VB.Label lblTitle 
         Alignment       =   2  'Center
         Caption         =   "3"
         Height          =   255
         Index           =   7
         Left            =   2760
         TabIndex        =   27
         Top             =   960
         Width           =   255
      End
      Begin VB.Label lblTitle 
         Alignment       =   2  'Center
         Caption         =   "4"
         Height          =   255
         Index           =   6
         Left            =   2400
         TabIndex        =   26
         Top             =   960
         Width           =   255
      End
      Begin VB.Label lblTitle 
         Alignment       =   2  'Center
         Caption         =   "5"
         Height          =   255
         Index           =   5
         Left            =   2040
         TabIndex        =   25
         Top             =   960
         Width           =   255
      End
      Begin VB.Label lblTitle 
         Alignment       =   2  'Center
         Caption         =   "6"
         Height          =   255
         Index           =   4
         Left            =   1680
         TabIndex        =   24
         Top             =   960
         Width           =   255
      End
      Begin VB.Label lblTitle 
         Alignment       =   2  'Center
         Caption         =   "7"
         Height          =   255
         Index           =   3
         Left            =   1320
         TabIndex        =   23
         Top             =   960
         Width           =   255
      End
      Begin VB.Label lblTitle 
         Alignment       =   2  'Center
         Caption         =   "8"
         Height          =   255
         Index           =   2
         Left            =   960
         TabIndex        =   22
         Top             =   960
         Width           =   255
      End
      Begin VB.Label lblTitle 
         Alignment       =   2  'Center
         Caption         =   "9"
         Height          =   255
         Index           =   1
         Left            =   600
         TabIndex        =   21
         Top             =   960
         Width           =   255
      End
      Begin VB.Label lblValue 
         Caption         =   "Label1"
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   255
         Left            =   720
         TabIndex        =   12
         Top             =   240
         Width           =   1335
      End
      Begin VB.Label lblTitle 
         Caption         =   "Value:"
         Height          =   255
         Index           =   0
         Left            =   120
         TabIndex        =   11
         Top             =   240
         Width           =   615
      End
   End
End
Attribute VB_Name = "frmDecoder"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
'this is a sample program for the schematic [using a demultiplexer to control 8 motors].
'for simplicity's sake, this program assumes that you followed the connections
'specified on the schematic.

'i didn't add the i/o dll on this example. i leave this up to you.

Option Explicit
Dim intSelectedMotor As Integer     'this variable will hold the selected motor
Dim intAddress As Integer           'the address of the selected motor
Dim intDirection As Integer         'the direction of the motor: 0 = clockwise; 2 = counterclockwise
Dim intTrigger As Integer           'the trigger pin (CLOCK PULSE)

Const LOW = &H8000000F              'default color (&H8000000F&) of the picture box meaning no voltage
Const HIGH = &HFF&                  'red color (&H000000FF&) of the picture box meaning it has voltage

Private Sub cmdMotor_Click(Index As Integer)
    Select Case Index
        Case 0
            intSelectedMotor = 1
        Case 1
            intSelectedMotor = 2
        Case 2
            intSelectedMotor = 3
        Case 3
            intSelectedMotor = 4
        Case 4
            intSelectedMotor = 5
        Case 5
            intSelectedMotor = 6
        Case 6
            intSelectedMotor = 7
        Case 7
            intSelectedMotor = 8
    End Select
    tmrMoveMotor.Enabled = True
End Sub

Private Sub cmdStop_Click()
Dim x As Integer
    tmrMoveMotor.Enabled = False
    
    'set all colors to default
    For x = 0 To 7
        pctPin(x).BackColor = LOW
    Next x
End Sub

Private Sub Form_Load()
    optDirection(0).Value = True    'set clockwise as default direction
    intDirection = 0
    intTrigger = 0
    With hscSpeed
        .Max = 10
        .Min = 1
        .Value = 1
        .LargeChange = 2
        .SmallChange = 1
    End With
    With tmrMoveMotor
        .Enabled = False    'stop timer event
        .Interval = hscSpeed.Value * 100
    End With
End Sub

Private Sub hscSpeed_Change()
'change the speed of the motor
    tmrMoveMotor.Interval = hscSpeed.Value * 100    'convert to milliseconds
End Sub

Private Sub optDirection_Click(Index As Integer)
    If optDirection(0).Value = True Then intDirection = 0 Else intDirection = 2
End Sub

Private Sub tmrMoveMotor_Timer()
'NOTE: it takes two consecutive calls to this procedure to make the motor move one step

Dim intOutput As Integer    'this will be the actual value that will be sent to the parallel port
    Select Case intSelectedMotor
        'pin assignment  9 - 8 - 7
        Case 1          '0   0   0
            intAddress = &H0
        Case 2          '0   0   1
            intAddress = &H20
        Case 3          '0   1   0
            intAddress = &H40
        Case 4          '0   1   1
            intAddress = &H60
        Case 5          '1   0   0
            intAddress = &H80
        Case 6          '1   0   1
            intAddress = &HA0
        Case 7          '1   1   0
            intAddress = &HC0
        Case 8          '1   1   1
            intAddress = &HE0
    End Select
    
    intTrigger = IIf(intTrigger = 1, 0, 1)      'this toggles the trigger pin to emulate a clockpulse
    
    'you have to combine the address, direction and trigger signal to be able to move the motor
    intOutput = intAddress + intDirection + intTrigger

    'this line would be here if the i/o dll was included
    
    '=======================
    'OUT &H378, intOutput
    '=======================
    
    'instead, i'll just toggle the color of the picture boxes to give a visual feedback of the output
    Call ViewOutput(intOutput)
End Sub

Private Sub ViewOutput(ByVal intDATAOutput As Integer)
'an ideal way of checking the actual value of the DATA port would be to use the IN command,
'since i didn't include the library then i'll just check the value of intOutput

'this toggles the colors of the picture boxes. i'll just convert the output value (intOutput) to binary so
'we can determine which pins are active or not.
Dim x As Integer, intConvert As Integer
    'set all colors to default
    lblValue = CStr(intDATAOutput) & "H"
    For x = 0 To 7
        pctPin(x).BackColor = LOW
    Next x

    'converting decimal to binary
    For x = 0 To 7
        intConvert = intDATAOutput Mod 2        'get the remainder
        intDATAOutput = intDATAOutput \ 2           'perform integer division
        If intConvert = 1 Then pctPin(x).BackColor = HIGH Else pctPin(x).BackColor = LOW
    Next x
End Sub
