#include "gpdef.h"
#include "gpstdlib.h"
#include "gpgraphic.h"
#include "gpmain.h"
#include "gpstdio.h"
#include "gpfont.h"

void Delay(int ms);


GPDRAWSURFACE gpDraw[2];

void GpMain(void *arg)
{


	const char ScrollText[] = {"Hello GP32 dev'ers! This little example demonstrates how to do a little Textscroller. Greetings to everyone in #gp32dev and #gp32 !"};
	int nFlip=0;
	int xcoord;

	GpLcdSurfaceGet( &gpDraw[0], 0);  
	GpLcdSurfaceGet( &gpDraw[1], 1);
	GpSurfaceSet( &gpDraw[1]);
	GpLcdEnable(); 

	while(1)
	{
		xcoord=320;

		while(xcoord>-GpTextWidthGet( (char *)ScrollText))
		{	
			// Fill screen with black
			GpRectFill(NULL, &gpDraw[nFlip], 0, 0, 320, 240, 0x00);

			// Write text and wait 20 milliseconds
			GpTextOut(NULL, &gpDraw[nFlip], xcoord, 125, (char*)ScrollText, 0xFF);
			Delay(20);			

			// Flip surface
			GpSurfaceFlip( &gpDraw[nFlip]);
 			nFlip ^= 1;

			// lessen xcoord of text to be written to surface by 1
			xcoord -=1;
		}
	}
}

void Delay(int ms) {

unsigned int ticks;

	ticks=GpTickCountGet();
	while(GpTickCountGet()-ticks<ms);
}