/**
*@Author Rakesh Sawan
*@Date 15-3-1999
**/
import java.io.*;
import java.util.*;
import javax.servlet.*;
import javax.servlet.http.*;
import GuestBook;
import Entry;
import GuestBookImpl;
import java.rmi.*;
public class GuestBookServlet extends HttpServlet{
	private String entryFile;
	private String userName;
	private String email;
	private String hp;
	private String mesg;
	private GuestBook gb;
	private String dir;
	private static final boolean debug=false;
	public void init(ServletConfig config) throws ServletException{
		try{
		super.init(config);
		dir=getInitParameter("dir");
		if (dir == null) {
	    Enumeration initParams = getInitParameterNames();
	    System.err.println("The init parameters were: ");
	    while (initParams.hasMoreElements()) {
		System.err.println(initParams.nextElement());
	    }
	    System.err.println("Should have seen one parameter name");
	    throw new UnavailableException (this,
		"Not given a directory to write survey results!");
	}
	
		loadGuestBook();
		if(debug)
		System.out.println("Guest book Loaded");
		}catch(Exception e){
			System.out.println(e.getMessage());
		}
	}
public void doGet(HttpServletRequest req,HttpServletResponse res)
		throws ServletException,IOException{
	if(req.getQueryString().equals("getgbform")){
		PrintWriter out=res.getWriter();
		BufferedReader in=new BufferedReader(new FileReader(
			dir+"/gb.html"));
		res.setContentType("text/html");
		res.setStatus(HttpServletResponse.SC_OK);
		copy(in,out);
	}
	if(req.getQueryString().equals("getgb")){
		res.setContentType("text/html");
		res.setStatus(HttpServletResponse.SC_OK);
		PrintWriter out=res.getWriter();
		out.println("<html>");
		out.println("<head><title> Rakesh Sawans GuestBook</title></head>");
		out.println("<body>");
		Entry e;
		int no=gb.getTotalEntries();
		out.println("<h6> Total Number of guests"+no+"<h6><br>");
		for(int i=1;i<=no;i++){
		out.println("<hr><table><tr><td>");
		out.println("<font size=-3><b>Record</b>"+i+"</font><br>");
			e=gb.getEntry(i);
			writeEntry(e,out);
		out.println("</td></tr></table></hr>");
		}
		out.println("</body>");
		out.println("</head>");
		out.println("</html>");
		out.flush();
	}
}
private void writeEntry(Entry e,PrintWriter out) throws RemoteException{
	out.println("<b>Name</b>:"+e.getName()+"<br>");
	out.println("<b>Email</b>:"+e.getEmail()+"<br>");
	out.println("<b>HomePage</b>:"+e.getHp()+"<br>");
	out.println("<b>Message</b>:"+e.getMesg()+"<br>");

}
private void copy(BufferedReader in,PrintWriter out) throws IOException{
	String line;
	do{
	line=in.readLine();
	out.println(line);
	}while(line!=null);
	out.flush();
	out.close();
	in.close();
}
		

	public void doPost(HttpServletRequest req,HttpServletResponse res)
		throws ServletException,IOException{
		try{
			storeEntry(req);
		if(debug)
		System.out.println("Guest book Saved");
		}catch(Exception e){
			System.out.println(e.getMessage());
		}
	}
	public void loadGuestBook() throws Exception{
			gb=new GuestBookImpl(dir+"/database");
			gb.open();
			if(debug)
			System.out.println("GuestBook found");
	}
	public void storeEntry(HttpServletRequest req) throws Exception{
		Entry e=null;
		e=gb.new_Entry();	
		e.setName(req.getParameter("name").toString());
		e.setEmail(req.getParameter("email"));
		e.setHp(req.getParameter("hp"));
		e.setMesg(req.getParameter("mesg"));
		gb.saveEntry(e);
		gb.close();
	}
		
}
