/**
*Author Rakesh Sawan
*Date 12-3-1999
**/
import java.io.*;
import java.util.*;
public class GuestBookImpl implements GuestBook{
	private final static String myInstanceFile="gb.inst";
	private int noOfEntry;
	private String pwd;
	private static final boolean debug=false;
	public GuestBookImpl(String dir){
	pwd=dir+"/";
	if(debug)
	System.out.println("pwd="+pwd);
	}
	public void open() {
		try{
		FileInputStream fin=new FileInputStream(pwd+myInstanceFile);
		Properties me=new Properties();
		me.load(fin);
		noOfEntry=Integer.valueOf(me.getProperty("entries")).intValue();
		fin.close();
		}
		catch(Exception e){
			noOfEntry=0;
		}
		if(debug)
		System.out.println("Total Entries Found"+noOfEntry);
	}
	public int getTotalEntries() {
		return noOfEntry;
	}
	public Entry new_Entry(){
		return new EntryImpl();
	}
		
	public Entry getEntry(int entryNo) throws 
					IOException{
		Entry en=null;
		try{
		FileInputStream fin=new FileInputStream(pwd+"entry"+entryNo+".prop");
		Properties me=new Properties();
		me.load(fin);
		en=new_Entry();
	 	en.setName(me.getProperty("name"));
	 	en.setEmail(me.getProperty("email"));
	 	en.setHp(me.getProperty("hp"));
	 	en.setMesg(me.getProperty("mesg"));
		fin.close();
		}catch(Exception e){}
		return en;
	}


		
					
	public void saveEntry(Entry e) throws IOException{
		try{
		noOfEntry++;
		FileOutputStream fout=new FileOutputStream
					(pwd+"entry"+noOfEntry+".prop");
		Properties me=new Properties();
		me.put("name",e.getName());
		me.put("email",e.getEmail());
		me.put("hp",e.getHp());
		me.put("mesg",e.getMesg());
		me.save(fout,"I am Entry Object no.:"+noOfEntry);
		fout.flush();
		fout.close();
		if(debug)
		System.out.println("Entry Saved"+noOfEntry);
		}catch(Exception ex){
			System.out.println("Unable to save the Entry"+noOfEntry+ex);
		}
	}
	public void close() {
		try{
		FileOutputStream fout=new FileOutputStream(pwd+myInstanceFile);
		Properties me=new Properties();
		me.put("entries",new Integer(noOfEntry).toString());
		me.save(fout,"I am GuestBook Object");
		if(debug)
		System.out.println("Saving Total Entries"+noOfEntry);
		fout.flush();
		fout.close();
		}
		catch(Exception e){
			System.out.println("Unable to save"+e);
		}
	}

}	
