/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.rmi.RemoteException;
import java.util.Enumeration;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.UnavailableException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class GuestBookServlet
extends HttpServlet {
    private String entryFile;
    private String userName;
    private String email;
    private String hp;
    private String mesg;
    private GuestBook gb;
    private String dir;
    private static final boolean debug = false;

    public void init(ServletConfig servletConfig) throws ServletException {
        try {
            super.init(servletConfig);
            this.dir = this.getInitParameter("dir");
            if (this.dir == null) {
                Enumeration enumeration = this.getInitParameterNames();
                System.err.println("The init parameters were: ");
                while (enumeration.hasMoreElements()) {
                    System.err.println(enumeration.nextElement());
                }
                System.err.println("Should have seen one parameter name");
                throw new UnavailableException((Servlet)this, "Not given a directory to write survey results!");
            }
            this.loadGuestBook();
            return;
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
            return;
        }
    }

    public void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        Object object;
        PrintWriter printWriter;
        if (httpServletRequest.getQueryString().equals("getgbform")) {
            printWriter = httpServletResponse.getWriter();
            object = new BufferedReader(new FileReader(String.valueOf(this.dir) + "/gb.html"));
            httpServletResponse.setContentType("text/html");
            httpServletResponse.setStatus(200);
            this.copy((BufferedReader)object, printWriter);
        }
        if (httpServletRequest.getQueryString().equals("getgb")) {
            httpServletResponse.setContentType("text/html");
            httpServletResponse.setStatus(200);
            printWriter = httpServletResponse.getWriter();
            printWriter.println("<html>");
            printWriter.println("<head><title> Rakesh Sawans GuestBook</title></head>");
            printWriter.println("<body>");
            int n = this.gb.getTotalEntries();
            printWriter.println("<h6> Total Number of guests" + n + "<h6><br>");
            int n2 = 1;
            while (n2 <= n) {
                printWriter.println("<hr><table><tr><td>");
                printWriter.println("<font size=-3><b>Record</b>" + n2 + "</font><br>");
                object = this.gb.getEntry(n2);
                this.writeEntry((Entry)object, printWriter);
                printWriter.println("</td></tr></table></hr>");
                ++n2;
            }
            printWriter.println("</body>");
            printWriter.println("</head>");
            printWriter.println("</html>");
            printWriter.flush();
        }
    }

    private void writeEntry(Entry entry, PrintWriter printWriter) throws RemoteException {
        printWriter.println("<b>Name</b>:" + entry.getName() + "<br>");
        printWriter.println("<b>Email</b>:" + entry.getEmail() + "<br>");
        printWriter.println("<b>HomePage</b>:" + entry.getHp() + "<br>");
        printWriter.println("<b>Message</b>:" + entry.getMesg() + "<br>");
    }

    private void copy(BufferedReader bufferedReader, PrintWriter printWriter) throws IOException {
        String string;
        do {
            string = bufferedReader.readLine();
            printWriter.println(string);
        } while (string != null);
        printWriter.flush();
        printWriter.close();
        bufferedReader.close();
    }

    public void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        try {
            this.storeEntry(httpServletRequest);
            return;
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
            return;
        }
    }

    public void loadGuestBook() throws Exception {
        this.gb = new GuestBookImpl(String.valueOf(this.dir) + "/database");
        this.gb.open();
    }

    public void storeEntry(HttpServletRequest httpServletRequest) throws Exception {
        Entry entry = null;
        entry = this.gb.new_Entry();
        entry.setName(httpServletRequest.getParameter("name").toString());
        entry.setEmail(httpServletRequest.getParameter("email"));
        entry.setHp(httpServletRequest.getParameter("hp"));
        entry.setMesg(httpServletRequest.getParameter("mesg"));
        this.gb.saveEntry(entry);
        this.gb.close();
    }
}

