/**
*@vesrion 1.0
*@Author ------Rakesh Sawan
*Date --------12-12-1998
**/
/**
*This utility reads and writes datas in text format 
**/
import java.io.*;
import java.util.*;
class TextFile{
	/*Variable Declaration*/
	protected String fileName;

	protected BufferedReader in;

	protected PrintWriter out;

	/*number of input data tokens from the file or to the file*/

	protected int inToken;

	/*number of output data tokens from the file or to the file*/

	protected int outToken=0;

	/**
	*Array of tokens which will store the data tokens in string
	* format while reading or writing
	**/
	protected String [] tokenArray;

	/*
	*Maximum number of tokens to be read or written this number is 
	*Arbritrary and used to allocate memory for arrayToken variable
	**/

	protected  int MAXTOC=10;

/**
*Class Constructor Takes the fileName as Argument
**/
	
	TextFile(String fileName){
		this.fileName=fileName;
			inToken=0;
			tokenArray=new String[MAXTOC];


		
	}

/*
*C like method to open a file either in reading mode or writing 
*mode And throughs UnknownFileModeException if the mode is not
*either "r" or "w"
*@param s mode
**/
	void open(String mode) throws FileNotFoundException,IOException,
			UnknownFileModeException{
		if(mode.equals("r")){
			InputStreamReader inn=new FileReader(fileName);
			in=new BufferedReader(inn);
			
		}
			
		else if(mode.equals("w")){
			OutputStream outt=new FileOutputStream(fileName);
			out=new PrintWriter(outt);
		}
		else
			throw new UnknownFileModeException("Unknown file Opening Mode");
	}

	/**
	* Reads a line in the tokenArray if the size exceeds MAXTOC
	*Further mem is allocated in tmp and all members are copied
	*in to tmp and tokenArray is made to point to tmp
	**/
	void readLine() throws IOException{
		if(inToken==0){
			outToken=0;
			String line=in.readLine();
			if(line==null){
				throw new EOFException("File is Empty");
			}
			StringTokenizer str=new StringTokenizer(line);
			while(str.hasMoreTokens()){
				tokenArray[inToken]=str.nextToken();
				inToken++;
				if(inToken>MAXTOC-1){
					System.out.println("line length more inToken="+inToken);
					String tmp[]=new String[MAXTOC+10];
					System.arraycopy(tokenArray,0,tmp,0,inToken);
					MAXTOC+=10;
					tokenArray=tmp;
				}
			}
		}

	}
	/**
	*Reads an integer from the Text File
	**/
	public int readInt() throws IOException{
		readLine();
		int value=(new Integer(tokenArray[outToken])).intValue();
		outToken++;
		inToken--;
		return value;
	}

	/**
	*Reads an String of word from the Text File
	**/

	public String readWord() throws IOException{
		readLine();
		String word=tokenArray[outToken];
		outToken++;
		inToken--;
		return word;
	}
	/**
	*Reads an float from the Text File
	**/
	public float readFloat() throws IOException{
		readLine();
		float value=(new Float(tokenArray[outToken])).floatValue();
		outToken++;
		inToken--;
		return value;
	}

	/**
	*Reads an double from the Text File
	**/
	public double readDouble() throws IOException{

		double value=(new Double(tokenArray[outToken])).doubleValue();
		outToken++;
		inToken--;
		return value;
	}
	/**
	*writes an string of word to the Text File
	**/
	public void writeInt(String word) throws IOException{
		writeToTokArray(word);
	}

	/**
	*writes an integer to the Text File
	**/
	public void writeInt(int num) throws IOException{
		writeToTokArray((new Integer(num)).toString());
	}
	/**
	*writes an float to the Text File
	**/
	public void writeFloat(float num) throws IOException{
		writeDouble((double)num);
	}
	/**
	*writes an double to the Text File
	**/
	public void writeDouble(double num) throws IOException{
		writeToTokArray((new Double(num)).toString());
	}
	/**
	* Writes the data in tokenArray variable
	**/
	private void writeToTokArray(String s){
		tokenArray[inToken]=s;
		inToken++;
		if(inToken>=MAXTOC)
		writeToFile();
	}

	/**
	*Writes the tokenArray into the file in text format
	**/
	private void writeToFile(){
			StringBuffer line=new StringBuffer();
			for(int i=0;i<inToken;i++){
				 line.append(tokenArray[i]);
				 line.append("  ");
			}
			out.println(line);
			out.flush();
			inToken=0;
	}
		

	/**
	*closes the all file handles and writes the remaining tokens
	*to the outputfile
	**/
	public void close() throws IOException{
		if(out!=null){
		out.close();
		writeToFile();
		}

		if(in!=null)
		in.close();
	}



	public static void main(String []args){
		TextFile file1=new TextFile(args[0]);

		/*reading example*/

		try{
		file1.open("r");
		System.out.println("file contents are");
		try{
		while(true){
			System.out.println("read :"+file1.readFloat());
		} 
		}catch(EOFException e){}
			
		/*writing example*/

		System.out.println("writing to file"+args[1]);
		TextFile file2=new TextFile(args[1]);
		file2.open("w");
		for(int i=0;i<41;i++){
		file2.writeDouble(1.22222);
		}
		file1.close();
		file2.close();
		}catch(Exception e){
			System.out.println("Exception "+e);
		}
	}
}

			



