/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.EOFException;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.StringTokenizer;

class TextFile {
    protected String fileName;
    protected BufferedReader in;
    protected PrintWriter out;
    protected int inToken;
    protected int outToken;
    protected String[] tokenArray;
    protected int MAXTOC = 10;

    public double readDouble() throws IOException {
        double value = new Double(this.tokenArray[this.outToken]);
        ++this.outToken;
        this.inToken += -1;
        return value;
    }

    public void writeDouble(double num) throws IOException {
        this.writeToTokArray(new Double(num).toString());
    }

    public float readFloat() throws IOException {
        this.readLine();
        float value = new Float(this.tokenArray[this.outToken]).floatValue();
        ++this.outToken;
        this.inToken += -1;
        return value;
    }

    public void writeFloat(float num) throws IOException {
        this.writeDouble(num);
    }

    private void writeToTokArray(String s) {
        this.tokenArray[this.inToken] = s;
        ++this.inToken;
        if (this.inToken >= this.MAXTOC) {
            this.writeToFile();
        }
    }

    public String readWord() throws IOException {
        this.readLine();
        String word = this.tokenArray[this.outToken];
        ++this.outToken;
        this.inToken += -1;
        return word;
    }

    void open(String mode) throws FileNotFoundException, IOException, UnknownFileModeException {
        if (mode.equals("r")) {
            FileReader inn = new FileReader(this.fileName);
            this.in = new BufferedReader(inn);
        } else if (mode.equals("w")) {
            FileOutputStream outt = new FileOutputStream(this.fileName);
            this.out = new PrintWriter(outt);
        } else {
            throw new UnknownFileModeException("Unknown file Opening Mode");
        }
    }

    public void close() throws IOException {
        if (this.out != null) {
            this.out.close();
            this.writeToFile();
        }
        if (this.in != null) {
            this.in.close();
        }
    }

    TextFile(String fileName) {
        this.fileName = fileName;
        this.inToken = 0;
        this.tokenArray = new String[this.MAXTOC];
    }

    private void writeToFile() {
        StringBuffer line = new StringBuffer();
        int i = 0;
        while (i < this.inToken) {
            line.append(this.tokenArray[i]);
            line.append("  ");
            ++i;
        }
        this.out.println(line);
        this.out.flush();
        this.inToken = 0;
    }

    void readLine() throws IOException {
        if (this.inToken == 0) {
            this.outToken = 0;
            String line = this.in.readLine();
            if (line == null) {
                throw new EOFException("File is Empty");
            }
            StringTokenizer str = new StringTokenizer(line);
            while (str.hasMoreTokens()) {
                this.tokenArray[this.inToken] = str.nextToken();
                ++this.inToken;
                if (this.inToken <= this.MAXTOC - 1) continue;
                System.out.println("line length more inToken=" + this.inToken);
                String[] tmp = new String[this.MAXTOC + 10];
                System.arraycopy(this.tokenArray, 0, tmp, 0, this.inToken);
                this.MAXTOC += 10;
                this.tokenArray = tmp;
            }
        }
    }

    public int readInt() throws IOException {
        this.readLine();
        int value = new Integer(this.tokenArray[this.outToken]);
        ++this.outToken;
        this.inToken += -1;
        return value;
    }

    public void writeInt(String word) throws IOException {
        this.writeToTokArray(word);
    }

    public void writeInt(int num) throws IOException {
        this.writeToTokArray(new Integer(num).toString());
    }

    public static void main(String[] args) {
        TextFile file1 = new TextFile(args[0]);
        try {
            file1.open("r");
            System.out.println("file contents are");
            try {
                while (true) {
                    System.out.println("read :" + file1.readFloat());
                }
            }
            catch (EOFException e) {
                System.out.println("writing to file" + args[1]);
                TextFile file2 = new TextFile(args[1]);
                file2.open("w");
                int i = 0;
                do {
                    file2.writeDouble(1.22222);
                } while (++i < 41);
                file1.close();
                file2.close();
            }
        }
        catch (Exception e) {
            System.out.println("Exception " + e);
        }
    }
}

