/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.Socket;
import java.net.SocketException;
import java.net.URL;
import java.net.UnknownHostException;

class HttpConnection {
    protected String url;
    protected Socket socket;
    protected InputStream in;
    protected OutputStream out;
    static String PROXY;
    static int PROXY_PORT;
    protected String header;
    protected static String logInfo;
    protected static String referer;
    protected boolean connected;
    protected static final boolean DEBUG = false;
    protected static boolean usingProxy;
    protected String hostToDnl;
    protected String host;
    protected int port;
    protected String fileToDnl;
    protected static int tried;
    protected String method = "GET";
    protected int responseCode = -1;
    protected String responseMessage;
    protected static String fileName;
    protected static String file;
    protected static int instanceCount;
    private static boolean followRedirects;
    private static final String[] methods;
    public static final int HTTP_OK = 200;
    public static final int HTTP_CREATED = 201;
    public static final int HTTP_ACCEPTED = 202;
    public static final int HTTP_NOT_AUTHORITATIVE = 203;
    public static final int HTTP_NO_CONTENT = 204;
    public static final int HTTP_RESET = 205;
    public static final int HTTP_PARTIAL = 206;
    public static final int HTTP_MULT_CHOICE = 300;
    public static final int HTTP_MOVED_PERM = 301;
    public static final int HTTP_MOVED_TEMP = 302;
    public static final int HTTP_SEE_OTHER = 303;
    public static final int HTTP_NOT_MODIFIED = 304;
    public static final int HTTP_USE_PROXY = 305;
    public static final int HTTP_BAD_REQUEST = 400;
    public static final int HTTP_UNAUTHORIZED = 401;
    public static final int HTTP_PAYMENT_REQUIRED = 402;
    public static final int HTTP_FORBIDDEN = 403;
    public static final int HTTP_NOT_FOUND = 404;
    public static final int HTTP_BAD_METHOD = 405;
    public static final int HTTP_NOT_ACCEPTABLE = 406;
    public static final int HTTP_PROXY_AUTH = 407;
    public static final int HTTP_CLIENT_TIMEOUT = 408;
    public static final int HTTP_CONFLICT = 409;
    public static final int HTTP_GONE = 410;
    public static final int HTTP_LENGTH_REQUIRED = 411;
    public static final int HTTP_PRECON_FAILED = 412;
    public static final int HTTP_ENTITY_TOO_LARGE = 413;
    public static final int HTTP_REQ_TOO_LONG = 414;
    public static final int HTTP_UNSUPPORTED_TYPE = 415;
    public static final int HTTP_SERVER_ERROR = 500;
    public static final int HTTP_INTERNAL_ERROR = 501;
    public static final int HTTP_BAD_GATEWAY = 502;
    public static final int HTTP_UNAVAILABLE = 503;
    public static final int HTTP_GATEWAY_TIMEOUT = 504;
    public static final int HTTP_VERSION = 505;

    HttpConnection(String string) {
        this.url = string;
        ++instanceCount;
        file = fileName;
        int n = string.substring(8).lastIndexOf("/");
        if (n < 0) {
            string = String.valueOf(string) + "/";
        }
        this.hostToDnl = string.substring(7, string.lastIndexOf("/"));
        this.fileToDnl = string.substring(string.lastIndexOf("/"));
        this.url = string;
    }

    public void setUsingProxy(boolean bl) {
        if (bl) {
            this.host = PROXY;
            this.port = PROXY_PORT;
            this.fileToDnl = "http://" + this.hostToDnl + this.fileToDnl;
        } else {
            this.host = this.hostToDnl;
            this.port = 80;
        }
        usingProxy = bl;
    }

    public boolean usingProxy() {
        return usingProxy;
    }

    public void setLogInfo(String string) {
        logInfo = string;
    }

    public void setReferer(String string) {
        referer = string;
    }

    public void connect() throws IOException {
        do {
            try {
                this.socket = new Socket(this.host, this.port);
                this.in = this.socket.getInputStream();
                this.out = this.socket.getOutputStream();
                this.get();
                this.connected = true;
            }
            catch (SocketException socketException) {
                System.out.println("****Server Refused ****TryingAfter 2 minutes...");
                try {
                    Thread.sleep(100000L);
                }
                catch (InterruptedException interruptedException) {}
                this.connected = false;
            }
        } while (!this.connected);
    }

    public void disconnect() throws IOException {
        this.in.close();
        this.out.close();
        this.socket.close();
        this.connected = false;
    }

    public InputStream getInputStream() throws FileNotFoundException {
        File file = new File(HttpConnection.file);
        return new FileInputStream(file);
    }

    public String getHeaderField(int n) throws IOException {
        int n2 = 0;
        InputStream inputStream = this.getInputStream();
        MyReader myReader = new MyReader(inputStream);
        String string = null;
        while (n2 != n + 1) {
            ++n2;
            string = myReader.readLine();
        }
        inputStream.close();
        return string;
    }

    public String getHeaderField(String string) throws FileNotFoundException, IOException {
        InputStream inputStream = this.getInputStream();
        MyReader myReader = new MyReader(inputStream);
        String string2 = null;
        do {
            string2 = myReader.readLine();
        } while ((string2 = string2.toLowerCase()).indexOf(string) < 0 && string2 != null);
        inputStream.close();
        int n = string2.indexOf(string) + string.length();
        if (string2.indexOf(string) >= 0) {
            return string2.substring(n);
        }
        return null;
    }

    public static void setFollowRedirects(boolean bl) {
        followRedirects = bl;
    }

    public static boolean getFollowRedirects() {
        return followRedirects;
    }

    public void setRequestMethod(String string) throws ProtocolException {
        if (this.connected) {
            throw new ProtocolException("Can't reset method: already connected");
        }
        int n = 0;
        while (n < methods.length) {
            if (methods[n].equals(string)) {
                this.method = string;
                return;
            }
            ++n;
        }
        throw new ProtocolException("Invalid HTTP method: " + string);
    }

    public String getRequestMethod() {
        return this.method;
    }

    public int getResponseCode() throws IOException {
        String string = this.getHeaderField(0);
        try {
            int n = string.indexOf(32);
            while (string.charAt(n) == ' ') {
                ++n;
            }
            this.responseCode = Integer.parseInt(string.substring(n, n + 3));
            this.responseMessage = string.substring(n + 4).trim();
            return this.responseCode;
        }
        catch (Exception exception) {
            return this.responseCode;
        }
    }

    public String getResponseMessage() throws IOException {
        this.getResponseCode();
        return this.responseMessage;
    }

    public void get() throws IOException, UnknownHostException, MalformedURLException {
        this.makeHeader();
        int n = 0;
        ++tried;
        do {
            this.connected = true;
            ++n;
            try {
                String string;
                MyWriter myWriter = new MyWriter(this.out);
                MyReader myReader = new MyReader(this.in);
                myWriter.sendLine(String.valueOf(this.header) + "\n");
                File file = new File(HttpConnection.file);
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                MyWriter myWriter2 = new MyWriter(fileOutputStream);
                while ((string = myReader.readLine()) != null) {
                    myWriter2.sendLine(string);
                }
                ((OutputStream)fileOutputStream).close();
            }
            catch (SocketException socketException) {
                System.out.println("Socket error\n" + socketException + "\n retrying after 2 minutes....");
                this.connected = false;
                try {
                    Thread.sleep(100000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        } while (!this.connected && n < 10);
        this.fix();
    }

    protected void fix() throws MalformedURLException, IOException {
        int n = this.getResponseCode();
        switch (n / 100) {
            case 3: {
                this.setNewLocation();
                this.connect();
                return;
            }
            case 4: {
                if (tried == 10) {
                    System.out.println("                          \n===============================================================================\n                                  Sorry Iam Fed UP!                           \n                      \t          I am Going Down!                           \n                                   Have A Good Day                             \n                                         Bye                                       \n================================================================================");
                    System.out.println("Error: While Downloading tried " + tried + "times");
                    System.out.println("Probable Cause: unable to download Your proxy may be down,\n                 or the website you gave is virtual");
                    System.exit(1);
                }
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException interruptedException) {}
                this.connect();
            }
        }
    }

    protected void setNewLocation() throws MalformedURLException {
        String string = null;
        try {
            string = this.getHeaderField("location:");
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("fileNotFound" + fileNotFoundException);
            System.exit(1);
        }
        catch (IOException iOException) {
            System.out.println("IOExecption" + iOException);
            System.exit(1);
        }
        URL uRL = new URL(string);
        this.hostToDnl = uRL.getHost();
        this.fileToDnl = uRL.getFile();
        this.setUsingProxy(true);
    }

    private String makeHeader() throws IOException {
        if (this.method.equals("GET")) {
            Header header = new Header();
            header.put("GET ", String.valueOf(this.fileToDnl) + " HTTP/1.0");
            header.put("Host: ", this.hostToDnl);
            header.put("Accept: ", "text/html, text/plain,application/html,*/*;q=0.001");
            header.put("Accept-Encoding: ", "gzip,compress");
            header.put("Accept-Language: ", "en");
            header.put("User-Agent: ", "sawan/1.0");
            this.header = header.toString();
            return this.header.toString();
        }
        if (this.method.equals("POST")) {
            Header header = new Header();
            header.put("POST ", this.fileToDnl);
            header.put("Host: ", this.hostToDnl);
            header.put("Accept: ", "text/html, text/plain*/*,application/html,*/*;q=0.001");
            header.put("Accept-Encoding: ", "gzip,compress");
            header.put("Accept-Language: ", "en");
            header.put("Pragma: ", "no-cache");
            header.put("Cache-Control: ", "no-cache");
            header.put("User-Agent: ", "sawan/1.0");
            header.put("Referer: ", referer);
            header.put("Content-Type: ", "application/x-wwwurlencoded");
            header.put("Content-length: ", new Integer(logInfo.length()).toString());
            header.put("\n", logInfo);
            this.header = header.toString();
            return this.header.toString();
        }
        return null;
    }

    public static void main(String[] stringArray) throws IOException, UnknownHostException {
        if (stringArray.length < 2) {
            System.out.println("usage java GetByProxy <URL> file fileto download file to store");
        }
        HttpConnection httpConnection = new HttpConnection(stringArray[0]);
        httpConnection.setUsingProxy(true);
        httpConnection.connect();
        System.out.println(httpConnection.getHeaderField(0));
        System.out.println(httpConnection.getResponseCode());
        System.out.println("done");
    }

    static {
        fileName = "tmp";
        followRedirects = true;
        methods = new String[]{"GET", "POST", "HEAD", "OPTIONS", "PUT", "DELETE", "TRACE"};
        PROXY = Setup.proxy;
        PROXY_PORT = Setup.port;
    }
}

