
/* -*-Java-*- */
/*
 *  Copyright (C) 2000  Rakesh Sawan <sawan@mailcity.com>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
import java.io.*;
class ChatUtility{
  protected static final int PACKET_HEADER=100;
  protected static final int PACKET_TAIL=101;
  protected static   boolean DEBUG=false;
  	ChatUtility(){
      DEBUG=Debug.DEBUG;
      }
   /**Check whether it's a valid packet WE expect
    *"header:code:sid:did:mesg:tail"
    *return the ChatPacket_t object
    **/
  public static ChatPacket_t getPacket(String raw){
  int headerIndex,codeIndex,sidIndex,didIndex,mesgIndex;
  int header,code,sid,did,tail;
  String mesg;
  if(DEBUG)
    System.out.println("parsing String"+raw);
  try{
    headerIndex=raw.indexOf(':');
      if(DEBUG)
      System.out.println("Header Index="+headerIndex);
    header=Integer.parseInt(raw.substring(0,headerIndex));
    if(header!=PACKET_HEADER){
      if(DEBUG)
        System.out.println("Not a good start");
      return null;  //Not an expected start of packet reject this
    }

    //get code
    codeIndex=raw.indexOf(':',headerIndex+1);
    code=Integer.parseInt(raw.substring(headerIndex+1,codeIndex));
    if(DEBUG)
      System.out.println("code="+code);
    //get Source ID
    sidIndex=raw.indexOf(':',codeIndex+1);
    sid=Integer.parseInt(raw.substring(codeIndex+1,sidIndex));
     if(DEBUG)
      System.out.println("sid="+sid);
    //get Destination ID
    didIndex=raw.indexOf(':',sidIndex+1);
    did=Integer.parseInt(raw.substring(sidIndex+1,didIndex));
     if(DEBUG)
      System.out.println("did="+did);
    //get Message
    mesgIndex=raw.indexOf(':',didIndex+1);
    mesg=raw.substring(didIndex+1,mesgIndex);
     if(DEBUG)
      System.out.println("mesg="+mesg);
    //get End of Packet i.e. tail
    tail=Integer.parseInt(raw.substring(mesgIndex+1));
    if(DEBUG)
      System.out.println("tail="+tail);
    if(tail!=PACKET_TAIL){
      if(DEBUG)
        System.out.println("Not a Good End of Packet");
      return null; //Not an expected end of packet reject this
    }

    //Prepare the packet
    ChatPacket_t chatPacket=new ChatPacket_t(code,sid,did,mesg);
    if(DEBUG)
    System.out.println("Returning good packet");
    return chatPacket;
    }catch(Exception e){
    if(DEBUG){
      e.printStackTrace();
      System.out.println("Exception occured in ChatUtility.getPacket Method");
    }

     return null;
    }
  }
}
	
