
/* -*-Java-*- */
/*
 *  Copyright (C) 2000  Rakesh Sawan <sawan@mailcity.com>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
import java.io.*;
import java.util.*;

class ChatServerHandler extends Observable
				implements ChatterImpl,Runnable{

	ChatSocket sock;

	protected ChatInputStream in;

	protected ChatOutputStream out;
	protected  int destID;
  protected  int myID=-1;
  protected static boolean DEBUG=true;




	protected static String to=null;

	ChatServerHandler(String host,int port) throws IOException{
    DEBUG=Debug.DEBUG;
		sock=new ChatSocket(host,port);
		in=sock.getChatInputStream();
		out=sock.getChatOutputStream();
		System.out.println("connected.......sending hello");
    //Say hello to server
    write(HELLO_CODE,SERVER_ID,"Hi Server");

		/* for connecting  to germani*/

			//System.out.println(in.readLine());

	}
	/**
	* Request to chatter xyz to talk to you
	**/
	public void request(int id) {
		write(REQUEST_CODE,id,"will you talk to me");
	}
	/**
	* Accept the request from xyz to talk
	**/
	public void acceptRequest(int destId,String mesg){

		write(ACCEPT_CODE,destId,mesg);
    if(DEBUG)
    System.out.println("Setting destId="+destID);
    destID=destId;
	}
	/**
	*Reject The Request to talk
	**/
	public void reject(int id,String mesg) throws IOException{
		write(REJECT_CODE,id,mesg);
	}
	/**
	* Inform The Chat CLient about the new messege from the
	*Chat Server
	**/
	private void informChatterGUI(ChatPacket_t cp){
    if(cp.getCode()==ASSIGN_ID_CODE){
      //Save ur ID which is Assigned to u by our server.
      myID=cp.getDestID();
      if(DEBUG)
      System.out.println("I am assigned ID="+myID);
    }
    else { //No need to inform when The server has sent My ID
      if(cp.getCode()==ACCEPT_CODE){
      //Save the ID of ur fellow chatter as he accepted ur request
      destID=cp.getSourceID();
      }
      //Forward the Packet to  the GUI client
      setChanged();
	  	notifyObservers(cp);
    }

	}
	public void setName(String name){
		write(INFORM_NAME_CODE,SERVER_ID,name);
	}
	public void chat(char ch)throws IOException{

		write(CHAT_CODE,destID,ch+"");
    if(DEBUG)
		System.out.println("Writing to chatter= "+destID+":"+ch);
	}
	public void quit() throws IOException{
		write(QUIT_CODE,SERVER_ID,"quitting");
	}

	public void write(int reqCode,int destID,String mesg){

		try{

			out.writePacket(new ChatPacket_t(reqCode,myID,destID,
        mesg));
		}catch(IOException e){
      if(DEBUG)
			System.out.println("exception"+e);
		}
	}
	public void go(){
		new Thread(this).start();
	}

	public void run(){
    ChatPacket_t cp;
    while(true){
      try{
       cp=in.readPacket();
        informChatterGUI(cp);

  		}catch(Exception e){
        if(DEBUG){
          System.out.println("Exception in run method of "+
          "ChatServerHandler"+e);
          e.printStackTrace();
        }
          try{
          in.close();
          }catch(Exception ignEx){}
          return;
      }
    }
	}
}





