
/* -*-Java-*- */
/*
 *  Copyright (C) 2000  Rakesh Sawan <sawan@mailcity.com>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
import java.util.*;
import java.io.*;
import java.net.*;
/**
* This class implements Observer interface to Observe the data read
*by the ChatclientHandler from the connection and tells the client
*to take appropriate step.
*It does So by overriding the method update of observer interface
**/
/**
*Author Rakesh Sawan
*Place IIT-Kharagpur
*Year 1998
**/
class ChatServer implements Observer,Runnable,ChatterImpl{
	/**
	*variable declaration
	**/
	/* the port number at which server will provide chat service*/

	protected static int port=9000;
   protected static  boolean DEBUG=true;
  /*all the clientConneciotn instances are stored in this table
	**/
	protected Hashtable clientConn;

	/**
	*the only constructor which does initialization work
	**/
	ChatServer(){
		clientConn=new Hashtable();
    DEBUG=Debug.DEBUG;
	}
	/**
	*the update method is clalled by some client find who it is
	* and what it want's
	**/
public void update(Observable obj,Object o){
  if(DEBUG)
	System.out.println("update Called");
	try{
	ChatPacket_t cp=(ChatPacket_t)o;

/*first what it want's*/
	switch(cp.getCode()){

	/* he tells' us his name so inform all others and store his info*/

	case INFORM_NAME_CODE:
		((ChatClientHandler)obj).chooseFrom(clientConn);
			clientConn.put(new Integer(cp.getSourceID()),
				(ChatClientHandler)obj);
      System.out.println("Registered User  "+(ChatClientHandler)obj);
      if(DEBUG){
        System.out.println("Hash="+clientConn);
        System.out.println("Added"+cp);
      }
			informAll(cp);
			break;

	/*the client want's to quit so call it's quit method and inform all
	** other chatter's
	*/

		case QUIT_CODE:
      System.out.println("Quitting User"+
        (ChatClientHandler)obj);
			clientConn.remove(new Integer(cp.getSourceID()));
			((ChatClientHandler)obj).quit();
			informAll(cp);
			break;
	/* client want to ( not from me) he want with destId   */
		default:
		((ChatClientHandler)clientConn.get(
		new Integer(cp.getDestID()))).request(cp);
	}
	}catch(IOException e){}
}
/**
* inform all the client connected about the request may be quit/name
*stored in the object ServerChatPacket sent by some one of them
**/
	private void informAll(ChatPacket_t cp) throws IOException{
		Integer key;
		Enumeration e=clientConn.keys();
		while(e.hasMoreElements()){
			 key=(Integer)e.nextElement();
  
		/* dont send it to the client who requested*/

			if(key.intValue()!=cp.getSourceID()) {
        if(DEBUG)
        System.out.println("Informing to client ="+key+"abnout"+cp);
			((ChatClientHandler)clientConn.get(key)).request(cp);
      }
		}
	}

	public void run(){
		try{
		ServerSocket sock=new ServerSocket(port);
		Socket socket;
		int id=0;
		while(true){
			socket=sock.accept();
			id++;

			ChatClientHandler ch=new ChatClientHandler(socket,id);
			ch.addObserver(this);
			Thread th=new Thread(ch);
			th.start();
		}
		}catch(IOException e){
			System.out.println("IOException in server ");
		}
	}
	public static void main(String []args){
		ChatServer server=new ChatServer();
		Thread th=new Thread(server);
		th.start();
	}
}
