
/* -*-Java-*- */
/*
 *  Copyright (C) 2000  Rakesh Sawan <sawan@mailcity.com>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
/**
*author @Rakesh Sawan
*Date   01-10-1999
**/
/**ChatPacket::Is an object which carries information as well as
*an imprint of it's origin ,it's destination and a code which 
*represents the type of the packet
*/
import java.io.*;
class ChatPacket_def{
	/**This variable is To identify the purpose of this packet
	*--We may want to send command or a message--
	**/
	protected int code;
	protected int sourceID;//Id of the sender of this packet
	protected int destID; //ID of receiver of this packet
	protected String contents;//contents of this packet
}
class ChatPacket_t extends ChatPacket_def implements Serializable{
	ChatPacket_t(int code,int sID,int dID,String mesg){
		this.code=code;
		this.sourceID=sID;
		this.destID=dID;
		contents=mesg;
		}
	public void setCode(int code){
		this.code=code;
	}
	public void setSourceID(int source){
		this.sourceID=source;
	}
	public void setDestID(int dest){
		this.destID=dest;
	}
	public void setMessage(String mesg){
		this.contents=mesg;
	}
	public int getCode(){
		return code;
	}
	public int getSourceID(){
		return sourceID;
	}
	public int getDestID(){
		return destID;
	}
	public String getMessage(){
		return contents;
	}
  public String toString(){
    return code+":"+sourceID+":"+destID+":"+contents;
  }

}



