
/* -*-Java-*- */
/*
 *  Copyright (C) 2000  Rakesh Sawan <sawan@mailcity.com>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
import java.io.*;

class ChatPacket{
	private int ind1;
	private int ind2;
	private int reqCode;
	private int id;
	private int myId;
	private String mesg;
	private static final int CHAT=1;
	private char ch;
	private static final char sepChar='~';
        ChatPacket(String str){
		ind1=str.indexOf(sepChar);
		ind2=str.indexOf(sepChar,ind1+1);
		System.out.println("String to parse"+str);
		System.out.println("ind1="+ind1+"ind2="+ind2);
			System.out.println("Char at 0"+str.charAt(0));
		try{
		reqCode=Integer.parseInt(str.substring(0,ind1));
		id=Integer.parseInt(str.substring(ind1+2,ind2));
		mesg=str.substring(ind2+1);
		}
		catch(NumberFormatException e){
			reqCode=Integer.parseInt(str.substring(1,ind1));
			id=Integer.parseInt(str.substring(ind1+2,ind2));
			mesg=str.substring(ind2+1);
		}

		}
		ChatPacket(String str,int myId){
			this(str);
			this.myId=myId;
		}
        ChatPacket(char ch,int id){
		this.ch=ch;
		reqCode=CHAT;
		this.id=id;
		mesg=""+ch;/* dummy mesg*/
		}
		ChatPacket(char ch,int id,int myId){
				this(ch,id);
				this.myId=myId;
		}
	public int getReqCode(){
		return reqCode;
	}
	public int getId(){
		return id;
	}
	public String getMesg(){
		return mesg;
	}
	public char getChar(){
		return ch;
	}
	public int getMyId(){
		return myId;
	}
}
		

