
/* -*-Java-*- */
/*
 *  Copyright (C) 2000  Rakesh Sawan <sawan@mailcity.com>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
import java.io.*;

class ChatOutputStream{
  protected static final int PACKET_HEADER=100;
  protected static final int PACKET_TAIL=101;
  private static boolean DEBUG=true;
	/**
	* EOC represents end of Packet
	**/
  private static final String EOP="\n";
	OutputStream out;
	ChatOutputStream(OutputStream out) throws IOException{
		this.out=out;
    DEBUG=Debug.DEBUG;
	}
	public void write(char ch) throws IOException{
		out.write(ch);
		out.flush();
	}
	public void write(String str) throws IOException{
    if(DEBUG)
    System.out.println("writing packet"+str);
		str=str+EOP;
		byte buf[]=new byte[str.length()];
		str.getBytes(0,buf.length,buf,0);
		out.write(buf);
		out.flush();
	}
  public void writePacket(ChatPacket_t cp) throws IOException {
    write(PACKET_HEADER+":"+cp.getCode()+":"+cp.getSourceID()+
    ":"+cp.getDestID()+":"+cp.getMessage()+":"+PACKET_TAIL);
    }

	public void close() throws IOException{
		out.close();
	}
}
