
/* -*-Java-*- */
/*
 *  Copyright (C) 2000  Rakesh Sawan <sawan@mailcity.com>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
import java.io.*;

class ChatInputStream {
	/**
	* EOC represents End of command
	**/
	protected static final int EOC=1;

  protected ChatPacket_t chatPacket;

	protected static final int buff_size=12000;
  protected static  boolean DEBUG=true;

	InputStream in;
  BufferedReader reader;

	ChatInputStream(InputStream in) throws IOException{
		this.in=in;
    reader=new BufferedReader(new InputStreamReader(in));
    DEBUG=Debug.DEBUG;
  }
  public ChatPacket_t readPacket() throws IOException,
  										BadChatInputStreamException{
	  boolean packetOK;
	  int retryCount=0;
	  String line;

	  //read one line from the input stream
	  do{ 
		  try{
			  line=reader.readLine();
			  if(DEBUG)
				  System.out.println("Inside reading loop");
			  chatPacket=ChatUtility.getPacket(line);
		  }catch(IOException e){
			  chatPacket=null;
			  if(DEBUG)
				  e.printStackTrace();
				 throw e;
		  }
	  }while(chatPacket==null);
	  return chatPacket;
  }

  public void close() throws IOException{
		in.close();
	}
}

		
		
