
/* -*-Java-*- */
/*
 *  Copyright (C) 2000  Rakesh Sawan <sawan@mailcity.com>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
import java.awt.*;
import java.io.*;

/*
 *
 * ChatFrame
 *
 */
class ChatFrame extends Frame implements ChatterImpl
	{
	private String myName;
	private String hisName;
	private Graphics g;
	private String iWrote[];
	private String heWrote[];
	private ChatServerHandler server;
	private Font myFont;
	private Font hisFont;
	private int myCharHeight;
	private int hisCharHeight;
	private FontMetrics myFm;
	private FontMetrics hisFm;
	private String myTmp,hisTmp;
	private  int myLineCount=1;
	private int hisLineCount=1;
	private  int myMaxLines;
	private int hisMaxLines;
	private static int over=0;
  private static boolean DEBUG=false;
	ChatFrame(String s,ChatServerHandler server){
		//super(s);
		this.server=server;
    DEBUG=Debug.DEBUG;

		setBackground(new Color(150,200,255));
		iWrote=new String[20];
		heWrote=new String[20];
		for(int i=0;i<=9;i++){
			iWrote[i]=" ";
			heWrote[i]=" ";
		}
	}
	public void show(){
		super.show();
		g=getGraphics();
		myFont=new Font("SansSerif",Font.BOLD|Font.ITALIC,15);
		hisFont=new Font("Helvetica",Font.BOLD|Font.ITALIC,15);
		g.setFont(myFont);
		FontMetrics myFm=g.getFontMetrics(myFont);

		myCharHeight=myFm.getHeight();
		myCharHeight++;
		g.setFont(hisFont);
		FontMetrics hisFm=g.getFontMetrics(hisFont);
		hisCharHeight=hisFm.getHeight();
		hisCharHeight++;
		myTmp=" ";
		hisTmp=" ";
		hisMaxLines=(size().height/2)/hisCharHeight;
		myMaxLines=(size().height/2)/myCharHeight;
	}

	public boolean handleEvent(Event evt){
		if(evt.id==Event.WINDOW_DESTROY){
			hide();
			return true;
		}
		super.handleEvent(evt);
		try{
			hisMaxLines=(size().height/2)/hisCharHeight;
			myMaxLines=(size().height/2)/myCharHeight;
			if(myLineCount>myMaxLines) myLineCount=myMaxLines;
			if(hisLineCount>hisMaxLines) hisLineCount=hisMaxLines;
		}catch(Exception ex){}
		return false;
	}
	public void paint(Graphics g){
		for(int i=0;i<=myMaxLines;i++){
			g.setFont(myFont);
			g.setColor(Color.yellow);
			g.drawString(iWrote[i],2,i*myCharHeight+myCharHeight);
		}
		for(int i=0;i<=hisMaxLines;i++){
			g.setFont(hisFont);
			g.setColor(Color.black);
			//g.drawString(heWrote[i],2,i*hisCharHeight+hisCharHeight+
			g.drawString(heWrote[i],2,i*hisCharHeight+
				size().height/2);
		}
	}
	public void appendToMe(){
		g.setFont(myFont);
		FontMetrics fm=g.getFontMetrics(myFont);
		int w=fm.stringWidth(iWrote[myLineCount]);
		repaint();
		if(w>=(size().width-fm.charWidth('D')*2)){
			myLineCount++;
			iWrote[myLineCount]=" ";
		}
		if(myMaxLines<=myLineCount){
			myLineCount=1;
			iWrote[myLineCount]=" ";

		}
	}
	public void appendToHis(String s){
		int key=(int)s.charAt(0);
		if(key==8){
			//Backspace key remove the last character
			heWrote[hisLineCount]=heWrote[hisLineCount].substring(0,
				heWrote[hisLineCount].length()-1);
		}else if(key==MAGIC_ENTER_KEY){
			//New line key
			hisLineCount++;
			heWrote[hisLineCount]=" ";
		}
		else
		heWrote[hisLineCount]+=s;

		g.setFont(hisFont);
		FontMetrics fm=g.getFontMetrics(hisFont);
		int w=fm.stringWidth(heWrote[hisLineCount]);
		repaint();
		if(w>=(size().width-fm.charWidth('D')*2)){
			hisLineCount++;
			heWrote[hisLineCount]=" ";
		}

		if(hisMaxLines<=hisLineCount){
			hisLineCount=1;
			heWrote[hisLineCount]=" ";
		}

	}

	public boolean keyDown(Event evt,int key){
		if(key==8){
			//Backspace key remove the last character
			iWrote[myLineCount]=iWrote[myLineCount].substring(0,
				iWrote[myLineCount].length()-1);
		}else if(key=='\n'||key=='\r'){
			//New line key
			key=MAGIC_ENTER_KEY;
			myLineCount++;
			iWrote[myLineCount]=" ";
		}
		else
			iWrote[myLineCount]+=(char)key;
		try{
		server.chat((char)key);
		}catch(IOException e){}
		appendToMe();
			
		return true;
	}

}



