
/* -*-Java-*- */
/*
 *  Copyright (C) 2000  Rakesh Sawan <sawan@mailcity.com>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
import java.io.*;
import java.util.*;
import java.net.*;
/**
*This class extebds Observable class hence inform the server
* about the client requests by calling it's setChanged() and 
*notifyObserver() method's and passes a class object ServerChatPacket
*yes packet because it is packed with information about request
**/

class ChatClientHandler extends Observable implements Runnable,
  ChatterImpl{
	/*here goes variable declaration*/
	protected ChatSocket sock;

	protected ChatInputStream in;

	protected ChatOutputStream out;

	/** 
	*myId it is my integer id number given to me by server
	**/
	protected int myID;

	/*This is the id of the destination where our requested has to
	*be forwarded
	**/
	protected int destID;

	/**
	* name of our GUI client we are handling
	**/
	protected String name=null;

  protected static boolean DEBUG=false;

	ChatClientHandler(Socket socket,int id) throws IOException{
		sock=new ChatSocket(socket);
		this.myID=id;
		in=sock.getChatInputStream();
		out=sock.getChatOutputStream();
    DEBUG=Debug.DEBUG;
		/**
		*tell the client his id number
		**/
    try{

    System.out.println("New Chatter Says: "+in.readPacket().getMessage());

		out.writePacket(new ChatPacket_t(ASSIGN_ID_CODE,SERVER_ID,
      myID,"Welcome to Chat Online"));

    }catch(Exception e){
      if(DEBUG){
        e.printStackTrace();
        System.out.println("Error in constructor ChatServerHandler");
      }
    }

	}
/**
*forward The Packet to server so that server will forward it to
* The Chatter we want
**/
private void forwardPacket(ChatPacket_t cp){
    if(cp.getCode()==INFORM_NAME_CODE)
      name=cp.getMessage();
		setChanged();
		notifyObservers(cp);

}
/**
*some one want to chat with us ok let's send it to our GUI client
**/
	public void chat(ChatPacket_t cp) throws IOException{
		out.writePacket(cp);
	}
/**
*We Had enough chat let's quit
**/
	public void quit() throws IOException{
		in.close();
		out.close();
	}
/**
*Server is requesting us to listen the request from to Some Other Chatter
**/
	public void request(ChatPacket_t cp) throws IOException{
  	out.writePacket(cp);
	}
/**
*Server is telling to choose from the list of available chatters
**/
public void chooseFrom(Hashtable chatterInfo) throws IOException{
		Enumeration e=chatterInfo.keys();
		Integer id;
		String name;
		while(e.hasMoreElements()){
			id=(Integer)e.nextElement();
			name=((ChatClientHandler)chatterInfo.get(id)).toString();
      /**This one is not logical but the client expect that the
      *source id should be equal to the ID of the chatter not
      *The actual source ID i.e. SERVER_ID..Ohh! confusing.
      **/
      if(id.intValue()!=myID)
			out.writePacket(new ChatPacket_t(INFORM_NAME_CODE,
          id.intValue(),myID,name));
      if(DEBUG)
      System.out.println("Choose:"+name+"ID="+id.intValue());

		}
	}
  private void write(int code,int destID,String mesg) throws
     IOException{
    out.writePacket(new ChatPacket_t(code,myID,destID,mesg));
  }

	public String toString(){
		return name;
	}

	public void run(){
    ChatPacket_t cp;
    while(true){
      try{

       cp=in.readPacket();
        if(DEBUG){
        System.out.println("Got Packet"+cp);
        }

       forwardPacket(cp);
       if(cp.getCode()==QUIT_CODE)
        return;

  		}catch(Exception e){
        if(DEBUG){
          System.out.println("Exception in run method of "+
          "ChatClientHandler"+e);
          e.printStackTrace();
        }
          System.out.println("Quit:Abnormal:Run()");
          forwardPacket(new
            ChatPacket_t(QUIT_CODE,myID,SERVER_ID,"Error reading"));
            
          try{
          in.close();
          }catch(Exception ignEx){}
          return;
      }
    }
	}
}






