/**<applet code=Chat height=300 width=300 ></applet>**/
/* -*-Java-*- */
/*
 *  Copyright (C) 2000  Rakesh Sawan <sawan@mailcity.com>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
import java.util.*;
import java.io.*;
import java.net.*;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;

public class Chat extends Applet implements
			 ActionListener,Observer,ChatterImpl {
  private ChatServerHandler  server;
  private String serverName;
  private boolean single = false;
  private String name;
  private String others_name;
  private Panel topPanel;
  private Label prompt;
  private TextField namefield;
  private StringBuffer iTold;
  private StringBuffer heTold;
  private Graphics g;
  private int charWidth;
  private int charHeight;
  private int curX,curY;
  private int width,height;
  private Button select;
  private Button quitButton;
  private ChatFrame myChat;
  private  Panel selectPanel;
  private static int server_port=9000;
  protected static  boolean DEBUG=false;
  private Thread serverHandlerThread;
  private boolean connected=false;
  private java.awt.List idList;


  public void init() {
	width=size().width;
	height=size().height;
  DEBUG=Debug.DEBUG;
  idList=new java.awt.List(1,false);

    setLayout(new BorderLayout());
    serverName = getCodeBase().getHost();
    if (serverName.equals(""))
      serverName = "localhost";
  }
  public void start() {
    try {
      if(!connected)
      connect();
      if (name == null) {
        if(topPanel!=null){
        topPanel.remove(prompt);
        topPanel.remove(namefield);
        remove(topPanel);
        }
        askInfo();
        validate();
      } else {
       // nameEntered(name);
      }
      //validate();
	}catch(Exception e){
    e.printStackTrace();
      single = true;
      start_Chat();
    }

  }
  private void connect() throws IOException{
    try{

      showStatus("Connecting to " + serverName);
      if(DEBUG)
        System.out.println("Connecting to " + serverName);
      server = new ChatServerHandler(serverName,server_port);
	  server.addObserver(this);
	  serverHandlerThread=new Thread(server);
	  serverHandlerThread.start();

      showStatus("Connected: " + serverName);
      connected=true;
		}
			catch(SocketException e){
				showStatus("server not found");
				System.out.println("unable to connect to server");
		}
  }

  public void stop() {
   /*if (!single)
	   try{
     server.quit();
   }catch(IOException e){};
   */
  }

  public void update(Observable obj,Object o){
	  ChatPacket_t cp=(ChatPacket_t)o;
	  ChatServerHandler handler=(ChatServerHandler)obj;
    if(DEBUG)
	  System.out.println("Packet"+cp);
	  switch(cp.getCode()){
	  case INFORM_NAME_CODE:
      System.out.println("Adding="+cp);
		  add(cp.getSourceID(),cp.getMessage());
		  break;
	  case REQUEST_CODE:
			acceptRequest(cp.getSourceID());
		  break;
	  case REJECT_CODE:
		  break;
	  case ACCEPT_CODE:
			acceptConfirmed(cp.getSourceID());
		  break;
	  case CHAT_CODE:
		  chat(cp.getSourceID(),cp.getMessage());
		  break;
	  case QUIT_CODE:
		  quit(cp.getSourceID());
		  break;
    default: System.out.println("Invalid Protocol"+cp);
	  }
  }




  void add(int id,String name) {
    if(DEBUG)
	  System.out.println("add called");
    delete(id); // in case it is already there.
    idList.addItem("(" + id + ")  " + name);
    if(DEBUG){
    System.out.println("Add over");
    System.out.println("Items in the list="+idList.getItemCount());
    }
    showStatus("Choose any one from the list");
    validate();
  }
  void delete(int id) {
    for (int i = 0; i < idList.getItemCount(); i++) {
      String s = idList.getItem(i);
      int id1 = Integer.parseInt(s.substring(s.indexOf("(")
			+ 1, s.indexOf(")")));
      if (id1==id) {
        idList.delItem(i);
        break;
      }
    }
    if (idList.getItemCount() == 0 )
      showStatus("Wait for other's to arrive.");
  }
  private String getName(int id) {
    for (int i = 0; i < idList.getItemCount(); i++) {
      String s = idList.getItem(i);
      int id1 = Integer.parseInt(s.substring(s.indexOf("(")
			+ 1, s.indexOf(")")));
      if (id1==id) {
        return s.substring(s.indexOf(" ") + 3);
      }
    }
    return null;
  }
  // we've been requested by "id".
  void acceptRequest(int id) {
    others_name = getName(id);   // who was it?
    showStatus("challenged by " + others_name);

    // put some confirmation here...

    server.acceptRequest(id,"str");
    //server.delete();
    start_Chat();
  }
  // our challenge was accepted.
  void acceptConfirmed(int id) {
    others_name = getName(id);
    //server.delete();
    start_Chat();
  }
  void chat(int id, String s) {
	 myChat.appendToHis(s);
    showStatus(" you are talking to"+others_name);
  }
  
  void quit(int id) {
    if(others_name!=null){
    showStatus(others_name + " just quit.");
    System.out.println(others_name + " just quit.");
	  delete(id);
	//	remove(select);
//		remove(idList);
		remove(quitButton);
    /*selectPanel.remove(idList);
    selectPanel.remove(select);
    remove(selectPanel);*/
	  nameEntered(name);
		myChat.hide();
    System.out.println("Our fellow chatter quitted");
    }
    else{
      delete(id);
    }
    validate();
  }
  private void nameEntered(String s) {
    if (s.equals(""))
      return;
    name = s;
    if (idList != null)
      remove(idList);
    if (select != null)
      remove(select);
	  selectPanel=new Panel();
    System.out.println("Items in the list="+idList.getItemCount());
    selectPanel.add("South",idList);
    select = new Button("Select any one from the list");
    select.addActionListener(this);
    selectPanel.add("Center",select);
	add("North",selectPanel);
    validate();
   // server.setName(name);
	Font textFont=new Font("Helvetica",Font.BOLD,12);
	g=getGraphics();
	FontMetrics fmat=g.getFontMetrics();
	charWidth=fmat.stringWidth("c");
	charHeight=fmat.getHeight();
	curX=10;
	curY=10;
    showStatus("Wait for some one to arrive.");
    if (topPanel != null)
      remove(topPanel);
  }
  private void start_Chat() {
    if (single) {
      Frame popup = new Frame("Chat Online");
      popup.setSize(200,200);
      popup.setResizable(false);
      popup.show();
      showStatus("no server found How to Chat?????");
    } else {
    selectPanel.remove(idList);
    selectPanel.remove(select);
    remove(selectPanel);
	  quitButton=new Button("quit!!");
	  quitButton.addActionListener(this);
	  add("East",quitButton);
	  iTold=new StringBuffer();
	  heTold=new StringBuffer();
	  g.setColor(Color.green);
    System.out.println("opening chat Window");
		myChat=new ChatFrame("chat here",server);
		myChat.resize(600,250);
		myChat.show();
    System.out.println("Chat Window Opened");

      showStatus("you are talking to " + others_name);
    }

    validate();

  }
  private void request_him() throws IOException{
    String s = idList.getSelectedItem();
    if (s == null) {
      showStatus("Choose a player from the list then press Challenge");
    } else {
     selectPanel.remove(idList);
    selectPanel.remove(select);
    remove(selectPanel);
      int destid =Integer.parseInt(
					s.substring(s.indexOf('(')+1, s.indexOf(')')));
          showStatus("challenging: " + destid);
          System.out.println("challenging: " + destid);
          server.request(destid);  // accept will get called if
                                 // they accept.
      validate();
    }
  }
  public void appendToHis(String s){
  }
  public void appendToMe(String s){
  }

   public void actionPerformed(ActionEvent ae) {
    Object source = ae.getSource();
    if(source == select) {
		try{
		   request_him();
		}catch(IOException e){
			System.out.println("unable to request");
			System.exit(0);
		}
    }
    else if(source == namefield) {
	  remove(topPanel);
      TextComponent tc = (TextComponent)source;
      String name=tc.getText();
      server.setName(name);
      nameEntered(name);
    }
	else if(source==quitButton){
		try{
		server.quit();
    serverHandlerThread.stop();
    remove(quitButton);
		myChat.hide();
    name=null;
    connected=false;
    start();
    System.out.println("Quitting");
//    nameEntered(name);
    validate();
		}catch(IOException e){
			System.out.println("IOException while quitting");
		}
	}
  }
  private void askInfo(){
        if(DEBUG)
        System.out.println("Inside Askinfo");
        prompt = new Label("Enter your nic-name here!!:");
        namefield = new TextField(20);
        namefield.addActionListener(this);
        topPanel = new Panel();
        topPanel.setBackground(new Color(255, 255, 200));
        topPanel.add(prompt);
        topPanel.add(namefield);
		    add("Center",topPanel);
}

}
