/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.util.Observable;

class ChatServerHandler
extends Observable
implements ChatterImpl,
Runnable {
    ChatSocket sock;
    protected ChatInputStream in;
    protected ChatOutputStream out;
    protected int destID;
    protected int myID = -1;
    protected static boolean DEBUG = true;
    protected static String to = null;

    ChatServerHandler(String string, int n) throws IOException {
        DEBUG = false;
        this.sock = new ChatSocket(string, n);
        this.in = this.sock.getChatInputStream();
        this.out = this.sock.getChatOutputStream();
        System.out.println("connected.......sending hello");
        this.write(50010, 50011, "Hi Server");
    }

    public void acceptRequest(int n, String string) {
        this.write(50004, n, string);
        if (DEBUG) {
            System.out.println("Setting destId=" + this.destID);
        }
        this.destID = n;
    }

    public void chat(char c) throws IOException {
        this.write(50001, this.destID, String.valueOf(c));
        if (DEBUG) {
            System.out.println("Writing to chatter= " + this.destID + ":" + c);
        }
    }

    public void go() {
        new Thread(this).start();
    }

    private void informChatterGUI(ChatPacket_t chatPacket_t) {
        if (chatPacket_t.getCode() == 50009) {
            this.myID = chatPacket_t.getDestID();
            if (DEBUG) {
                System.out.println("I am assigned ID=" + this.myID);
            }
        } else {
            if (chatPacket_t.getCode() == 50004) {
                this.destID = chatPacket_t.getSourceID();
            }
            this.setChanged();
            this.notifyObservers(chatPacket_t);
        }
    }

    public void quit() throws IOException {
        this.write(50007, 50011, "quitting");
    }

    public void reject(int n, String string) throws IOException {
        this.write(50005, n, string);
    }

    public void request(int n) {
        this.write(50003, n, "will you talk to me");
    }

    public void run() {
        try {
            while (true) {
                ChatPacket_t chatPacket_t = this.in.readPacket();
                this.informChatterGUI(chatPacket_t);
            }
        }
        catch (Exception exception) {
            if (DEBUG) {
                System.out.println("Exception in run method of ChatServerHandler" + exception);
                exception.printStackTrace();
            }
            try {
                this.in.close();
            }
            catch (Exception exception2) {}
            return;
        }
    }

    public void setName(String string) {
        this.write(50000, 50011, string);
    }

    public void write(int n, int n2, String string) {
        block2: {
            try {
                this.out.writePacket(new ChatPacket_t(n, this.myID, n2, string));
            }
            catch (IOException iOException) {
                if (!DEBUG) break block2;
                System.out.println("exception" + iOException);
            }
        }
    }
}

