/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Observable;
import java.util.Observer;

class ChatServer
implements Observer,
Runnable,
ChatterImpl {
    protected static int port = 9000;
    protected static boolean DEBUG = true;
    protected Hashtable clientConn = new Hashtable();

    ChatServer() {
        DEBUG = false;
    }

    private void informAll(ChatPacket_t chatPacket_t) throws IOException {
        Enumeration enumeration = this.clientConn.keys();
        while (enumeration.hasMoreElements()) {
            Integer n = (Integer)enumeration.nextElement();
            if (n.intValue() == chatPacket_t.getSourceID()) continue;
            if (DEBUG) {
                System.out.println("Informing to client =" + n + "abnout" + chatPacket_t);
            }
            ((ChatClientHandler)this.clientConn.get(n)).request(chatPacket_t);
        }
    }

    public static void main(String[] stringArray) {
        ChatServer chatServer = new ChatServer();
        Thread thread = new Thread(chatServer);
        thread.start();
    }

    public void run() {
        try {
            ServerSocket serverSocket = new ServerSocket(port);
            int n = 0;
            while (true) {
                Socket socket = serverSocket.accept();
                ChatClientHandler chatClientHandler = new ChatClientHandler(socket, ++n);
                chatClientHandler.addObserver(this);
                Thread thread = new Thread(chatClientHandler);
                thread.start();
            }
        }
        catch (IOException iOException) {
            System.out.println("IOException in server ");
            return;
        }
    }

    public void update(Observable observable, Object object) {
        if (DEBUG) {
            System.out.println("update Called");
        }
        try {
            ChatPacket_t chatPacket_t = (ChatPacket_t)object;
            switch (chatPacket_t.getCode()) {
                case 50000: {
                    ((ChatClientHandler)observable).chooseFrom(this.clientConn);
                    this.clientConn.put(new Integer(chatPacket_t.getSourceID()), (ChatClientHandler)observable);
                    System.out.println("Registered User  " + (ChatClientHandler)observable);
                    if (DEBUG) {
                        System.out.println("Hash=" + this.clientConn);
                        System.out.println("Added" + chatPacket_t);
                    }
                    this.informAll(chatPacket_t);
                    break;
                }
                case 50007: {
                    System.out.println("Quitting User" + (ChatClientHandler)observable);
                    this.clientConn.remove(new Integer(chatPacket_t.getSourceID()));
                    ((ChatClientHandler)observable).quit();
                    this.informAll(chatPacket_t);
                    break;
                }
                default: {
                    ((ChatClientHandler)this.clientConn.get(new Integer(chatPacket_t.getDestID()))).request(chatPacket_t);
                    break;
                }
            }
        }
        catch (IOException iOException) {}
    }
}

